/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Filters.Threshold;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageHistogram;
import Catalano.Imaging.Tools.ImageStatistics;

public class MaximumEntropyThreshold
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int entropy = this.CalculateThreshold(fastBitmap);
        Threshold t = new Threshold(entropy);
        t.applyInPlace(fastBitmap);
    }

    public int CalculateThreshold(FastBitmap fastBitmap) {
        ImageStatistics stat = new ImageStatistics(fastBitmap);
        ImageHistogram hist = stat.getHistogramGray();
        int[] histogram = hist.getValues();
        double sum = 0.0;
        for (int i = 0; i < histogram.length; ++i) {
            sum += (double)histogram[i];
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Empty histogram: sum of all bins is zero.");
        }
        double[] normalizedHist = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            normalizedHist[i] = (double)histogram[i] / sum;
        }
        double[] pT = new double[histogram.length];
        pT[0] = normalizedHist[0];
        for (int i = 1; i < histogram.length; ++i) {
            pT[i] = pT[i - 1] + normalizedHist[i];
        }
        double epsilon = Double.MIN_VALUE;
        double[] hB = new double[histogram.length];
        double[] hW = new double[histogram.length];
        for (int t = 0; t < histogram.length; ++t) {
            if (pT[t] > Double.MIN_VALUE) {
                double hhB = 0.0;
                for (int i = 0; i <= t; ++i) {
                    if (!(normalizedHist[i] > Double.MIN_VALUE)) continue;
                    hhB -= normalizedHist[i] / pT[t] * Math.log(normalizedHist[i] / pT[t]);
                }
                hB[t] = hhB;
            } else {
                hB[t] = 0.0;
            }
            double pTW = 1.0 - pT[t];
            if (pTW > Double.MIN_VALUE) {
                double hhW = 0.0;
                for (int i = t + 1; i < histogram.length; ++i) {
                    if (!(normalizedHist[i] > Double.MIN_VALUE)) continue;
                    hhW -= normalizedHist[i] / pTW * Math.log(normalizedHist[i] / pTW);
                }
                hW[t] = hhW;
                continue;
            }
            hW[t] = 0.0;
        }
        double jMax = hB[0] + hW[0];
        int tMax = 0;
        for (int t = 1; t < histogram.length; ++t) {
            double j = hB[t] + hW[t];
            if (!(j > jMax)) continue;
            jMax = j;
            tMax = t;
        }
        return tMax;
    }
}

