/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Log
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int j;
            int i;
            double scale = 255.0 / Math.log(255.0);
            if (this.share.fastBitmap.isGrayscale()) {
                for (i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        double v = this.share.fastBitmap.getGray(i, j);
                        if (v != 0.0) {
                            v = Math.log(v) * scale;
                        }
                        if (v < 0.0) {
                            v = 0.0;
                        }
                        if (v > 255.0) {
                            v = 255.0;
                        }
                        this.share.fastBitmap.setGray(i, j, (int)v);
                    }
                }
            }
            if (this.share.fastBitmap.isRGB()) {
                for (i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        double r = this.share.fastBitmap.getRed(i, j);
                        double g = this.share.fastBitmap.getGreen(i, j);
                        double b = this.share.fastBitmap.getBlue(i, j);
                        if (r != 0.0) {
                            r = Math.log(r) * scale;
                        }
                        if (g != 0.0) {
                            g = Math.log(g) * scale;
                        }
                        if (b != 0.0) {
                            b = Math.log(b) * scale;
                        }
                        if (r < 0.0) {
                            r = 0.0;
                        }
                        if (r > 255.0) {
                            r = 255.0;
                        }
                        if (g < 0.0) {
                            g = 0.0;
                        }
                        if (g > 255.0) {
                            g = 255.0;
                        }
                        if (b < 0.0) {
                            b = 0.0;
                        }
                        if (b > 255.0) {
                            b = 255.0;
                        }
                        this.share.fastBitmap.setRed(i, j, (int)r);
                        this.share.fastBitmap.setGreen(i, j, (int)g);
                        this.share.fastBitmap.setBlue(i, j, (int)b);
                    }
                }
            }
        }
    }
}

