/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;

public class ImageNormalization
implements IApplyInPlace {
    private float mean = 160.0f;
    private float variance = 150.0f;
    private float globalMean;
    private float globalVariance;

    public float getMean() {
        return this.mean;
    }

    public void setMean(float mean) {
        this.mean = Math.max(0.0f, Math.min(255.0f, mean));
    }

    public float getVariance() {
        return this.variance;
    }

    public void setVariance(float variance) {
        this.variance = Math.max(0.0f, Math.min(255.0f, variance));
    }

    public ImageNormalization() {
    }

    public ImageNormalization(float mean, float variance) {
        this.setMean(mean);
        this.setVariance(variance);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("ImageNormalization only works in grayscale images.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        this.globalMean = ImageStatistics.Mean(fastBitmap);
        this.globalVariance = ImageStatistics.Variance(fastBitmap);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                    int g = this.share.fastBitmap.getGray(i, j);
                    float common = (float)Math.sqrt(ImageNormalization.this.variance * (float)Math.pow((float)g - ImageNormalization.this.globalMean, 2.0) / ImageNormalization.this.globalVariance);
                    int n = 0;
                    n = (float)g > ImageNormalization.this.globalMean ? (int)(ImageNormalization.this.mean + common) : (int)(ImageNormalization.this.mean - common);
                    n = n > 255 ? 255 : n;
                    n = n < 0 ? 0 : n;
                    this.share.fastBitmap.setGray(i, j, n);
                }
            }
        }
    }
}

