/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Core.FloatRange;
import Catalano.Core.IntRange;
import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class HSLFiltering
implements IApplyInPlace {
    private IntRange hue = new IntRange(0, 359);
    private FloatRange saturation = new FloatRange(0.0f, 1.0f);
    private FloatRange luminance = new FloatRange(0.0f, 1.0f);
    private int fillH = 0;
    private float fillS = 0.0f;
    private float fillL = 0.0f;
    private boolean fillOutsideRange = true;
    private boolean updateH = true;
    private boolean updateS = true;
    private boolean updateL = true;

    public IntRange getHue() {
        return this.hue;
    }

    public void setHue(IntRange hue) {
        this.hue = hue;
    }

    public FloatRange getSaturation() {
        return this.saturation;
    }

    public void setSaturation(FloatRange saturation) {
        this.saturation = saturation;
    }

    public FloatRange getLuminance() {
        return this.luminance;
    }

    public void setLuminance(FloatRange luminance) {
        this.luminance = luminance;
    }

    public float[] getFillColor() {
        return new float[]{this.fillH, this.fillS, this.fillL};
    }

    public void setFillColor(int hue, float saturation, float luminance) {
        this.fillH = hue;
        this.fillS = saturation;
        this.fillL = luminance;
    }

    public boolean isFillOutsideRange() {
        return this.fillOutsideRange;
    }

    public void setFillOutsideRange(boolean fillOutsideRange) {
        this.fillOutsideRange = fillOutsideRange;
    }

    public boolean isUpdatedHue() {
        return this.updateH;
    }

    public void setUpdateHue(boolean update) {
        this.updateH = update;
    }

    public boolean isUpdatedSaturation() {
        return this.updateS;
    }

    public void setUpdateSaturation(boolean update) {
        this.updateS = update;
    }

    public boolean isUpdatedLuminance() {
        return this.updateL;
    }

    public void setUpdateLuminance(boolean update) {
        this.updateL = update;
    }

    public HSLFiltering() {
    }

    public HSLFiltering(IntRange hue, FloatRange saturation, FloatRange luminance) {
        this.hue = hue;
        this.saturation = saturation;
        this.luminance = luminance;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isRGB()) {
            throw new IllegalArgumentException("HSL Filtering only works in RGB space color.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.endWidth; ++j) {
                    int b;
                    int g;
                    boolean updated = false;
                    int r = this.share.fastBitmap.getRed(i, j);
                    double[] hsl = ColorConverter.RGBtoHSL(r, g = this.share.fastBitmap.getGreen(i, j), b = this.share.fastBitmap.getBlue(i, j));
                    if (hsl[1] >= (double)HSLFiltering.this.saturation.getMin() && hsl[1] <= (double)HSLFiltering.this.saturation.getMax() && hsl[2] >= (double)HSLFiltering.this.luminance.getMin() && hsl[2] <= (double)HSLFiltering.this.luminance.getMax() && (HSLFiltering.this.hue.getMin() < HSLFiltering.this.hue.getMax() && hsl[0] >= (double)HSLFiltering.this.hue.getMin() && hsl[0] <= (double)HSLFiltering.this.hue.getMax() || HSLFiltering.this.hue.getMin() > HSLFiltering.this.hue.getMax() && (hsl[0] >= (double)HSLFiltering.this.hue.getMin() || hsl[0] <= (double)HSLFiltering.this.hue.getMax()))) {
                        if (!HSLFiltering.this.fillOutsideRange) {
                            if (HSLFiltering.this.updateH) {
                                hsl[0] = HSLFiltering.this.fillH;
                            }
                            if (HSLFiltering.this.updateS) {
                                hsl[1] = HSLFiltering.this.fillS;
                            }
                            if (HSLFiltering.this.updateL) {
                                hsl[2] = HSLFiltering.this.fillL;
                            }
                            updated = true;
                        }
                    } else if (HSLFiltering.this.fillOutsideRange) {
                        if (HSLFiltering.this.updateH) {
                            hsl[0] = HSLFiltering.this.fillH;
                        }
                        if (HSLFiltering.this.updateS) {
                            hsl[1] = HSLFiltering.this.fillS;
                        }
                        if (HSLFiltering.this.updateL) {
                            hsl[2] = HSLFiltering.this.fillL;
                        }
                        updated = true;
                    }
                    if (!updated) continue;
                    int[] rgb = ColorConverter.HSLtoRGB(hsl[0], hsl[1], hsl[2]);
                    this.share.fastBitmap.setRGB(i, j, rgb);
                }
            }
        }
    }
}

