/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Convolution
implements IApplyInPlace {
    private int[][] kernel;
    private int division;
    private boolean useDiv = false;
    private FastBitmap copy;
    private boolean replicate = false;

    public int[][] getKernel() {
        return this.kernel;
    }

    public void setKernel(int[][] kernel) {
        this.kernel = kernel;
    }

    public void setDivision(int division) {
        this.division = division;
        this.useDiv = true;
    }

    public boolean isReplicate() {
        return this.replicate;
    }

    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public Convolution() {
    }

    public Convolution(int[][] kernel) {
        this.kernel = kernel;
    }

    public Convolution(int[][] kernel, boolean replicate) {
        this.kernel = kernel;
        this.replicate = replicate;
    }

    public Convolution(int[][] kernel, int division) {
        this.kernel = kernel;
        this.division = division;
        this.useDiv = true;
    }

    public Convolution(int[][] kernel, int division, boolean replicate) {
        this.kernel = kernel;
        this.division = division;
        this.replicate = replicate;
        this.useDiv = true;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        this.copy = new FastBitmap(fastBitmap);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private int CalcLines(int[][] kernel) {
        int lines = (kernel[0].length - 1) / 2;
        return lines;
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines;
            int safe = lines = Convolution.this.CalcLines(Convolution.this.kernel);
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int div = 0;
                        int gray = 0;
                        for (int i = 0; i < Convolution.this.kernel.length; ++i) {
                            int Xline = x + (i - lines);
                            for (int j = 0; j < Convolution.this.kernel[0].length; ++j) {
                                int Yline = y + (j - lines);
                                if (Xline >= 0 && Xline < this.share.endHeight + safe && Yline >= 0 && Yline < this.share.fastBitmap.getWidth()) {
                                    gray += Convolution.this.kernel[i][j] * Convolution.this.copy.getGray(Xline, Yline);
                                    div += Convolution.this.kernel[i][j];
                                    continue;
                                }
                                if (!Convolution.this.replicate) continue;
                                int r = x + i - lines;
                                int c = y + j - lines;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (r >= this.share.endHeight) {
                                    r = this.share.endHeight - 1;
                                }
                                if (c < 0) {
                                    c = 0;
                                }
                                if (c >= this.share.fastBitmap.getWidth()) {
                                    c = this.share.fastBitmap.getWidth() - 1;
                                }
                                gray += Convolution.this.kernel[i][j] * Convolution.this.copy.getGray(r, c);
                                div += Convolution.this.kernel[i][j];
                            }
                        }
                        if (div != 0) {
                            gray = Convolution.this.useDiv ? (gray /= Convolution.this.division) : (gray /= div);
                        }
                        gray = gray > 255 ? 255 : gray;
                        gray = gray < 0 ? 0 : gray;
                        this.share.fastBitmap.setGray(x, y, gray);
                    }
                }
            } else {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int div = 0;
                        int b = 0;
                        int g = 0;
                        int r = 0;
                        for (int i = 0; i < Convolution.this.kernel.length; ++i) {
                            int Xline = x + (i - lines);
                            for (int j = 0; j < Convolution.this.kernel[0].length; ++j) {
                                int Yline = y + (j - lines);
                                if (Xline >= 0 && Xline < this.share.endHeight + safe && Yline >= 0 && Yline < this.share.fastBitmap.getWidth()) {
                                    r += Convolution.this.kernel[i][j] * Convolution.this.copy.getRed(Xline, Yline);
                                    g += Convolution.this.kernel[i][j] * Convolution.this.copy.getGreen(Xline, Yline);
                                    b += Convolution.this.kernel[i][j] * Convolution.this.copy.getBlue(Xline, Yline);
                                    div += Convolution.this.kernel[i][j];
                                    continue;
                                }
                                if (!Convolution.this.replicate) continue;
                                int rr = x + i - lines;
                                int cc = y + j - lines;
                                if (rr < 0) {
                                    rr = 0;
                                }
                                if (rr >= this.share.endHeight) {
                                    rr = this.share.endHeight - 1;
                                }
                                if (cc < 0) {
                                    cc = 0;
                                }
                                if (cc >= this.share.fastBitmap.getWidth()) {
                                    cc = this.share.fastBitmap.getWidth() - 1;
                                }
                                r += Convolution.this.kernel[i][j] * Convolution.this.copy.getRed(rr, cc);
                                g += Convolution.this.kernel[i][j] * Convolution.this.copy.getGreen(rr, cc);
                                b += Convolution.this.kernel[i][j] * Convolution.this.copy.getBlue(rr, cc);
                                div += Convolution.this.kernel[i][j];
                            }
                        }
                        if (div != 0) {
                            if (Convolution.this.useDiv) {
                                r /= Convolution.this.division;
                                g /= Convolution.this.division;
                                b /= Convolution.this.division;
                            } else {
                                r /= div;
                                g /= div;
                                b /= div;
                            }
                        }
                        r = r > 255 ? 255 : r;
                        g = g > 255 ? 255 : g;
                        b = b > 255 ? 255 : b;
                        r = r < 0 ? 0 : r;
                        g = g < 0 ? 0 : g;
                        b = b < 0 ? 0 : b;
                        this.share.fastBitmap.setRGB(x, y, r, g, b);
                    }
                }
            }
        }
    }
}

