/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.ActiveContour.Ovuscule;

import Catalano.Core.DoublePoint;
import Catalano.Imaging.ActiveContour.Ovuscule.IOvusculeSnake2D;
import Catalano.Imaging.ActiveContour.Ovuscule.OvusculeSnake2DNode;
import Catalano.Imaging.ActiveContour.Ovuscule.OvusculeSnake2DScale;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.FastGraphics;
import Catalano.Imaging.Shapes.IntPolygon;

public class OvusculeSnake2DKeeper {
    private Double energy = null;
    private IOvusculeSnake2D snake = null;
    private boolean optimizing = false;
    private static final double COMPLEMENTARY_GOLDEN_RATIO = 0.38196601125010515;
    private static final double GOLDEN_RATIO = 1.618033988749895;
    private static final double MAXIMAL_PARABOLIC_EXCURSION = 100.0;
    private static final double SQRT_TINY = Math.sqrt(Float.intBitsToFloat(0x33FFFFFF));
    private static final double TINY = Float.intBitsToFloat(0x33FFFFFF);

    public void Optimize(IOvusculeSnake2D snake) {
        this.snake = snake;
        this.energy = null;
        this.optimizing = true;
        OvusculeSnake2DNode[] youngSnake = snake.getNodes();
        int K = youngSnake.length;
        OvusculeSnake2DNode[] X = new OvusculeSnake2DNode[K];
        for (int k = 0; k < K; ++k) {
            X[k] = new OvusculeSnake2DNode(youngSnake[k].x, youngSnake[k].y, youngSnake[k].frozen, youngSnake[k].hidden);
        }
        this.Optimize(X);
    }

    private void Optimize(OvusculeSnake2DNode[] X) {
        double totalDisplacement;
        int K = X.length;
        DoublePoint[] V = new DoublePoint[K];
        for (int k = 0; k < K; ++k) {
            V[k] = new DoublePoint(0.0, 0.0);
        }
        DoublePoint[] G0 = this.g(X);
        if (G0 == null) {
            return;
        }
        do {
            double g0 = 0.0;
            for (int k = 0; k < K; ++k) {
                V[k].x = -G0[k].x;
                V[k].y = -G0[k].y;
                g0 += G0[k].x * G0[k].x + G0[k].y * G0[k].y;
            }
            if (g0 <= SQRT_TINY) {
                this.snake.setNodes(X);
                break;
            }
            totalDisplacement = 0.0;
            int N = 2 * K;
            for (int n = 0; n <= N; ++n) {
                double dx = this.LineMinimization(X, V);
                if (dx < 0.0) {
                    this.snake.setNodes(X);
                    return;
                }
                totalDisplacement += dx;
                DoublePoint[] G1 = this.g(X);
                if (G1 == null) {
                    this.snake.setNodes(X);
                    return;
                }
                double g1 = 0.0;
                double b = 0.0;
                for (int k = 0; k < K; ++k) {
                    b += G1[k].x * (G1[k].x - G0[k].x) + G1[k].y * (G1[k].y - G0[k].y);
                    g1 += G1[k].x * G1[k].x + G1[k].y * G1[k].y;
                }
                if (g1 <= SQRT_TINY) {
                    this.snake.setNodes(X);
                    return;
                }
                b /= g0;
                double v = 0.0;
                for (int k = 0; k < K; ++k) {
                    V[k].x = b * V[k].x - G1[k].x;
                    V[k].y = b * V[k].y - G1[k].y;
                    v += V[k].x * V[k].x + V[k].y * V[k].y;
                }
                if (v <= SQRT_TINY) {
                    this.snake.setNodes(X);
                    return;
                }
                g0 = g1;
                G0 = G1;
            }
        } while (SQRT_TINY < totalDisplacement);
        this.snake.setNodes(X);
    }

    private Double f(OvusculeSnake2DNode[] X, double u, DoublePoint[] V) {
        int K = X.length;
        OvusculeSnake2DNode[] Y = new OvusculeSnake2DNode[K];
        for (int k = 0; k < K; ++k) {
            Y[k] = new OvusculeSnake2DNode(X[k].x, X[k].y);
            Y[k].x += u * V[k].x;
            Y[k].y += u * V[k].y;
        }
        this.snake.setNodes(Y);
        if (!this.optimizing) {
            return null;
        }
        return new Double(this.snake.energy());
    }

    private DoublePoint[] g(OvusculeSnake2DNode[] X) {
        int K = X.length;
        this.snake.setNodes(X);
        if (!this.optimizing) {
            return null;
        }
        DoublePoint[] G = this.snake.getEnergyGradient();
        if (null != G) {
            DoublePoint[] G0 = new DoublePoint[K];
            for (int k = 0; k < K; ++k) {
                G0[k] = X[k].frozen ? new DoublePoint(0.0, 0.0) : new DoublePoint(G[k].x, G[k].y);
            }
            G = G0;
        } else {
            int k;
            OvusculeSnake2DNode[] Y = new OvusculeSnake2DNode[K];
            G = new DoublePoint[K];
            for (k = 0; k < K; ++k) {
                Y[k] = new OvusculeSnake2DNode(X[k].x, X[k].y);
                G[k] = new DoublePoint(0.0, 0.0);
            }
            for (k = 0; k < K; ++k) {
                if (X[k].frozen) continue;
                Y[k].x = X[k].x - SQRT_TINY;
                this.snake.setNodes(Y);
                if (!this.optimizing) {
                    return null;
                }
                double f0 = this.snake.energy();
                Y[k].x = X[k].x + SQRT_TINY;
                this.snake.setNodes(Y);
                if (!this.optimizing) {
                    return null;
                }
                double f1 = this.snake.energy();
                G[k].x = 0.5 * (f1 - f0) / SQRT_TINY;
                Y[k].x = X[k].x;
                Y[k].y = X[k].y - SQRT_TINY;
                this.snake.setNodes(Y);
                if (!this.optimizing) {
                    return null;
                }
                f0 = this.snake.energy();
                Y[k].y = X[k].y + SQRT_TINY;
                this.snake.setNodes(Y);
                if (!this.optimizing) {
                    return null;
                }
                f1 = this.snake.energy();
                G[k].y = 0.5 * (f1 - f0) / SQRT_TINY;
                Y[k].y = X[k].y;
            }
            this.snake.setNodes(X);
        }
        return G;
    }

    private double LineMinimization(OvusculeSnake2DNode[] X, DoublePoint[] V) {
        double c;
        Double Fc;
        int K = X.length;
        double a = 0.0;
        Double Fa = this.f(X, a, V);
        if (Fa == null) {
            return -1.0;
        }
        this.energy = this.energy == null ? Fa : (this.energy.compareTo(Fa) < 0 ? this.energy : Fa);
        double fa = Fa;
        if (!this.optimizing) {
            return -1.0;
        }
        OvusculeSnake2DScale[] Pa = this.snake.getScales();
        double b = SQRT_TINY;
        Double Fb = this.f(X, b, V);
        if (Fb == null) {
            return -1.0;
        }
        this.energy = this.energy.compareTo(Fb) < 0 ? this.energy : Fb;
        double fb = Fb;
        if (!this.optimizing) {
            if (fb < fa) {
                for (int k = 0; k < K; ++k) {
                    X[k].x += b * V[k].x;
                    X[k].y += b * V[k].y;
                }
            }
            return -1.0;
        }
        OvusculeSnake2DScale[] Pb = this.snake.getScales();
        if (fa < fb) {
            double z = a;
            a = b;
            b = z;
            double f = fa;
            fa = fb;
            fb = f;
        }
        if ((Fc = this.f(X, c = b + 1.618033988749895 * (b - a), V)) == null) {
            for (int k = 0; k < K; ++k) {
                X[k].x += b * V[k].x;
                X[k].y += b * V[k].y;
            }
            return -1.0;
        }
        this.energy = this.energy.compareTo(Fc) < 0 ? this.energy : Fc;
        double fc = Fc;
        if (fc < fb && !this.optimizing) {
            for (int k = 0; k < K; ++k) {
                X[k].x += c * V[k].x;
                X[k].y += c * V[k].y;
            }
            return -1.0;
        }
        double u = c;
        double fu = fc;
        while (fc <= fb) {
            Double Fu;
            double r = (b - a) * (fb - fc);
            double q = (b - c) * (fb - fa);
            u = 0.5 * (b - (b - c) * q + (b - a) * r);
            u = TINY < Math.abs(q - r) ? u / (q - r) : (r < q ? u / TINY : -u / TINY);
            double ulim = b + 100.0 * (c - b);
            if (0.0 < (b - u) * (u - c)) {
                Fu = this.f(X, u, V);
                if (Fu == null) {
                    for (int k = 0; k < K; ++k) {
                        X[k].x += c * V[k].x;
                        X[k].y += c * V[k].y;
                    }
                    return -1.0;
                }
                this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
                fu = Fu;
                if (fu < fc) {
                    if (!this.optimizing) {
                        for (int k = 0; k < K; ++k) {
                            X[k].x += u * V[k].x;
                            X[k].y += u * V[k].y;
                        }
                        return -1.0;
                    }
                    a = b;
                    fa = fb;
                    b = u;
                    fb = fu;
                    break;
                }
                if (fb < fu) {
                    c = u;
                    fc = fu;
                    break;
                }
                u = c + 1.618033988749895 * (c - b);
                Fu = this.f(X, u, V);
                if (Fu == null) {
                    for (int k = 0; k < K; ++k) {
                        X[k].x += c * V[k].x;
                        X[k].y += c * V[k].y;
                    }
                    return -1.0;
                }
                this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
                fu = Fu;
                if (fu < fc && !this.optimizing) {
                    for (int k = 0; k < K; ++k) {
                        X[k].x += u * V[k].x;
                        X[k].y += u * V[k].y;
                    }
                    return -1.0;
                }
            } else if (0.0 < (c - u) * (u - ulim)) {
                Fu = this.f(X, u, V);
                if (Fu == null) {
                    for (int k = 0; k < K; ++k) {
                        X[k].x += c * V[k].x;
                        X[k].y += c * V[k].y;
                    }
                    return -1.0;
                }
                this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
                fu = Fu;
                if (fu < fc) {
                    if (!this.optimizing) {
                        for (int k = 0; k < K; ++k) {
                            X[k].x += u * V[k].x;
                            X[k].y += u * V[k].y;
                        }
                        return -1.0;
                    }
                    b = c;
                    c = u;
                    u = c + 1.618033988749895 * (c - b);
                    fb = fc;
                    fc = fu;
                    Fu = this.f(X, u, V);
                    if (Fu == null) {
                        for (int k = 0; k < K; ++k) {
                            X[k].x += c * V[k].x;
                            X[k].y += c * V[k].y;
                        }
                        return -1.0;
                    }
                    this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
                    fu = Fu;
                    if (fu < fc && !this.optimizing) {
                        for (int k = 0; k < K; ++k) {
                            X[k].x += u * V[k].x;
                            X[k].y += u * V[k].y;
                        }
                        return -1.0;
                    }
                }
            } else {
                if (0.0 <= (u - ulim) * (ulim - c)) {
                    u = ulim;
                    Fu = this.f(X, u, V);
                    if (Fu == null) {
                        for (int k = 0; k < K; ++k) {
                            X[k].x += c * V[k].x;
                            X[k].y += c * V[k].y;
                        }
                        return -1.0;
                    }
                    this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
                    fu = Fu;
                } else {
                    u = c + 1.618033988749895 * (c - b);
                    Fu = this.f(X, u, V);
                    if (Fu == null) {
                        for (int k = 0; k < K; ++k) {
                            X[k].x += c * V[k].x;
                            X[k].y += c * V[k].y;
                        }
                        return -1.0;
                    }
                    this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
                    fu = Fu;
                }
                if (fu < fc && !this.optimizing) {
                    for (int k = 0; k < K; ++k) {
                        X[k].x += u * V[k].x;
                        X[k].y += u * V[k].y;
                    }
                    return -1.0;
                }
            }
            a = b;
            b = c;
            c = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        double d = 0.0;
        double e = 0.0;
        double x = b;
        double v = b;
        double w = b;
        double fx = fb;
        double fv = fb;
        double fw = fb;
        if (c < a) {
            b = a;
            a = c;
            fb = fa;
            fa = fc;
        } else {
            b = c;
            fb = fc;
        }
        while (true) {
            double xm = 0.5 * (a + b);
            double tol1 = SQRT_TINY * Math.abs(x) + TINY;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                double dx = 0.0;
                for (int k = 0; k < K; ++k) {
                    X[k].x += x * V[k].x;
                    X[k].y += x * V[k].y;
                    dx += V[k].x * V[k].x + V[k].y * V[k].y;
                }
                return Math.abs(x) * Math.sqrt(dx);
            }
            if (tol1 < Math.abs(e)) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if (0.0 < (q = 2.0 * (q - r))) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(0.5 * q * etemp) <= Math.abs(p) || p <= q * (a - x) || q * (b - x) <= p) {
                    e = xm <= x ? a - x : b - x;
                    d = 0.38196601125010515 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = x <= xm ? tol1 : -tol1;
                    }
                }
            } else {
                e = xm <= x ? a - x : b - x;
                d = 0.38196601125010515 * e;
            }
            u = tol1 <= Math.abs(d) ? x + d : x + (0.0 <= d ? tol1 : -tol1);
            Double Fu = this.f(X, u, V);
            if (Fu == null) {
                for (int k = 0; k < K; ++k) {
                    X[k].x += x * V[k].x;
                    X[k].y += x * V[k].y;
                }
                return -1.0;
            }
            this.energy = this.energy.compareTo(Fu) < 0 ? this.energy : Fu;
            fu = Fu;
            if (fu <= fx) {
                if (!this.optimizing) {
                    for (int k = 0; k < K; ++k) {
                        X[k].x += u * V[k].x;
                        X[k].y += u * V[k].y;
                    }
                    return -1.0;
                }
                if (x <= u) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                fv = fw;
                w = u;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
    }

    private void init(IOvusculeSnake2D snake) {
        this.snake = snake;
        this.energy = null;
        this.optimizing = true;
        OvusculeSnake2DNode[] youngSnake = snake.getNodes();
        int K = youngSnake.length;
        OvusculeSnake2DNode[] X = new OvusculeSnake2DNode[K];
        for (int k = 0; k < K; ++k) {
            X[k] = new OvusculeSnake2DNode(youngSnake[k].x, youngSnake[k].y, youngSnake[k].frozen, youngSnake[k].hidden);
        }
    }

    public void DrawOvuscule(FastBitmap fastBitmap, IOvusculeSnake2D snake, int r, int g, int b) {
        this.init(snake);
        OvusculeSnake2DScale[] skin = snake.getScales();
        FastGraphics fg = new FastGraphics(fastBitmap);
        fg.setColor(255, 0, 0);
        int K = skin.length;
        for (int k = 0; k < K; ++k) {
            int[] xpoints = skin[k].xpoints;
            int[] ypoints = skin[k].ypoints;
            IntPolygon poly = new IntPolygon();
            int N = skin[k].npoints;
            for (int n = 0; n < N; ++n) {
                poly.addPoint(ypoints[n], xpoints[n]);
            }
            fg.DrawPolygon(poly);
        }
    }
}

