/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Graph.Pathfinding.AStar;

import Catalano.Graph.Pathfinding.AStar.ANode;
import Catalano.Graph.Pathfinding.AStar.AStar;
import java.util.ArrayList;

public class NodeMap {
    private int width;
    private int height;
    public ANode[][] nodes;
    private AStar.Neighbor direction;
    private AStar.Heuristic heuristic;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ANode getNode(int x, int y) {
        return this.nodes[x][y];
    }

    public void setNode(int x, int y, ANode node) {
        this.nodes[x][y] = node;
    }

    public AStar.Neighbor getDirection() {
        return this.direction;
    }

    public void setDirection(AStar.Neighbor direction) {
        this.direction = direction;
    }

    public AStar.Heuristic getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(AStar.Heuristic heuristic) {
        this.heuristic = heuristic;
    }

    public NodeMap(int width, int height, double initialCost) {
        this.width = width;
        this.height = height;
        this.nodes = new ANode[height][width];
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                this.nodes[x][y] = new ANode(x, y, initialCost, this);
            }
        }
        this.direction = AStar.Neighbor.Four;
        this.heuristic = AStar.Heuristic.Manhattan;
    }

    public NodeMap(double[][] nodeCostMap) {
        this.width = nodeCostMap[0].length;
        this.height = nodeCostMap.length;
        this.nodes = new ANode[this.height][this.width];
        for (int x = 0; x < this.height; ++x) {
            for (int y = 0; y < this.width; ++y) {
                this.nodes[x][y] = new ANode(x, y, nodeCostMap[x][y], this);
            }
        }
        this.direction = AStar.Neighbor.Four;
        this.heuristic = AStar.Heuristic.Manhattan;
    }

    public NodeMap(int width, int height, double initialCost, AStar.Neighbor direction, AStar.Heuristic heuristic) {
        this.width = width;
        this.height = height;
        this.nodes = new ANode[height][width];
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                this.nodes[x][y] = new ANode(x, y, initialCost, this);
            }
        }
        this.direction = direction;
        this.heuristic = heuristic;
    }

    public NodeMap(double[][] costMap, AStar.Neighbor direction, AStar.Heuristic heuristic) {
        this.width = costMap[0].length;
        this.height = costMap.length;
        this.nodes = new ANode[this.height][this.width];
        for (int x = 0; x < this.height; ++x) {
            for (int y = 0; y < this.width; ++y) {
                this.nodes[x][y] = new ANode(x, y, costMap[x][y], this);
            }
        }
        this.direction = direction;
        this.heuristic = heuristic;
    }

    private NodeMap(int width, int height, AStar.Neighbor direction, AStar.Heuristic heuristic) {
        this.width = width;
        this.height = height;
        this.nodes = new ANode[height][width];
        this.direction = direction;
        this.heuristic = heuristic;
    }

    public ANode[] getSurroundingNodes(int x, int y) {
        ArrayList<ANode> tmpNodes = new ArrayList<ANode>(8);
        switch (this.direction) {
            case Four: {
                if (x - 1 >= 0) {
                    tmpNodes.add(this.nodes[x - 1][y]);
                }
                if (x + 1 < this.height) {
                    tmpNodes.add(this.nodes[x + 1][y]);
                }
                if (y - 1 >= 0) {
                    tmpNodes.add(this.nodes[x][y - 1]);
                }
                if (y + 1 >= this.width) break;
                tmpNodes.add(this.nodes[x][y + 1]);
                break;
            }
            case Eight: {
                if (x - 1 >= 0 && y - 1 >= 0) {
                    tmpNodes.add(this.nodes[x - 1][y - 1]);
                }
                if (x - 1 >= 0) {
                    tmpNodes.add(this.nodes[x - 1][y]);
                }
                if (x - 1 >= 0 && y + 1 < this.width) {
                    tmpNodes.add(this.nodes[x - 1][y + 1]);
                }
                if (y - 1 >= 0) {
                    tmpNodes.add(this.nodes[x][y - 1]);
                }
                if (y + 1 < this.width) {
                    tmpNodes.add(this.nodes[x][y + 1]);
                }
                if (x + 1 < this.height && y - 1 >= 0) {
                    tmpNodes.add(this.nodes[x + 1][y - 1]);
                }
                if (x + 1 < this.height) {
                    tmpNodes.add(this.nodes[x + 1][y]);
                }
                if (x + 1 >= this.height || y + 1 >= this.width) break;
                tmpNodes.add(this.nodes[x + 1][y + 1]);
            }
        }
        return tmpNodes.toArray(new ANode[tmpNodes.size()]);
    }

    public double ComputeHeuristic(int startX, int startY, int endX, int endY) {
        double H = -1.0;
        switch (this.heuristic) {
            case Manhattan: {
                H = Math.abs(startX - endX) + Math.abs(startY - endY);
                break;
            }
            case Chebyshev: {
                H = Math.max(Math.abs(startX - endX), Math.abs(startY - endY));
                break;
            }
            case Euclidean: {
                H = Math.sqrt(Math.pow(startX - endX, 2.0) + Math.pow(startY - endY, 2.0));
                break;
            }
            case SquaredEuclidean: {
                H = Math.pow(startX - endX, 2.0) + Math.pow(startY - endY, 2.0);
            }
        }
        return H;
    }

    public NodeMap clone() {
        NodeMap copy = new NodeMap(this.width, this.height, this.direction, this.heuristic);
        for (int x = 0; x < this.height; ++x) {
            for (int y = 0; y < this.width; ++y) {
                copy.setNode(x, y, this.getNode(x, y).clone(copy));
            }
        }
        return copy;
    }
}

