/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Graph.Pathfinding.AStar;

import Catalano.Graph.Pathfinding.AStar.NodeMap;

public class ANode
implements Comparable<ANode> {
    private int m_X;
    private int m_Y;
    private double m_Cost;
    private double m_H;
    private double m_G;
    private boolean m_onOpenList;
    private boolean m_onClosedList;
    private ANode m_Parent;
    private NodeMap m_mapParent;

    public int getX() {
        return this.m_X;
    }

    public void setX(int x) {
        this.m_X = x;
    }

    public int getY() {
        return this.m_Y;
    }

    public void setY(int y) {
        this.m_Y = y;
    }

    public double getCost() {
        return this.m_Cost;
    }

    public void setCost(double cost) {
        this.m_Cost = cost;
    }

    public double getH() {
        return this.m_H;
    }

    public void setH(double h) {
        this.m_H = h;
    }

    public double getG() {
        return this.m_G;
    }

    public void setG(double g) {
        this.m_G = g;
    }

    public double getF() {
        return this.m_G + this.m_H;
    }

    public boolean isOnOpenList() {
        return this.m_onOpenList;
    }

    public void setOnOpenList(boolean onOpenList) {
        this.m_onOpenList = onOpenList;
    }

    public boolean isOnClosedList() {
        return this.m_onClosedList;
    }

    public void setOnClosedList(boolean onClosedList) {
        this.m_onClosedList = onClosedList;
    }

    public ANode getParent() {
        return this.m_Parent;
    }

    public void setParent(ANode node) {
        this.m_Parent = node;
    }

    public NodeMap getMapParent() {
        return this.m_mapParent;
    }

    public void setMapParent(NodeMap nodeMap) {
        this.m_mapParent = nodeMap;
    }

    public ANode[] getSurroundingNodes() {
        return this.m_mapParent.getSurroundingNodes(this.m_X, this.m_Y);
    }

    public double ComputeHeuristic(ANode Target) {
        return this.ComputeHeuristic(Target.getX(), Target.getY());
    }

    public double ComputeHeuristic(int x, int y) {
        double H = this.m_mapParent.ComputeHeuristic(this.m_X, this.m_Y, x, y);
        if (H != -1.0) {
            return H * this.m_Cost;
        }
        return H;
    }

    public ANode(int x, int y, double cost, NodeMap mapParent) {
        this.m_X = x;
        this.m_Y = y;
        this.m_Cost = cost;
        this.m_mapParent = mapParent;
        this.m_onClosedList = false;
        this.m_onOpenList = false;
    }

    public ANode clone(NodeMap parent) {
        ANode copy = new ANode(this.m_X, this.m_Y, this.m_Cost, parent);
        return copy;
    }

    @Override
    public int compareTo(ANode o) {
        return Double.compare(this.getF(), o.getF());
    }
}

