/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Graph;

import Catalano.Math.Matrix;

public class AdjacencyMatrix {
    private double[][] matrix;

    public AdjacencyMatrix(int edges) {
        this.matrix = new double[edges][edges];
    }

    public AdjacencyMatrix(double[][] matrix) {
        this.matrix = matrix;
    }

    public double[][] getData() {
        return this.matrix;
    }

    public int getNumberOfNodes() {
        return this.matrix.length;
    }

    public double getAverageDegree() {
        return 2 * this.getNumberOfEdges() / this.getNumberOfNodes();
    }

    public double getLinkDensity() {
        int n = this.getNumberOfNodes();
        int e = this.getNumberOfEdges();
        return 2 * e / (n * (n - 1));
    }

    public int getNumberOfEdges() {
        int sl = this.getNumberOfSelfLoops();
        boolean sym = this.isSymmetric();
        int edges = 0;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                if (this.matrix[i][j] == 0.0) continue;
                ++edges;
            }
        }
        if (sym && sl == 0) {
            return edges / 2;
        }
        if (sym && sl > 0) {
            return (edges - sl) / 2 + sl;
        }
        return edges;
    }

    public int getNumberOfSelfLoops() {
        int loops = 0;
        for (int i = 0; i < this.matrix.length; ++i) {
            loops = (int)((double)loops + this.matrix[i][i]);
        }
        return loops;
    }

    public void setData(double[][] data) {
        if (data.length != data[0].length) {
            throw new IllegalArgumentException("Number of rows must be the same of number of cols.");
        }
        this.matrix = data;
    }

    public int getMaxDegree() {
        int h = this.matrix.length;
        int w = this.matrix[0].length;
        int max = 0;
        for (int i = 0; i < h; ++i) {
            int degree = 0;
            for (int j = 0; j < w; ++j) {
                if (!(this.matrix[i][j] > 0.0)) continue;
                ++degree;
            }
            if (degree <= max) continue;
            max = degree;
        }
        return max;
    }

    public int getEdgeByMaxDegree() {
        int h = this.matrix.length;
        int w = this.matrix[0].length;
        int edge = 0;
        int max = 0;
        for (int i = 0; i < h; ++i) {
            int degree = 0;
            for (int j = 0; j < w; ++j) {
                if (!(this.matrix[i][j] > 0.0)) continue;
                ++degree;
            }
            if (degree <= max) continue;
            max = degree;
            edge = i;
        }
        return edge;
    }

    public static double[][] CreateStochasticMatrix(double[][] matrix) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            int j;
            int n = 0;
            for (j = 0; j < matrix[0].length; ++j) {
                if (matrix[i][j] == 0.0) continue;
                ++n;
            }
            for (j = 0; j < matrix[0].length; ++j) {
                if (matrix[i][j] == 0.0) continue;
                result[i][j] = 1.0 / (double)n;
            }
        }
        return result;
    }

    public void setStochasticMatrix() {
        for (int i = 0; i < this.matrix.length; ++i) {
            int j;
            int n = 0;
            for (j = 0; j < this.matrix[0].length; ++j) {
                if (this.matrix[i][j] == 0.0) continue;
                ++n;
            }
            for (j = 0; j < this.matrix[0].length; ++j) {
                if (this.matrix[i][j] == 0.0) continue;
                this.matrix[i][j] = 1.0 / (double)n;
            }
        }
    }

    public boolean isSymmetric() {
        return Matrix.isSymmetric(this.matrix);
    }
}

