/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Fuzzy;

import Catalano.Fuzzy.Clause;
import Catalano.Fuzzy.Database;
import Catalano.Fuzzy.FuzzySet;
import Catalano.Fuzzy.ICoNorm;
import Catalano.Fuzzy.INorm;
import Catalano.Fuzzy.IUnaryOperator;
import Catalano.Fuzzy.LinguisticVariable;
import Catalano.Fuzzy.MaximumCoNorm;
import Catalano.Fuzzy.MinimumNorm;
import Catalano.Fuzzy.NotOperator;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Rule {
    private String name;
    private String rule;
    private ArrayList<Object> rpnTokenList = new ArrayList();
    private Clause output;
    private Database database;
    private INorm normOperator;
    private ICoNorm conormOperator;
    private IUnaryOperator notOperator;
    private String unaryOperators = "NOT;VERY";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Clause getOutput() {
        return this.output;
    }

    public Rule(Database fuzzyDatabase, String name, String rule, INorm normOperator, ICoNorm coNormOperator) {
        this.name = name;
        this.rule = rule;
        this.database = fuzzyDatabase;
        this.normOperator = normOperator;
        this.conormOperator = coNormOperator;
        this.notOperator = new NotOperator();
        this.ParseRule();
    }

    public Rule(Database fuzzyDatabase, String name, String rule) {
        this(fuzzyDatabase, name, rule, new MinimumNorm(), new MaximumCoNorm());
    }

    private int Priority(String Operator) {
        if (this.unaryOperators.indexOf(Operator) >= 0) {
            return 4;
        }
        if (Operator.equals("(")) {
            return 1;
        }
        if (Operator.equals("OR")) {
            return 2;
        }
        if (Operator.equals("AND")) {
            return 3;
        }
        return 0;
    }

    public String GetRPNExpression() {
        String result = "";
        for (Object o : this.rpnTokenList) {
            if (o.getClass().isAssignableFrom(Clause.class)) {
                Clause c = (Clause)o;
                result = result + c.toString();
            } else {
                result = result + o.toString();
            }
            result = result + ", ";
        }
        result = result + "#";
        result = result.replace(", #", "");
        return result;
    }

    private void ParseRule() {
        boolean consequent = false;
        String upRule = this.rule.toUpperCase();
        if (!upRule.startsWith("IF")) {
            try {
                throw new Exception("A Fuzzy Rule must start with an IF statement.");
            }
            catch (Exception ex) {
                Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (upRule.indexOf("THEN") < 0) {
            try {
                throw new Exception("Missing the consequent (THEN) statement.");
            }
            catch (Exception ex) {
                Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String spacedRule = this.rule.replace("(", " ( ").replace(")", " ) ");
        String[] tokensList = this.GetRuleTokens(spacedRule);
        Stack<String> s = new Stack<String>();
        String lastToken = "IF";
        LinguisticVariable lingVar = null;
        for (int i = 0; i < tokensList.length; ++i) {
            String token = tokensList[i].trim();
            String upToken = token.toUpperCase();
            if (upToken.equals("") || upToken.equals("IF")) continue;
            if (upToken.equals("THEN")) {
                lastToken = upToken;
                consequent = true;
                continue;
            }
            if (lastToken.equals("VAR")) {
                if (upToken.equals("IS")) {
                    lastToken = upToken;
                    continue;
                }
                try {
                    throw new Exception("An IS statement is expected after a linguistic variable.");
                }
                catch (Exception ex) {
                    Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
            }
            if (lastToken.equals("IS")) {
                try {
                    FuzzySet fs = lingVar.getLabel(token);
                    Clause c = new Clause(lingVar, fs);
                    if (consequent) {
                        this.output = c;
                    } else {
                        this.rpnTokenList.add(c);
                    }
                    lastToken = "LAB";
                }
                catch (Exception e) {
                    try {
                        throw new Exception("Linguistic label " + token + " was not found on the variable " + lingVar.getName() + ".");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                continue;
            }
            if (upToken.equals("(")) {
                if (consequent) {
                    try {
                        throw new Exception("Linguistic variable expected after a THEN statement.");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                s.push(upToken);
                lastToken = upToken;
                continue;
            }
            if (upToken.equals("AND") || upToken.equals("OR") || this.unaryOperators.indexOf(upToken) >= 0) {
                if (consequent) {
                    try {
                        throw new Exception("Linguistic variable expected after a THEN statement.");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                while (s.size() > 0 && this.Priority((String)s.peek()) > this.Priority(upToken)) {
                    this.rpnTokenList.add(s.pop());
                }
                s.push(upToken);
                lastToken = upToken;
                continue;
            }
            if (upToken.equals(")")) {
                if (consequent) {
                    try {
                        throw new Exception("Linguistic variable expected after a THEN statement.");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (s.size() == 0) {
                    try {
                        throw new Exception("Openning parenthesis missing.");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                while (!((String)s.peek()).equals("(")) {
                    this.rpnTokenList.add(s.pop());
                    if (s.size() != 0) continue;
                    try {
                        throw new Exception("Openning parenthesis missing.");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                s.pop();
                lastToken = upToken;
                continue;
            }
            try {
                lingVar = this.database.getVariable(token);
                lastToken = "VAR";
                continue;
            }
            catch (Exception e) {
                try {
                    throw new Exception("Linguistic variable " + token + " was not found on the database.");
                }
                catch (Exception ex) {
                    Logger.getLogger(Rule.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        while (s.size() > 0) {
            this.rpnTokenList.add(s.pop());
        }
    }

    private String[] GetRuleTokens(String rule) {
        String[] tokens = rule.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            if (this.unaryOperators.indexOf(tokens[i].toUpperCase()) < 0 || i <= 1 || !tokens[i - 1].toUpperCase().equals("IS")) continue;
            tokens[i - 1] = tokens[i - 2];
            tokens[i - 2] = tokens[i];
            tokens[i] = "IS";
        }
        return tokens;
    }

    public float EvaluateFiringStrength() {
        Stack<Float> s = new Stack<Float>();
        for (Object o : this.rpnTokenList) {
            if (o.getClass().isAssignableFrom(Clause.class)) {
                Clause c = (Clause)o;
                s.push(Float.valueOf(c.Evaluate()));
                continue;
            }
            float y = ((Float)s.pop()).floatValue();
            float x = 0.0f;
            if (this.unaryOperators.indexOf(o.toString()) < 0) {
                x = ((Float)s.pop()).floatValue();
            }
            if (o.toString().equals("AND")) {
                s.push(Float.valueOf(this.normOperator.Evaluate(x, y)));
            }
            if (o.toString().equals("OR")) {
                s.push(Float.valueOf(this.normOperator.Evaluate(x, y)));
            }
            if (!o.toString().equals("NOT")) continue;
            s.push(Float.valueOf(this.normOperator.Evaluate(x, y)));
        }
        return ((Float)s.pop()).floatValue();
    }
}

