/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class TeachingLearningBasedOptimization
extends BaseEvolutionaryOptimization {
    public TeachingLearningBasedOptimization() {
        this(25, 1000);
    }

    public TeachingLearningBasedOptimization(int population, int iterations) {
        this.populationSize = population;
        this.generations = iterations;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        Random rand = new Random();
        double[][] pop = new double[this.populationSize][boundConstraint.size()];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(boundConstraint);
        }
        double[] fitness = new double[pop.length];
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = function.Compute(pop[i]);
        }
        for (int it = 0; it < this.generations; ++it) {
            int i;
            double[] mean = Tools.Mean(pop);
            double[] teacher = Arrays.copyOf(pop[Matrix.MinIndex(fitness)], pop[0].length);
            for (i = 0; i < this.populationSize; ++i) {
                double tf = rand.nextInt(2) + 1;
                double[] newsol = new double[pop[0].length];
                for (int j = 0; j < newsol.length; ++j) {
                    newsol[j] = pop[i][j] + rand.nextDouble() * (teacher[j] - tf * mean[j]);
                    newsol[j] = Catalano.Math.Tools.Clamp(newsol[j], boundConstraint.get(j));
                }
                double f = function.Compute(newsol);
                ++this.nEvals;
                if (!(f < fitness[i])) continue;
                pop[i] = newsol;
                fitness[i] = f;
                if (!(f < this.minError)) continue;
                this.minError = f;
                this.best = Arrays.copyOf(newsol, newsol.length);
            }
            for (i = 0; i < this.populationSize; ++i) {
                int[] a = Matrix.Indices(0, this.populationSize);
                a = Matrix.RemoveColumn(a, i);
                int pos = a[rand.nextInt(this.populationSize - 1)];
                double[] step = Matrix.Subtract(pop[i], pop[pos]);
                if (fitness[pos] < fitness[i]) {
                    step = Matrix.Multiply(step, -1.0);
                }
                double[] newsol = new double[pop[0].length];
                for (int j = 0; j < newsol.length; ++j) {
                    newsol[j] = pop[i][j] + rand.nextDouble() * step[j];
                    newsol[j] = Catalano.Math.Tools.Clamp(newsol[j], boundConstraint.get(j));
                }
                double f = function.Compute(newsol);
                ++this.nEvals;
                if (!(f < fitness[i])) continue;
                pop[i] = newsol;
                fitness[i] = f;
                if (!(f < this.minError)) continue;
                this.minError = f;
                this.best = Arrays.copyOf(pop[i], pop[i].length);
            }
            if (this.listener == null) continue;
            this.listener.onIteration(it + 1, this.minError);
        }
    }
}

