/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Individual
implements Comparable<Individual>,
Cloneable {
    private double[] location;
    private double fitness;

    public static List<Individual> CreatePopulation(int populationSize, List<DoubleRange> boundConstraints, IObjectiveFunction function) {
        ArrayList<Individual> population = new ArrayList<Individual>(populationSize);
        for (int i = 0; i < populationSize; ++i) {
            double[] location = Matrix.UniformRandom(boundConstraints);
            double fitness = function.Compute(location);
            population.add(new Individual(location, fitness));
        }
        return population;
    }

    public static List<Individual> CreatePopulation(double[][] population, double[] fitness) {
        ArrayList<Individual> pop = new ArrayList<Individual>(population.length);
        for (int i = 0; i < population.length; ++i) {
            pop.add(new Individual(population[i], fitness[i]));
        }
        return pop;
    }

    public double[] getLocation() {
        return this.location;
    }

    public double getLocation(int index) {
        return this.location[index];
    }

    public void setLocation(double[] location) {
        this.location = location;
    }

    public void setLocation(int index, double location) {
        this.location[index] = location;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public Individual(double[] location) {
        this(location, Double.NaN);
    }

    public Individual(double[] location, double fitness) {
        this.location = location;
        this.fitness = fitness;
    }

    @Override
    public int compareTo(Individual o) {
        return Double.compare(this.fitness, o.getFitness());
    }

    public Individual getClone() {
        return new Individual(Arrays.copyOf(this.location, this.location.length), this.fitness);
    }
}

