/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.PermutationChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import Catalano.Math.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TwoPointCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        int i;
        if (chromosome1 instanceof PermutationChromosome) {
            throw new IllegalArgumentException("Permutation Chromosome is not supported.");
        }
        int length = chromosome1.getLength();
        int[] indexes = Matrix.RandomPermutation(length);
        int[] cuts = new int[]{indexes[0], indexes[1]};
        Arrays.sort(cuts, 0, cuts.length);
        IChromosome c1 = chromosome1.Clone();
        IChromosome c2 = chromosome2.Clone();
        for (i = 0; i < cuts[0]; ++i) {
            c1.setGene(i, chromosome1.getGene(i));
            c2.setGene(i, chromosome2.getGene(i));
        }
        for (i = cuts[0]; i < cuts[1]; ++i) {
            c1.setGene(i, chromosome2.getGene(i));
            c2.setGene(i, chromosome1.getGene(i));
        }
        for (i = cuts[1]; i < length; ++i) {
            c1.setGene(i, chromosome1.getGene(i));
            c2.setGene(i, chromosome2.getGene(i));
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }
}

