/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.PermutationChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class SinglePointCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        if (chromosome1 instanceof PermutationChromosome) {
            return this.ComputePC((PermutationChromosome)chromosome1, (PermutationChromosome)chromosome2);
        }
        return this.ComputeGeneric(chromosome1, chromosome2);
    }

    private List<IChromosome> ComputeGeneric(IChromosome chromosome1, IChromosome chromosome2) {
        int i;
        Random rand = new Random();
        int cut = rand.nextInt(chromosome1.getLength());
        int length = chromosome1.getLength();
        IChromosome c1 = chromosome1.Clone();
        IChromosome c2 = chromosome2.Clone();
        for (i = 0; i < cut; ++i) {
            c1.setGene(i, chromosome1.getGene(i));
            c2.setGene(i, chromosome2.getGene(i));
        }
        for (i = cut; i < length; ++i) {
            c1.setGene(i, chromosome2.getGene(i));
            c2.setGene(i, chromosome1.getGene(i));
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }

    private List<IChromosome> ComputePC(PermutationChromosome chromosome1, PermutationChromosome chromosome2) {
        int i;
        Random rand = new Random();
        int size = chromosome1.getLength();
        int cut = rand.nextInt(chromosome1.getLength());
        ArrayList<Integer> set1 = new ArrayList<Integer>(chromosome1.getLength());
        ArrayList<Integer> set2 = new ArrayList<Integer>(chromosome1.getLength());
        for (int i2 = cut; i2 < size; ++i2) {
            set1.add((Integer)chromosome1.getGene(i2));
            set2.add((Integer)chromosome2.getGene(i2));
        }
        Collections.shuffle(set1);
        Collections.shuffle(set2);
        int[] c1 = new int[size];
        int[] c2 = new int[size];
        for (i = 0; i < cut; ++i) {
            c1[i] = (Integer)chromosome1.getGene(i);
            c2[i] = (Integer)chromosome2.getGene(i);
        }
        for (i = cut; i < size; ++i) {
            c1[i] = (Integer)set1.get(i - cut);
            c2[i] = (Integer)set2.get(i - cut);
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(new PermutationChromosome(c1));
        lst.add(new PermutationChromosome(c2));
        return lst;
    }
}

