/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Core;

import Catalano.Core.DoubleRange;
import Catalano.Core.FloatRange;
import java.io.Serializable;

public class IntRange
implements Serializable {
    int min;
    int max;

    public IntRange() {
    }

    public IntRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public double length() {
        return this.max - this.min;
    }

    public boolean isInside(int x) {
        return x >= this.min && x <= this.max;
    }

    public boolean IsOverlapping(IntRange range) {
        return this.isInside(range.min) || this.isInside(range.max) || range.isInside(this.min) || range.isInside(this.max);
    }

    public FloatRange toFloatRange() {
        return new FloatRange(this.min, this.max);
    }

    public DoubleRange toDoubleRange() {
        return new DoubleRange(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(IntRange.class)) {
            IntRange range = (IntRange)obj;
            return this.min == range.getMin() && this.max == range.getMax();
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + this.min;
        hash = 71 * hash + this.max;
        return hash;
    }

    public String toString() {
        return "Minimum: " + this.min + " Maximum: " + this.max;
    }
}

