/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Core;

import Catalano.Core.FloatRange;
import Catalano.Core.IntRange;
import java.io.Serializable;

public class DoubleRange
implements Serializable {
    double min;
    double max;

    public DoubleRange() {
    }

    public DoubleRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double length() {
        return this.max - this.min;
    }

    public boolean isInside(double x) {
        return x >= this.min && x <= this.max;
    }

    public boolean IsOverlapping(DoubleRange range) {
        return this.isInside(range.min) || this.isInside(range.max) || range.isInside(this.min) || range.isInside(this.max);
    }

    public IntRange toIntRange() {
        return new IntRange((int)this.min, (int)this.max);
    }

    public FloatRange toFloatRange() {
        return new FloatRange((float)this.min, (float)this.max);
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(DoubleRange.class)) {
            DoubleRange range = (DoubleRange)obj;
            return this.min == range.getMin() && this.max == range.getMax();
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        hash += 61 * hash + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        return hash;
    }

    public String toString() {
        return "Minimum: " + this.min + " Maximum: " + this.max;
    }
}

