/*
 * Decompiled with CFR 0.152.
 */
package joptima.functions;

import joptima.Parameter;
import joptima.functions.ConstrainableFunction;

public class Cubic
extends ConstrainableFunction {
    public double m_a;
    public double m_b;
    public double m_c;
    public double m_d;
    private String m_name = "Cubic";

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[this.countUnconstrained()];
        try {
            int cursor = 0;
            if (!this.m_constrained[0]) {
                parameters[cursor++] = new Parameter(this, "a");
            }
            if (!this.m_constrained[1]) {
                parameters[cursor++] = new Parameter(this, "b");
            }
            if (!this.m_constrained[2]) {
                parameters[cursor++] = new Parameter(this, "c");
            }
            if (!this.m_constrained[3]) {
                parameters[cursor++] = new Parameter(this, "d");
            }
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void constrain(String parametername) {
        if ("a".equals(parametername)) {
            this.m_constrained[0] = true;
        }
        if ("b".equals(parametername)) {
            this.m_constrained[1] = true;
        }
        if ("c".equals(parametername)) {
            this.m_constrained[2] = true;
        }
        if ("d".equals(parametername)) {
            this.m_constrained[3] = true;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }

    public Cubic() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public Cubic(double a, double b, double c, double d) {
        this.m_a = a;
        this.m_b = b;
        this.m_c = c;
        this.m_d = d;
        this.m_constrained = new boolean[4];
    }

    @Override
    public double calculate(double x) {
        return this.m_a * x * x * x + this.m_b * x * x + this.m_c * x + this.m_d;
    }

    public double getA() {
        return this.m_a;
    }

    public void setA(double a) {
        this.m_a = a;
    }

    public double getB() {
        return this.m_b;
    }

    public void setB(double b) {
        this.m_b = b;
    }

    public double getC() {
        return this.m_c;
    }

    public void setC(double c) {
        this.m_c = c;
    }

    public double getD() {
        return this.m_d;
    }

    public void setD(double d) {
        this.m_d = d;
    }
}

