/*
 * Decompiled with CFR 0.152.
 */
package joptima.fortran;

import joptima.fortran.Log;
import joptima.fortran.Uncmin_methods;
import joptima.fortran.linalg.Blas_f77;

public class Uncmin_f77 {
    public static void optif0_f77(int n, double[] x, Uncmin_methods minclass, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag) {
        int[] msg = new int[2];
        double[] typsiz = new double[n + 1];
        double[] g = new double[n + 1];
        double[] p = new double[n + 1];
        double[] sx = new double[n + 1];
        double[] wrk0 = new double[n + 1];
        double[] wrk1 = new double[n + 1];
        double[] wrk2 = new double[n + 1];
        double[] wrk3 = new double[n + 1];
        double[] dlt = new double[2];
        double[] fscale = new double[2];
        double[] stepmx = new double[2];
        int[] ndigit = new int[2];
        int[] method = new int[2];
        int[] iexp = new int[2];
        int[] itnlim = new int[2];
        int[] iagflg = new int[2];
        int[] iahflg = new int[2];
        double[] gradtl = new double[2];
        double[] steptl = new double[2];
        Uncmin_f77.dfault_f77(n, x, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl);
        Uncmin_f77.optdrv_f77(n, x, minclass, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, xpls, fpls, gpls, itrmcd, a, udiag, g, p, sx, wrk0, wrk1, wrk2, wrk3);
        if (itrmcd[1] == 1) {
            System.out.print("\nUncmin WARNING --- itrmcd = 1, probably converged, gradient small\n\n");
        } else if (itrmcd[1] == 2) {
            Log.log("\nUncmin WARNING --- itrmcd = 2, probably converged, stepsize small\n\n");
        } else if (itrmcd[1] == 3) {
            Log.log("\nUncmin WARNING --- itrmcd = 3, cannot find lower point\n\n");
        } else if (itrmcd[1] == 4) {
            Log.log("\nUncmin WARNING --- itrmcd = 4, too many iterations\n\n");
        } else if (itrmcd[1] == 5) {
            Log.log("\nUncmin WARNING --- itrmcd = 5, too many large steps, possibly unbounded\n\n");
        }
    }

    public static void optif9_f77(int n, double[] x, Uncmin_methods minclass, double[] typsiz, double[] fscale, int[] method, int[] iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag) {
        double[] g = new double[n + 1];
        double[] p = new double[n + 1];
        double[] sx = new double[n + 1];
        double[] wrk0 = new double[n + 1];
        double[] wrk1 = new double[n + 1];
        double[] wrk2 = new double[n + 1];
        double[] wrk3 = new double[n + 1];
        Uncmin_f77.optdrv_f77(n, x, minclass, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, xpls, fpls, gpls, itrmcd, a, udiag, g, p, sx, wrk0, wrk1, wrk2, wrk3);
        if (itrmcd[1] == 1) {
            Log.log("\nUncmin WARNING --- itrmcd = 1, probably converged, gradient small\n\n");
        } else if (itrmcd[1] == 2) {
            Log.log("\nUncmin WARNING --- itrmcd = 2, probably converged, stepsize small\n\n");
        } else if (itrmcd[1] == 3) {
            Log.log("\nUncmin WARNING --- itrmcd = 3, cannot find lower point\n\n");
        } else if (itrmcd[1] == 4) {
            Log.log("\nUncmin WARNING --- itrmcd = 4, too many iterations\n\n");
        } else if (itrmcd[1] == 5) {
            Log.log("\nUncmin WARNING --- itrmcd = 5, too many large steps, possibly unbounded\n\n");
        }
    }

    public static void bakslv_f77(int n, double[][] a, double[] x, double[] b) {
        int i = n;
        x[i] = b[i] / a[i][i];
        while (i > 1) {
            int ip1 = i--;
            double sum = 0.0;
            for (int j = ip1; j <= n; ++j) {
                sum += a[j][i] * x[j];
            }
            x[i] = (b[i] - sum) / a[i][i];
        }
    }

    public static void chlhsn_f77(int n, double[][] a, double epsm, double[] sx, double[] udiag) {
        int im1;
        double amu;
        int i;
        int j;
        double[] addmax = new double[2];
        for (j = 1; j <= n; ++j) {
            for (i = j; i <= n; ++i) {
                double[] dArray = a[i];
                int n2 = j;
                dArray[n2] = dArray[n2] / (sx[i] * sx[j]);
            }
        }
        double tol = Math.sqrt(epsm);
        double diagmx = a[1][1];
        double diagmn = a[1][1];
        for (i = 2; i <= n; ++i) {
            if (a[i][i] < diagmn) {
                diagmn = a[i][i];
            }
            if (!(a[i][i] > diagmx)) continue;
            diagmx = a[i][i];
        }
        double posmax = Math.max(diagmx, 0.0);
        if (diagmn <= posmax * tol) {
            amu = tol * (posmax - diagmn) - diagmn;
            if (amu == 0.0) {
                double offmax = 0.0;
                for (i = 2; i <= n; ++i) {
                    im1 = i - 1;
                    for (j = 1; j <= im1; ++j) {
                        if (!(Math.abs(a[i][j]) > offmax)) continue;
                        offmax = Math.abs(a[i][j]);
                    }
                }
                amu = offmax;
                amu = amu == 0.0 ? 1.0 : (amu *= 1.0 + tol);
            }
            i = 1;
            while (i <= n) {
                double[] dArray = a[i];
                int n3 = i++;
                dArray[n3] = dArray[n3] + amu;
            }
            diagmx += amu;
        }
        for (j = 1; j <= n; ++j) {
            udiag[j] = a[j][j];
            for (i = j + 1; i <= n; ++i) {
                a[j][i] = a[i][j];
            }
        }
        Uncmin_f77.choldc_f77(n, a, diagmx, tol, addmax);
        if (addmax[1] > 0.0) {
            for (j = 1; j <= n; ++j) {
                a[j][j] = udiag[j];
                for (i = j + 1; i <= n; ++i) {
                    a[i][j] = a[j][i];
                }
            }
            double evmin = 0.0;
            double evmax = a[1][1];
            for (i = 1; i <= n; ++i) {
                double offrow = 0.0;
                im1 = i - 1;
                for (j = 1; j <= im1; ++j) {
                    offrow += Math.abs(a[i][j]);
                }
                for (j = i + 1; j <= n; ++j) {
                    offrow += Math.abs(a[j][i]);
                }
                evmin = Math.min(evmin, a[i][i] - offrow);
                evmax = Math.max(evmax, a[i][i] + offrow);
            }
            double sdd = tol * (evmax - evmin) - evmin;
            amu = Math.min(sdd, addmax[1]);
            for (i = 1; i <= n; ++i) {
                double[] dArray = a[i];
                int n4 = i;
                dArray[n4] = dArray[n4] + amu;
                udiag[i] = a[i][i];
            }
            Uncmin_f77.choldc_f77(n, a, 0.0, tol, addmax);
        }
        for (j = 1; j <= n; ++j) {
            for (i = j; i <= n; ++i) {
                double[] dArray = a[i];
                int n5 = j;
                dArray[n5] = dArray[n5] * sx[i];
            }
            int jm1 = j - 1;
            for (i = 1; i <= jm1; ++i) {
                double[] dArray = a[i];
                int n6 = j;
                dArray[n6] = dArray[n6] * (sx[i] * sx[j]);
            }
            int n7 = j;
            udiag[n7] = udiag[n7] * (sx[j] * sx[j]);
        }
    }

    public static void choldc_f77(int n, double[][] a, double diagmx, double tol, double[] addmax) {
        addmax[1] = 0.0;
        double aminl = Math.sqrt(diagmx * tol);
        double amnlsq = aminl * aminl;
        for (int j = 1; j <= n; ++j) {
            int i;
            int k;
            double sum = 0.0;
            int jm1 = j - 1;
            int jp1 = j + 1;
            for (k = 1; k <= jm1; ++k) {
                sum += a[j][k] * a[j][k];
            }
            double temp = a[j][j] - sum;
            if (temp >= amnlsq) {
                a[j][j] = Math.sqrt(temp);
            } else {
                double offmax = 0.0;
                for (i = jp1; i <= n; ++i) {
                    if (!(Math.abs(a[i][j]) > offmax)) continue;
                    offmax = Math.abs(a[i][j]);
                }
                if (offmax <= amnlsq) {
                    offmax = amnlsq;
                }
                a[j][j] = Math.sqrt(offmax);
                addmax[1] = Math.max(addmax[1], offmax - temp);
            }
            for (i = jp1; i <= n; ++i) {
                sum = 0.0;
                for (k = 1; k <= jm1; ++k) {
                    sum += a[i][k] * a[j][k];
                }
                a[i][j] = (a[i][j] - sum) / a[j][j];
            }
        }
    }

    public static void dfault_f77(int n, double[] x, double[] typsiz, double[] fscale, int[] method, int[] iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl) {
        for (int i = 1; i <= n; ++i) {
            typsiz[i] = 1.0;
        }
        fscale[1] = 1.0;
        dlt[1] = -1.0;
        double epsm = 1.12E-16;
        gradtl[1] = Math.pow(epsm, 0.3333333333333333);
        steptl[1] = Math.sqrt(epsm);
        stepmx[1] = 0.0;
        method[1] = 1;
        iexp[1] = 1;
        msg[1] = 0;
        ndigit[1] = -1;
        itnlim[1] = 150;
        iagflg[1] = 0;
        iahflg[1] = 0;
    }

    public static void dogdrv_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] p, double[] xpls, double[] fpls, Uncmin_methods minclass, double[] sx, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, boolean[] mxtake, double[] sc, double[] wrk1, double[] wrk2, double[] wrk3) {
        double[] fplsp = new double[2];
        double[] cln = new double[2];
        double[] eta = new double[2];
        boolean[] fstdog = new boolean[2];
        boolean[] nwtake = new boolean[2];
        iretcd[1] = 4;
        fstdog[1] = true;
        double tmp = 0.0;
        for (int i = 1; i <= n; ++i) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
        }
        double rnwtln = Math.sqrt(tmp);
        while (iretcd[1] > 1) {
            Uncmin_f77.dogstp_f77(n, g, a, p, sx, rnwtln, dlt, nwtake, fstdog, wrk1, wrk2, cln, eta, sc, stepmx);
            Uncmin_f77.tregup_f77(n, x, f, g, a, minclass, sc, sx, nwtake, stepmx, steptl, dlt, iretcd, wrk3, fplsp, xpls, fpls, mxtake, 2, wrk1);
        }
    }

    public static void dogstp_f77(int n, double[] g, double[][] a, double[] p, double[] sx, double rnwtln, double[] dlt, boolean[] nwtake, boolean[] fstdog, double[] ssd, double[] v, double[] cln, double[] eta, double[] sc, double[] stepmx) {
        if (rnwtln <= dlt[1]) {
            nwtake[1] = true;
            for (int i = 1; i <= n; ++i) {
                sc[i] = p[i];
            }
            dlt[1] = rnwtln;
        } else {
            int i;
            nwtake[1] = false;
            if (fstdog[1]) {
                fstdog[1] = false;
                double alpha = 0.0;
                for (i = 1; i <= n; ++i) {
                    alpha += g[i] * g[i] / (sx[i] * sx[i]);
                }
                double beta = 0.0;
                for (i = 1; i <= n; ++i) {
                    double tmp = 0.0;
                    for (int j = i; j <= n; ++j) {
                        tmp += a[j][i] * g[j] / (sx[j] * sx[j]);
                    }
                    beta += tmp * tmp;
                }
                for (i = 1; i <= n; ++i) {
                    ssd[i] = -(alpha / beta) * g[i] / sx[i];
                }
                cln[1] = alpha * Math.sqrt(alpha) / beta;
                eta[1] = 0.2 + 0.8 * alpha * alpha / (-beta * Blas_f77.ddot_f77(n, g, 1, p, 1));
                for (i = 1; i <= n; ++i) {
                    v[i] = eta[1] * sx[i] * p[i] - ssd[i];
                }
                if (dlt[1] == -1.0) {
                    dlt[1] = Math.min(cln[1], stepmx[1]);
                }
            }
            if (eta[1] * rnwtln <= dlt[1]) {
                for (i = 1; i <= n; ++i) {
                    sc[i] = dlt[1] / rnwtln * p[i];
                }
            } else if (cln[1] >= dlt[1]) {
                for (i = 1; i <= n; ++i) {
                    sc[i] = dlt[1] / cln[1] * ssd[i] / sx[i];
                }
            } else {
                double dot1 = Blas_f77.ddot_f77(n, v, 1, ssd, 1);
                double dot2 = Blas_f77.ddot_f77(n, v, 1, v, 1);
                double alam = (-dot1 + Math.sqrt(dot1 * dot1 - dot2 * (cln[1] * cln[1] - dlt[1] * dlt[1]))) / dot2;
                for (i = 1; i <= n; ++i) {
                    sc[i] = (ssd[i] + alam * v[i]) / sx[i];
                }
            }
        }
    }

    public static void forslv_f77(int n, double[][] a, double[] x, double[] b) {
        x[1] = b[1] / a[1][1];
        for (int i = 2; i <= n; ++i) {
            double sum = 0.0;
            int im1 = i - 1;
            for (int j = 1; j <= im1; ++j) {
                sum += a[i][j] * x[j];
            }
            x[i] = (b[i] - sum) / a[i][i];
        }
    }

    public static void fstocd_f77(int n, double[] x, Uncmin_methods minclass, double[] sx, double rnoise, double[] g) {
        double xmult = Math.pow(rnoise, 0.3333333333333333);
        for (int i = 1; i <= n; ++i) {
            double stepi = xmult * Math.max(Math.abs(x[i]), 1.0 / sx[i]);
            double xtempi = x[i];
            x[i] = xtempi + stepi;
            double fplus = minclass.f_to_minimize(x);
            x[i] = xtempi - stepi;
            double fminus = minclass.f_to_minimize(x);
            x[i] = xtempi;
            g[i] = (fplus - fminus) / (2.0 * stepi);
        }
    }

    public static void fstofd_f77(int n, double[] xpls, Uncmin_methods minclass, double[] fpls, double[][] a, double[] sx, double rnoise, double[] fhat) {
        int i;
        int j;
        double xmult = Math.sqrt(rnoise);
        for (j = 1; j <= n; ++j) {
            double stepsz = xmult * Math.max(Math.abs(xpls[j]), 1.0 / sx[j]);
            double xtmpj = xpls[j];
            xpls[j] = xtmpj + stepsz;
            minclass.gradient(xpls, fhat);
            xpls[j] = xtmpj;
            for (i = 1; i <= n; ++i) {
                a[i][j] = (fhat[i] - fpls[i]) / stepsz;
            }
        }
        int nm1 = n - 1;
        for (j = 1; j <= nm1; ++j) {
            for (i = j + 1; i <= n; ++i) {
                a[i][j] = (a[i][j] + a[j][i]) / 2.0;
            }
        }
    }

    public static void fstofd_f77(int n, double[] xpls, Uncmin_methods minclass, double[] fpls, double[] g, double[] sx, double rnoise) {
        double xmult = Math.sqrt(rnoise);
        for (int j = 1; j <= n; ++j) {
            double stepsz = xmult * Math.max(Math.abs(xpls[j]), 1.0 / sx[j]);
            double xtmpj = xpls[j];
            xpls[j] = xtmpj + stepsz;
            double fhat = minclass.f_to_minimize(xpls);
            xpls[j] = xtmpj;
            g[j] = (fhat - fpls[1]) / stepsz;
        }
    }

    public static void grdchk_f77(int n, double[] x, Uncmin_methods minclass, double[] f, double[] g, double[] typsiz, double[] sx, double[] fscale, double rnf, double analtl, double[] gest) {
        int i;
        Uncmin_f77.fstofd_f77(n, x, minclass, f, gest, sx, rnf);
        boolean ker = false;
        for (i = 1; i <= n; ++i) {
            double gs = Math.max(Math.abs(f[1]), fscale[1]) / Math.max(Math.abs(x[i]), typsiz[i]);
            if (!(Math.abs(g[i] - gest[i]) > Math.max(Math.abs(g[i]), gs) * analtl)) continue;
            ker = true;
        }
        if (!ker) {
            return;
        }
        Log.log("\nThere appears to be an error in the coding");
        Log.log(" of the gradient method.\n\n\n");
        Log.log("Component   Analytic   Finite Difference\n\n");
        for (i = 1; i <= n; ++i) {
            Log.log(3, i + "  " + g[i] + "  " + gest[i]);
        }
        System.exit(0);
    }

    public static void heschk_f77(int n, double[] x, Uncmin_methods minclass, double[] f, double[] g, double[][] a, double[] typsiz, double[] sx, double rnf, double analtl, int[] iagflg, double[] udiag, double[] wrk1, double[] wrk2) {
        int i;
        int j;
        if (iagflg[1] == 1) {
            Uncmin_f77.fstofd_f77(n, x, minclass, g, a, sx, rnf, wrk1);
        }
        if (iagflg[1] != 1) {
            Uncmin_f77.sndofd_f77(n, x, minclass, f, a, sx, rnf, wrk1, wrk2);
        }
        boolean ker = false;
        for (j = 1; j <= n; ++j) {
            udiag[j] = a[j][j];
            for (i = j + 1; i <= n; ++i) {
                a[j][i] = a[i][j];
            }
        }
        minclass.hessian(x, a);
        for (j = 1; j <= n; ++j) {
            double hs = Math.max(Math.abs(g[j]), 1.0) / Math.max(Math.abs(x[j]), typsiz[j]);
            if (Math.abs(a[j][j] - udiag[j]) > Math.max(Math.abs(udiag[j]), hs) * analtl) {
                ker = true;
            }
            for (i = j + 1; i <= n; ++i) {
                if (!(Math.abs(a[i][j] - a[j][i]) > Math.max(Math.abs(a[i][j]), hs) * analtl)) continue;
                ker = true;
            }
        }
        if (!ker) {
            return;
        }
        Log.log("\nThere appears to be an error in the coding");
        Log.log(" of the Hessian method.\n\n\n");
        Log.log("Row   Column   Analytic   Finite Difference\n\n");
        for (i = 1; i <= n; ++i) {
            for (j = 1; j < i; ++j) {
                Log.log(3, i + "  " + j + "  " + a[i][j] + "  " + a[j][i]);
            }
            Log.log(3, i + "  " + i + "  " + a[i][i] + "  " + udiag[i]);
        }
        System.exit(0);
    }

    public static void hookdr_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] udiag, double[] p, double[] xpls, double[] fpls, Uncmin_methods minclass, double[] sx, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, boolean[] mxtake, double[] amu, double[] dltp, double[] phi, double[] phip0, double[] sc, double[] xplsp, double[] wrk0, double epsm, int[] itncnt) {
        int i;
        boolean[] fstime = new boolean[2];
        boolean[] nwtake = new boolean[2];
        double[] fplsp = new double[2];
        iretcd[1] = 4;
        fstime[1] = true;
        double tmp = 0.0;
        for (i = 1; i <= n; ++i) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
        }
        double rnwtln = Math.sqrt(tmp);
        if (itncnt[1] == 1) {
            amu[1] = 0.0;
            if (dlt[1] == -1.0) {
                double alpha = 0.0;
                for (i = 1; i <= n; ++i) {
                    alpha += g[i] * g[i] / (sx[i] * sx[i]);
                }
                double beta = 0.0;
                for (i = 1; i <= n; ++i) {
                    tmp = 0.0;
                    for (int j = i; j <= n; ++j) {
                        tmp += a[j][i] * g[j] / (sx[j] * sx[j]);
                    }
                    beta += tmp * tmp;
                }
                dlt[1] = alpha * Math.sqrt(alpha) / beta;
                dlt[1] = Math.min(dlt[1], stepmx[1]);
            }
        }
        while (iretcd[1] > 1) {
            Uncmin_f77.hookst_f77(n, g, a, udiag, p, sx, rnwtln, dlt, amu, dltp, phi, phip0, fstime, sc, nwtake, wrk0, epsm);
            dltp[1] = dlt[1];
            Uncmin_f77.tregup_f77(n, x, f, g, a, minclass, sc, sx, nwtake, stepmx, steptl, dlt, iretcd, xplsp, fplsp, xpls, fpls, mxtake, 3, udiag);
        }
    }

    public static void hookst_f77(int n, double[] g, double[][] a, double[] udiag, double[] p, double[] sx, double rnwtln, double[] dlt, double[] amu, double[] dltp, double[] phi, double[] phip0, boolean[] fstime, double[] sc, boolean[] nwtake, double[] wrk0, double epsm) {
        int i;
        double[] addmax = new double[2];
        double phip = 0.0;
        double hi = 1.5;
        double alo = 0.75;
        if (rnwtln <= hi * dlt[1]) {
            nwtake[1] = true;
            for (int i2 = 1; i2 <= n; ++i2) {
                sc[i2] = p[i2];
            }
            dlt[1] = Math.min(dlt[1], rnwtln);
            amu[1] = 0.0;
            return;
        }
        nwtake[1] = false;
        if (amu[1] > 0.0) {
            amu[1] = amu[1] - (phi[1] + dltp[1]) * (dltp[1] - dlt[1] + phi[1]) / (dlt[1] * phip);
        }
        phi[1] = rnwtln - dlt[1];
        if (fstime[1]) {
            for (i = 1; i <= n; ++i) {
                wrk0[i] = sx[i] * sx[i] * p[i];
            }
            Uncmin_f77.forslv_f77(n, a, wrk0, wrk0);
            phip0[1] = -Math.pow(Blas_f77.dnrm2_f77(n, wrk0, 1), 2.0) / rnwtln;
            fstime[1] = false;
        }
        phip = phip0[1];
        double amulo = -phi[1] / phip;
        double amuup = 0.0;
        for (i = 1; i <= n; ++i) {
            amuup += g[i] * g[i] / (sx[i] * sx[i]);
        }
        amuup = Math.sqrt(amuup) / dlt[1];
        boolean done = false;
        while (!done) {
            if (amu[1] < amulo || amu[1] > amuup) {
                amu[1] = Math.max(Math.sqrt(amulo * amuup), amuup * 0.001);
            }
            for (int j = 1; j <= n; ++j) {
                a[j][j] = udiag[j] + amu[1] * sx[j] * sx[j];
                for (i = j + 1; i <= n; ++i) {
                    a[i][j] = a[j][i];
                }
            }
            Uncmin_f77.choldc_f77(n, a, 0.0, Math.sqrt(epsm), addmax);
            for (i = 1; i <= n; ++i) {
                wrk0[i] = -g[i];
            }
            Uncmin_f77.lltslv_f77(n, a, sc, wrk0);
            double stepln = 0.0;
            for (i = 1; i <= n; ++i) {
                stepln += sx[i] * sx[i] * sc[i] * sc[i];
            }
            stepln = Math.sqrt(stepln);
            phi[1] = stepln - dlt[1];
            for (i = 1; i <= n; ++i) {
                wrk0[i] = sx[i] * sx[i] * sc[i];
            }
            Uncmin_f77.forslv_f77(n, a, wrk0, wrk0);
            phip = -Math.pow(Blas_f77.dnrm2_f77(n, wrk0, 1), 2.0) / stepln;
            if (alo * dlt[1] <= stepln && stepln <= hi * dlt[1] || amuup - amulo <= 0.0) {
                done = true;
                continue;
            }
            amulo = Math.max(amulo, amu[1] - phi[1] / phip);
            if (phi[1] < 0.0) {
                amuup = Math.min(amuup, amu[1]);
            }
            amu[1] = amu[1] - stepln * phi[1] / (dlt[1] * phip);
        }
    }

    public static void hsnint_f77(int n, double[][] a, double[] sx, int[] method) {
        for (int j = 1; j <= n; ++j) {
            a[j][j] = method[1] == 3 ? sx[j] * sx[j] : sx[j];
            for (int i = j + 1; i <= n; ++i) {
                a[i][j] = 0.0;
            }
        }
    }

    public static void lltslv_f77(int n, double[][] a, double[] x, double[] b) {
        Uncmin_f77.forslv_f77(n, a, x, b);
        Uncmin_f77.bakslv_f77(n, a, x, x);
    }

    public static void lnsrch_f77(int n, double[] x, double[] f, double[] g, double[] p, double[] xpls, double[] fpls, Uncmin_methods minclass, boolean[] mxtake, int[] iretcd, double[] stepmx, double[] steptl, double[] sx) {
        int i;
        double pfpls = 0.0;
        double plmbda = 0.0;
        mxtake[1] = false;
        iretcd[1] = 2;
        double tmp = 0.0;
        for (i = 1; i <= n; ++i) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
        }
        double sln = Math.sqrt(tmp);
        if (sln > stepmx[1]) {
            double scl = stepmx[1] / sln;
            Uncmin_f77.sclmul_f77(n, scl, p, p);
            sln = stepmx[1];
        }
        double slp = Blas_f77.ddot_f77(n, g, 1, p, 1);
        double rln = 0.0;
        for (i = 1; i <= n; ++i) {
            rln = Math.max(rln, Math.abs(p[i]) / Math.max(Math.abs(x[i]), 1.0 / sx[i]));
        }
        double rmnlmb = steptl[1] / rln;
        double almbda = 1.0;
        while (iretcd[1] >= 2) {
            double tlmbda;
            for (i = 1; i <= n; ++i) {
                xpls[i] = x[i] + almbda * p[i];
            }
            fpls[1] = minclass.f_to_minimize(xpls);
            if (fpls[1] <= f[1] + slp * 1.0E-4 * almbda) {
                iretcd[1] = 0;
                if (almbda != 1.0 || !(sln > 0.99 * stepmx[1])) continue;
                mxtake[1] = true;
                continue;
            }
            if (almbda < rmnlmb) {
                iretcd[1] = 1;
                continue;
            }
            if (almbda == 1.0) {
                tlmbda = -slp / (2.0 * (fpls[1] - f[1] - slp));
            } else {
                double t3 = 1.0 / (almbda - plmbda);
                double t2 = pfpls - f[1] - plmbda * slp;
                double t1 = fpls[1] - f[1] - almbda * slp;
                double b = t3 * (t2 * almbda / (plmbda * plmbda) - t1 * plmbda / (almbda * almbda));
                double a = t3 * (t1 / (almbda * almbda) - t2 / (plmbda * plmbda));
                double disc = b * b - 3.0 * a * slp;
                tlmbda = disc > b * b ? (-b + Blas_f77.sign_f77(1.0, a) * Math.sqrt(disc)) / (3.0 * a) : (-b - Blas_f77.sign_f77(1.0, a) * Math.sqrt(disc)) / (3.0 * a);
                if (tlmbda > 0.5 * almbda) {
                    tlmbda = 0.5 * almbda;
                }
            }
            plmbda = almbda;
            pfpls = fpls[1];
            if (tlmbda < almbda / 10.0) {
                almbda *= 0.1;
                continue;
            }
            almbda = tlmbda;
        }
    }

    public static void mvmltl_f77(int n, double[][] a, double[] x, double[] y) {
        for (int i = 1; i <= n; ++i) {
            double sum = 0.0;
            for (int j = 1; j <= i; ++j) {
                sum += a[i][j] * x[j];
            }
            y[i] = sum;
        }
    }

    public static void mvmlts_f77(int n, double[][] a, double[] x, double[] y) {
        for (int i = 1; i <= n; ++i) {
            int j;
            double sum = 0.0;
            for (j = 1; j <= i; ++j) {
                sum += a[i][j] * x[j];
            }
            for (j = i + 1; j <= n; ++j) {
                sum += a[j][i] * x[j];
            }
            y[i] = sum;
        }
    }

    public static void mvmltu_f77(int n, double[][] a, double[] x, double[] y) {
        for (int i = 1; i <= n; ++i) {
            double sum = 0.0;
            for (int j = i; j <= n; ++j) {
                sum += a[j][i] * x[j];
            }
            y[i] = sum;
        }
    }

    public static void optchk_f77(int n, double[] x, double[] typsiz, double[] sx, double[] fscale, double[] gradtl, int[] itnlim, int[] ndigit, double epsm, double[] dlt, int[] method, int[] iexp, int[] iagflg, int[] iahflg, double[] stepmx, int[] msg) {
        int i;
        if (method[1] < 1 || method[1] > 3) {
            method[1] = 1;
        }
        if (iagflg[1] != 1) {
            iagflg[1] = 0;
        }
        if (iahflg[1] != 1) {
            iahflg[1] = 0;
        }
        if (iexp[1] != 0) {
            iexp[1] = 1;
        }
        if (msg[1] / 2 % 2 == 1 && iagflg[1] == 0) {
            Log.log("\n\nOPTCHK   User requests that analytic gradient");
            Log.log(" be accepted as properly coded,\n");
            Log.log("OPTCHK   msg = " + msg + ",\n");
            Log.log("OPTCHK   but an analytic gradient is not");
            Log.log(" supplied,\n");
            Log.log("OPTCHK   iagflg = " + iagflg[1] + ".\n\n");
            System.exit(0);
        }
        if (msg[1] / 4 % 2 == 1 && iahflg[1] == 0) {
            Log.log("\n\nOPTCHK   User requests that analytic Hessian");
            Log.log(" be accepted as properly coded,\n");
            Log.log("OPTCHK   msg = " + msg + ",\n");
            Log.log("OPTCHK   but an analytic Hessian is not");
            Log.log(" supplied,\n");
            Log.log("OPTCHK   iahflg = " + iahflg[1] + ".\n\n");
            System.exit(0);
        }
        if (n <= 0) {
            Log.log("\n\nOPTCHK   Illegal dimension, n = " + n + "\n\n");
            System.exit(0);
        }
        if (n == 1 && msg[1] % 2 == 0) {
            Log.log("\n\nOPTCHK   !!!WARNING!!!  This class is ");
            Log.log("inefficient for problems of size 1.\n");
            Log.log("OPTCHK   You might want to try Fmin instead.\n\n");
            msg[1] = -2;
        }
        for (i = 1; i <= n; ++i) {
            if (typsiz[i] == 0.0) {
                typsiz[i] = 1.0;
            }
            if (typsiz[i] < 0.0) {
                typsiz[i] = -typsiz[i];
            }
            sx[i] = 1.0 / typsiz[i];
        }
        if (stepmx[1] <= 0.0) {
            double stpsiz = 0.0;
            for (i = 1; i <= n; ++i) {
                stpsiz += x[i] * x[i] * sx[i] * sx[i];
            }
            stpsiz = Math.sqrt(stpsiz);
            stepmx[1] = Math.max(1000.0 * stpsiz, 1000.0);
        }
        if (fscale[1] == 0.0) {
            fscale[1] = 1.0;
        }
        if (fscale[1] < 0.0) {
            fscale[1] = -fscale[1];
        }
        if (gradtl[1] < 0.0) {
            Log.log("\n\nOPTCHK   Illegal tolerance, gradtl = " + gradtl[1] + "\n\n");
            System.exit(0);
        }
        if (itnlim[1] < 0) {
            Log.log("\n\nOPTCHK   Illegal iteration limit,");
            Log.log(" itnlim = " + itnlim[1] + "\n\n");
            System.exit(0);
        }
        if (ndigit[1] == 0) {
            Log.log("\n\nOPTCHK   Minimization function has no good");
            Log.log(" digits, ndigit = " + ndigit + "\n\n");
            System.exit(0);
        }
        if (ndigit[1] < 0) {
            ndigit[1] = (int)(-Math.log(epsm) / Math.log(10.0));
        }
        if (dlt[1] <= 0.0) {
            dlt[1] = -1.0;
        }
        if (dlt[1] > stepmx[1]) {
            dlt[1] = stepmx[1];
        }
    }

    public static void optdrv_f77(int n, double[] x, Uncmin_methods minclass, double[] typsiz, double[] fscale, int[] method, int[] iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag, double[] g, double[] p, double[] sx, double[] wrk0, double[] wrk1, double[] wrk2, double[] wrk3) {
        int i;
        boolean[] noupdt = new boolean[2];
        boolean[] mxtake = new boolean[2];
        int[] icscmx = new int[2];
        int[] iretcd = new int[2];
        int[] itncnt = new int[2];
        double[] f = new double[2];
        double[] amu = new double[2];
        double[] dltp = new double[2];
        double[] phi = new double[2];
        double[] phip0 = new double[2];
        double phpsav = 0.0;
        double phisav = 0.0;
        double dlpsav = 0.0;
        double amusav = 0.0;
        double dltsav = 0.0;
        for (i = 1; i <= n; ++i) {
            p[i] = 0.0;
        }
        itncnt[1] = 0;
        iretcd[1] = -1;
        double epsm = 1.12E-16;
        Uncmin_f77.optchk_f77(n, x, typsiz, sx, fscale, gradtl, itnlim, ndigit, epsm, dlt, method, iexp, iagflg, iahflg, stepmx, msg);
        double rnf = Math.max(Math.pow(10.0, -ndigit[1]), epsm);
        double analtl = Math.max(0.01, Math.sqrt(rnf));
        if (msg[1] / 8 % 2 != 1) {
            int j;
            int num5 = n / 5;
            int remain = n % 5;
            Log.log("\n\nOPTDRV          Typical x\n\n");
            int ilow = -4;
            int ihigh = 0;
            for (i = 1; i <= num5; ++i) {
                Log.log((ilow += 5) + "--" + (ihigh += 5) + "     ");
                for (j = 1; j <= 5; ++j) {
                    Log.log(typsiz[ilow + j - 1] + "  ");
                }
                Log.log("\n");
            }
            ihigh = (ilow += 5) + remain - 1;
            Log.log(ilow + "--" + ihigh + "     ");
            for (j = 1; j <= remain; ++j) {
                Log.log(typsiz[ilow + j - 1] + "  ");
            }
            Log.log("\n");
            Log.log("\n\nOPTDRV      Scaling vector for x\n\n");
            ilow = -4;
            ihigh = 0;
            for (i = 1; i <= num5; ++i) {
                Log.log((ilow += 5) + "--" + (ihigh += 5) + "     ");
                for (j = 1; j <= 5; ++j) {
                    Log.log(sx[ilow + j - 1] + "  ");
                }
                Log.log("\n");
            }
            ihigh = (ilow += 5) + remain - 1;
            Log.log(ilow + "--" + ihigh + "     ");
            for (j = 1; j <= remain; ++j) {
                Log.log(sx[ilow + j - 1] + "  ");
            }
            Log.log("\n");
            Log.log(3, "\n\nOPTDRV      Typical f = " + fscale[1]);
            Log.log("OPTDRV      Number of good digits in");
            Log.log(3, " f_to_minimize = " + ndigit[1]);
            Log.log("OPTDRV      Gradient flag");
            Log.log(3, " = " + iagflg[1]);
            Log.log("OPTDRV      Hessian flag");
            Log.log(3, " = " + iahflg[1]);
            Log.log("OPTDRV      Expensive function calculation flag");
            Log.log(3, " = " + iexp[1]);
            Log.log("OPTDRV      Method to use");
            Log.log(3, " = " + method[1]);
            Log.log("OPTDRV      Iteration limit");
            Log.log(3, " = " + itnlim[1]);
            Log.log("OPTDRV      Machine epsilon");
            Log.log(3, " = " + epsm);
            Log.log("OPTDRV      Maximum step size");
            Log.log(3, " = " + stepmx[1]);
            Log.log("OPTDRV      Step tolerance");
            Log.log(3, " = " + steptl[1]);
            Log.log("OPTDRV      Gradient tolerance");
            Log.log(3, " = " + gradtl[1]);
            Log.log("OPTDRV      Trust region radius");
            Log.log(3, " = " + dlt[1]);
            Log.log("OPTDRV      Relative noise in");
            Log.log(3, " f_to_minimize = " + rnf);
            Log.log("OPTDRV      Analytical fd tolerance");
            Log.log(3, " = " + analtl);
        }
        f[1] = minclass.f_to_minimize(x);
        if (iagflg[1] == 0) {
            Uncmin_f77.fstofd_f77(n, x, minclass, f, g, sx, rnf);
        } else {
            minclass.gradient(x, g);
            if (msg[1] / 2 % 2 == 0) {
                Uncmin_f77.grdchk_f77(n, x, minclass, f, g, typsiz, sx, fscale, rnf, analtl, wrk1);
            }
        }
        Uncmin_f77.optstp_f77(n, x, f, g, wrk1, itncnt, icscmx, itrmcd, gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, msg);
        if (itrmcd[1] != 0) {
            fpls[1] = f[1];
            for (i = 1; i <= n; ++i) {
                xpls[i] = x[i];
                gpls[i] = g[i];
            }
        } else {
            if (iexp[1] == 1) {
                Uncmin_f77.hsnint_f77(n, a, sx, method);
            } else if (iahflg[1] == 0) {
                if (iagflg[1] == 1) {
                    Uncmin_f77.fstofd_f77(n, x, minclass, g, a, sx, rnf, wrk1);
                } else {
                    Uncmin_f77.sndofd_f77(n, x, minclass, f, a, sx, rnf, wrk1, wrk2);
                }
            } else if (msg[1] / 4 % 2 == 1) {
                minclass.hessian(x, a);
            } else {
                Uncmin_f77.heschk_f77(n, x, minclass, f, g, a, typsiz, sx, rnf, analtl, iagflg, udiag, wrk1, wrk2);
            }
            if (msg[1] / 8 % 2 == 0) {
                Uncmin_f77.result_f77(n, x, f, g, a, p, itncnt, 1);
            }
            while (itrmcd[1] == 0) {
                itncnt[1] = itncnt[1] + 1;
                if (iexp[1] != 1 || method[1] == 3) {
                    Uncmin_f77.chlhsn_f77(n, a, epsm, sx, udiag);
                }
                for (i = 1; i <= n; ++i) {
                    wrk1[i] = -g[i];
                }
                Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                if (iagflg[1] == 0 && method[1] != 1) {
                    dltsav = dlt[1];
                    if (method[1] != 2) {
                        amusav = amu[1];
                        dlpsav = dltp[1];
                        phisav = phi[1];
                        phpsav = phip0[1];
                    }
                }
                if (method[1] == 1) {
                    Uncmin_f77.lnsrch_f77(n, x, f, g, p, xpls, fpls, minclass, mxtake, iretcd, stepmx, steptl, sx);
                } else if (method[1] == 2) {
                    Uncmin_f77.dogdrv_f77(n, x, f, g, a, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, wrk0, wrk1, wrk2, wrk3);
                } else {
                    Uncmin_f77.hookdr_f77(n, x, f, g, a, udiag, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, amu, dltp, phi, phip0, wrk0, wrk1, wrk2, epsm, itncnt);
                }
                if (iretcd[1] == 1 && iagflg[1] == 0) {
                    iagflg[1] = -1;
                    Log.log("\nOPTDRV      Shift from forward to central");
                    Log.log(" differences");
                    Log.log("\nOPTDRV      in iteration " + itncnt[1]);
                    Log.log("\n");
                    Uncmin_f77.fstocd_f77(n, x, minclass, sx, rnf, g);
                    if (method[1] == 1) {
                        for (i = 1; i <= n; ++i) {
                            wrk1[i] = -g[i];
                        }
                        Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                        Uncmin_f77.lnsrch_f77(n, x, f, g, p, xpls, fpls, minclass, mxtake, iretcd, stepmx, steptl, sx);
                    } else {
                        dlt[1] = dltsav;
                        if (method[1] == 2) {
                            for (i = 1; i <= n; ++i) {
                                wrk1[i] = -g[i];
                            }
                            Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                            Uncmin_f77.dogdrv_f77(n, x, f, g, a, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, wrk0, wrk1, wrk2, wrk3);
                        } else {
                            amu[1] = amusav;
                            dltp[1] = dlpsav;
                            phi[1] = phisav;
                            phip0[1] = phpsav;
                            Uncmin_f77.chlhsn_f77(n, a, epsm, sx, udiag);
                            for (i = 1; i <= n; ++i) {
                                wrk1[i] = -g[i];
                            }
                            Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                            Uncmin_f77.hookdr_f77(n, x, f, g, a, udiag, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, amu, dltp, phi, phip0, wrk0, wrk1, wrk2, epsm, itncnt);
                        }
                    }
                }
                for (i = 1; i <= n; ++i) {
                    p[i] = xpls[i] - x[i];
                }
                if (iagflg[1] == -1) {
                    Uncmin_f77.fstocd_f77(n, xpls, minclass, sx, rnf, gpls);
                } else if (iagflg[1] == 0) {
                    Uncmin_f77.fstofd_f77(n, xpls, minclass, fpls, gpls, sx, rnf);
                } else {
                    minclass.gradient(xpls, gpls);
                }
                Uncmin_f77.optstp_f77(n, xpls, fpls, gpls, x, itncnt, icscmx, itrmcd, gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, msg);
                if (itrmcd[1] != 0) continue;
                if (iexp[1] != 0) {
                    if (method[1] == 3) {
                        Uncmin_f77.secunf_f77(n, x, g, a, udiag, xpls, gpls, epsm, itncnt, rnf, iagflg, noupdt, wrk1, wrk2, wrk3);
                    } else {
                        Uncmin_f77.secfac_f77(n, x, g, a, xpls, gpls, epsm, itncnt, rnf, iagflg, noupdt, wrk0, wrk1, wrk2, wrk3);
                    }
                } else if (iahflg[1] == 1) {
                    minclass.hessian(xpls, a);
                } else if (iagflg[1] == 1) {
                    Uncmin_f77.fstofd_f77(n, xpls, minclass, gpls, a, sx, rnf, wrk1);
                } else {
                    Uncmin_f77.sndofd_f77(n, xpls, minclass, fpls, a, sx, rnf, wrk1, wrk2);
                }
                if (msg[1] / 16 % 2 == 1) {
                    Uncmin_f77.result_f77(n, xpls, fpls, gpls, a, p, itncnt, 1);
                }
                f[1] = fpls[1];
                for (i = 1; i <= n; ++i) {
                    x[i] = xpls[i];
                    g[i] = gpls[i];
                }
            }
            if (itrmcd[1] == 3) {
                fpls[1] = f[1];
                for (i = 1; i <= n; ++i) {
                    xpls[i] = x[i];
                    gpls[i] = g[i];
                }
            }
        }
        if (msg[1] / 8 % 2 == 0) {
            Uncmin_f77.result_f77(n, xpls, fpls, gpls, a, p, itncnt, 0);
        }
        msg[1] = 0;
    }

    public static void optstp_f77(int n, double[] xpls, double[] fpls, double[] gpls, double[] x, int[] itncnt, int[] icscmx, int[] itrmcd, double[] gradtl, double[] steptl, double[] sx, double[] fscale, int[] itnlim, int[] iretcd, boolean[] mxtake, int[] msg) {
        int i;
        itrmcd[1] = 0;
        if (iretcd[1] == 1) {
            itrmcd[1] = 3;
            if (msg[1] / 8 % 2 == 0) {
                Log.log("\n\nOPTSTP    The last global step failed");
                Log.log(" to locate a point lower than x.\n");
                Log.log("OPTSTP    Either x is an approximate local");
                Log.log(" minimum of the function,\n");
                Log.log("OPTSTP    the function is too nonlinear for");
                Log.log(" this algorithm, or\n");
                Log.log("OPTSTP    steptl is too large.\n");
            }
            return;
        }
        double d = Math.max(Math.abs(fpls[1]), fscale[1]);
        double rgx = 0.0;
        for (i = 1; i <= n; ++i) {
            double relgrd = Math.abs(gpls[i]) * Math.max(Math.abs(xpls[i]), 1.0 / sx[i]) / d;
            rgx = Math.max(rgx, relgrd);
        }
        if (rgx <= gradtl[1]) {
            itrmcd[1] = 1;
            if (msg[1] / 8 % 2 == 0) {
                Log.log("\n\nOPTSTP    The relative gradient is close");
                Log.log(" to zero.\n");
                Log.log("OPTSTP    The current iterate is probably");
                Log.log(" a solution.\n");
            }
            return;
        }
        if (itncnt[1] == 0) {
            return;
        }
        double rsx = 0.0;
        for (i = 1; i <= n; ++i) {
            double relstp = Math.abs(xpls[i] - x[i]) / Math.max(Math.abs(xpls[i]), 1.0 / sx[i]);
            rsx = Math.max(rsx, relstp);
        }
        if (rsx <= steptl[1]) {
            itrmcd[1] = 2;
            if (msg[1] / 8 % 2 == 0) {
                Log.log("\n\nOPTSTP    Successive iterates are within");
                Log.log(" steptl.\n");
                Log.log("OPTSTP    The current iterate is probably");
                Log.log(" a solution.\n");
            }
            return;
        }
        if (itncnt[1] >= itnlim[1]) {
            itrmcd[1] = 4;
            if (msg[1] / 8 % 2 == 0) {
                Log.log("\n\nOPTSTP    The iteration limit was reached.\n");
                Log.log("OPTSTP    The algorithm failed.\n");
            }
            return;
        }
        if (!mxtake[1]) {
            icscmx[1] = 0;
            return;
        }
        if (msg[1] / 8 % 2 == 0) {
            Log.log("\n\nOPTSTP    Step of maximum length (stepmx)");
            Log.log(" taken.\n");
        }
        icscmx[1] = icscmx[1] + 1;
        if (icscmx[1] < 5) {
            return;
        }
        itrmcd[1] = 5;
        if (msg[1] / 8 % 2 == 0) {
            Log.log("\n\nOPTSTP    Maximum step size exceeded");
            Log.log(" five consecutive times.\n");
            Log.log("OPTSTP    Either the function is unbounded");
            Log.log(" below,\n");
            Log.log("OPTSTP    becomes asymptotic to a finite value");
            Log.log(" from above in some direction, or\n");
            Log.log("OPTSTP    stepmx is too small.\n");
        }
    }

    public static void qraux1_f77(int n, double[][] r, int i) {
        int ip1 = i + 1;
        for (int j = i; j <= n; ++j) {
            double tmp = r[i][j];
            r[i][j] = r[ip1][j];
            r[ip1][j] = tmp;
        }
    }

    public static void qraux2_f77(int n, double[][] r, int i, double a, double b) {
        int ip1 = i + 1;
        double den = Math.sqrt(a * a + b * b);
        double c = a / den;
        double s = b / den;
        for (int j = i; j <= n; ++j) {
            double y = r[i][j];
            double z = r[ip1][j];
            r[i][j] = c * y - s * z;
            r[ip1][j] = s * y + c * z;
        }
    }

    public static void qrupdt_f77(int n, double[][] a, double[] u, double[] v) {
        int i;
        int k;
        for (k = n; u[k] == 0.0 && k > 1; --k) {
        }
        int km1 = k - 1;
        for (int ii = 1; ii <= km1; ++ii) {
            i = km1 - ii + 1;
            if (u[i] == 0.0) {
                Uncmin_f77.qraux1_f77(n, a, i);
                u[i] = u[i + 1];
                continue;
            }
            Uncmin_f77.qraux2_f77(n, a, i, u[i], -u[i + 1]);
            u[i] = Math.sqrt(u[i] * u[i] + u[i + 1] * u[i + 1]);
        }
        for (int j = 1; j <= n; ++j) {
            double[] dArray = a[1];
            int n2 = j;
            dArray[n2] = dArray[n2] + u[1] * v[j];
        }
        km1 = k - 1;
        for (i = 1; i <= km1; ++i) {
            if (a[i][i] == 0.0) {
                Uncmin_f77.qraux1_f77(n, a, i);
                continue;
            }
            double t1 = a[i][i];
            double t2 = -a[i + 1][i];
            Uncmin_f77.qraux2_f77(n, a, i, t1, t2);
        }
    }

    public static void result_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] p, int[] itncnt, int iflg) {
        int j;
        int i;
        int ihigh;
        int ilow;
        int num5 = n / 5;
        int remain = n % 5;
        Log.log("\n\nRESULT      Iterate k = " + itncnt[1] + "\n");
        if (iflg != 0) {
            Log.log("\n\nRESULT      Step\n\n");
            ilow = -4;
            ihigh = 0;
            for (i = 1; i <= num5; ++i) {
                Log.log((ilow += 5) + "--" + (ihigh += 5) + "     ");
                for (j = 1; j <= 5; ++j) {
                    Log.log(p[ilow + j - 1] + "  ");
                }
                Log.log("\n");
            }
            ihigh = (ilow += 5) + remain - 1;
            Log.log(ilow + "--" + ihigh + "     ");
            for (j = 1; j <= remain; ++j) {
                Log.log(p[ilow + j - 1] + "  ");
            }
            Log.log("\n");
        }
        Log.log("\n\nRESULT      Current x\n\n");
        ilow = -4;
        ihigh = 0;
        for (i = 1; i <= num5; ++i) {
            Log.log((ilow += 5) + "--" + (ihigh += 5) + "     ");
            for (j = 1; j <= 5; ++j) {
                Log.log(x[ilow + j - 1] + "  ");
            }
            Log.log("\n");
        }
        ihigh = (ilow += 5) + remain - 1;
        Log.log(ilow + "--" + ihigh + "     ");
        for (j = 1; j <= remain; ++j) {
            Log.log(x[ilow + j - 1] + "  ");
        }
        Log.log("\n");
        Log.log("\n\nRESULT      f_to_minimize at x = " + f[1] + "\n");
        Log.log("\n\nRESULT      Gradient at x\n\n");
        ilow = -4;
        ihigh = 0;
        for (i = 1; i <= num5; ++i) {
            Log.log((ilow += 5) + "--" + (ihigh += 5) + "     ");
            for (j = 1; j <= 5; ++j) {
                Log.log(g[ilow + j - 1] + "  ");
            }
            Log.log("\n");
        }
        ihigh = (ilow += 5) + remain - 1;
        Log.log(ilow + "--" + ihigh + "     ");
        for (j = 1; j <= remain; ++j) {
            Log.log(g[ilow + j - 1] + "  ");
        }
        Log.log("\n");
        if (iflg != 0) {
            Log.log("\n\nRESULT      Hessian at x\n\n");
            for (int iii = 1; iii <= n; ++iii) {
                int iii5 = iii / 5;
                int iiir = iii % 5;
                ilow = -4;
                ihigh = 0;
                for (i = 1; i <= iii5; ++i) {
                    Log.log("i = " + iii + ", j = ");
                    Log.log((ilow += 5) + "--" + (ihigh += 5) + "     ");
                    for (j = 1; j <= 5; ++j) {
                        Log.log(a[iii][ilow + j - 1] + "  ");
                    }
                    Log.log("\n");
                }
                ihigh = (ilow += 5) + iiir - 1;
                Log.log("i = " + iii + ", j = ");
                Log.log(ilow + "--" + ihigh + "     ");
                for (j = 1; j <= iiir; ++j) {
                    Log.log(a[iii][ilow + j - 1] + "  ");
                }
                Log.log("\n");
            }
        }
    }

    public static void sclmul_f77(int n, double s, double[] v, double[] z) {
        for (int i = 1; i <= n; ++i) {
            z[i] = s * v[i];
        }
    }

    public static void secfac_f77(int n, double[] x, double[] g, double[][] a, double[] xpls, double[] gpls, double epsm, int[] itncnt, double rnf, int[] iagflg, boolean[] noupdt, double[] s, double[] y, double[] u, double[] w) {
        int i;
        if (itncnt[1] == 1) {
            noupdt[1] = true;
        }
        for (i = 1; i <= n; ++i) {
            s[i] = xpls[i] - x[i];
            y[i] = gpls[i] - g[i];
        }
        double den1 = Blas_f77.ddot_f77(n, s, 1, y, 1);
        double snorm2 = Blas_f77.dnrm2_f77(n, s, 1);
        double ynrm2 = Blas_f77.dnrm2_f77(n, y, 1);
        if (den1 >= Math.sqrt(epsm) * snorm2 * ynrm2) {
            int j;
            Uncmin_f77.mvmltu_f77(n, a, s, u);
            double den2 = Blas_f77.ddot_f77(n, u, 1, u, 1);
            double alp = Math.sqrt(den1 / den2);
            if (noupdt[1]) {
                for (j = 1; j <= n; ++j) {
                    int n2 = j;
                    u[n2] = u[n2] * alp;
                    for (i = j; i <= n; ++i) {
                        double[] dArray = a[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] * alp;
                    }
                }
                noupdt[1] = false;
                den2 = den1;
                alp = 1.0;
            }
            boolean skpupd = true;
            Uncmin_f77.mvmltl_f77(n, a, u, w);
            i = 1;
            double reltol = iagflg[1] == 0 ? Math.sqrt(rnf) : rnf;
            while (i <= n && skpupd) {
                if (Math.abs(y[i] - w[i]) >= reltol * Math.max(Math.abs(g[i]), Math.abs(gpls[i]))) {
                    skpupd = false;
                    continue;
                }
                ++i;
            }
            if (!skpupd) {
                int im1;
                for (i = 1; i <= n; ++i) {
                    w[i] = y[i] - alp * w[i];
                }
                alp /= den1;
                i = 1;
                while (i <= n) {
                    int n4 = i++;
                    u[n4] = u[n4] * alp;
                }
                for (i = 2; i <= n; ++i) {
                    im1 = i - 1;
                    for (j = 1; j <= im1; ++j) {
                        a[j][i] = a[i][j];
                        a[i][j] = 0.0;
                    }
                }
                Uncmin_f77.qrupdt_f77(n, a, u, w);
                for (i = 2; i <= n; ++i) {
                    im1 = i - 1;
                    for (j = 1; j <= im1; ++j) {
                        a[i][j] = a[j][i];
                    }
                }
            }
        }
    }

    public static void secunf_f77(int n, double[] x, double[] g, double[][] a, double[] udiag, double[] xpls, double[] gpls, double epsm, int[] itncnt, double rnf, int[] iagflg, boolean[] noupdt, double[] s, double[] y, double[] t) {
        int i;
        int j;
        for (j = 1; j <= n; ++j) {
            a[j][j] = udiag[j];
            for (i = j + 1; i <= n; ++i) {
                a[i][j] = a[j][i];
            }
        }
        if (itncnt[1] == 1) {
            noupdt[1] = true;
        }
        for (i = 1; i <= n; ++i) {
            s[i] = xpls[i] - x[i];
            y[i] = gpls[i] - g[i];
        }
        double den1 = Blas_f77.ddot_f77(n, s, 1, y, 1);
        double snorm2 = Blas_f77.dnrm2_f77(n, s, 1);
        double ynrm2 = Blas_f77.dnrm2_f77(n, y, 1);
        if (den1 >= Math.sqrt(epsm) * snorm2 * ynrm2) {
            Uncmin_f77.mvmlts_f77(n, a, s, t);
            double den2 = Blas_f77.ddot_f77(n, s, 1, t, 1);
            if (noupdt[1]) {
                double gam = den1 / den2;
                den2 = gam * den2;
                for (j = 1; j <= n; ++j) {
                    int n2 = j;
                    t[n2] = t[n2] * gam;
                    for (i = j; i <= n; ++i) {
                        double[] dArray = a[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] * gam;
                    }
                }
                noupdt[1] = false;
            }
            boolean skpupd = true;
            for (i = 1; i <= n; ++i) {
                double tol = rnf * Math.max(Math.abs(g[i]), Math.abs(gpls[i]));
                if (iagflg[1] == 0) {
                    tol /= Math.sqrt(rnf);
                }
                if (!(Math.abs(y[i] - t[i]) >= tol)) continue;
                skpupd = false;
                break;
            }
            if (!skpupd) {
                for (j = 1; j <= n; ++j) {
                    for (i = j; i <= n; ++i) {
                        double[] dArray = a[i];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + (y[i] * y[j] / den1 - t[i] * t[j] / den2);
                    }
                }
            }
        }
    }

    public static void sndofd_f77(int n, double[] xpls, Uncmin_methods minclass, double[] fpls, double[][] a, double[] sx, double rnoise, double[] stepsz, double[] anbr) {
        double xtmpi;
        int i;
        double xmult = Math.pow(rnoise, 0.3333333333333333);
        for (i = 1; i <= n; ++i) {
            stepsz[i] = xmult * Math.max(Math.abs(xpls[i]), 1.0 / sx[i]);
            xtmpi = xpls[i];
            xpls[i] = xtmpi + stepsz[i];
            anbr[i] = minclass.f_to_minimize(xpls);
            xpls[i] = xtmpi;
        }
        for (i = 1; i <= n; ++i) {
            xtmpi = xpls[i];
            xpls[i] = xtmpi + 2.0 * stepsz[i];
            double fhat = minclass.f_to_minimize(xpls);
            a[i][i] = (fpls[1] - anbr[i] + (fhat - anbr[i])) / (stepsz[i] * stepsz[i]);
            if (i != n) {
                xpls[i] = xtmpi + stepsz[i];
                for (int j = i + 1; j <= n; ++j) {
                    double xtmpj = xpls[j];
                    xpls[j] = xtmpj + stepsz[j];
                    fhat = minclass.f_to_minimize(xpls);
                    a[j][i] = (fpls[1] - anbr[i] + (fhat - anbr[j])) / (stepsz[i] * stepsz[j]);
                    xpls[j] = xtmpj;
                }
            }
            xpls[i] = xtmpi;
        }
    }

    public static void tregup_f77(int n, double[] x, double[] f, double[] g, double[][] a, Uncmin_methods minclass, double[] sc, double[] sx, boolean[] nwtake, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, double[] xplsp, double[] fplsp, double[] xpls, double[] fpls, boolean[] mxtake, int method, double[] udiag) {
        int i;
        mxtake[1] = false;
        for (i = 1; i <= n; ++i) {
            xpls[i] = x[i] + sc[i];
        }
        fpls[1] = minclass.f_to_minimize(xpls);
        double dltf = fpls[1] - f[1];
        double slp = Blas_f77.ddot_f77(n, g, 1, sc, 1);
        if (iretcd[1] == 4) {
            fplsp[1] = 0.0;
        }
        if (iretcd[1] == 3 && (fpls[1] >= fplsp[1] || dltf > 1.0E-4 * slp)) {
            iretcd[1] = 0;
            for (i = 1; i <= n; ++i) {
                xpls[i] = xplsp[i];
            }
            fpls[1] = fplsp[1];
            dlt[1] = dlt[1] * 0.5;
        } else if (dltf > 1.0E-4 * slp) {
            double rln = 0.0;
            for (i = 1; i <= n; ++i) {
                rln = Math.max(rln, Math.abs(sc[i]) / Math.max(Math.abs(xpls[i]), 1.0 / sx[i]));
            }
            if (rln < steptl[1]) {
                iretcd[1] = 1;
            } else {
                iretcd[1] = 2;
                double dltmp = -slp * dlt[1] / (2.0 * (dltf - slp));
                dlt[1] = dltmp < 0.1 * dlt[1] ? dlt[1] * 0.1 : dltmp;
            }
        } else {
            int j;
            double temp;
            double dltfp = 0.0;
            if (method == 2) {
                for (i = 1; i <= n; ++i) {
                    temp = 0.0;
                    for (j = i; j <= n; ++j) {
                        temp += a[j][i] * sc[j];
                    }
                    dltfp += temp * temp;
                }
            } else {
                for (i = 1; i <= n; ++i) {
                    dltfp += udiag[i] * sc[i] * sc[i];
                    temp = 0.0;
                    for (j = i + 1; j <= n; ++j) {
                        temp += a[i][j] * sc[i] * sc[j];
                    }
                    dltfp += 2.0 * temp;
                }
            }
            dltfp = slp + dltfp / 2.0;
            if (iretcd[1] != 2 && Math.abs(dltfp - dltf) <= 0.1 * Math.abs(dltf) && !nwtake[1] && dlt[1] <= 0.99 * stepmx[1]) {
                iretcd[1] = 3;
                for (i = 1; i <= n; ++i) {
                    xplsp[i] = xpls[i];
                }
                fplsp[1] = fpls[1];
                dlt[1] = Math.min(2.0 * dlt[1], stepmx[1]);
            } else {
                iretcd[1] = 0;
                if (dlt[1] > 0.99 * stepmx[1]) {
                    mxtake[1] = true;
                }
                if (dltf >= 0.1 * dltfp) {
                    dlt[1] = dlt[1] * 0.5;
                } else if (dltf <= 0.75 * dltfp) {
                    dlt[1] = Math.min(2.0 * dlt[1], stepmx[1]);
                }
            }
        }
    }
}

