/*
 * Decompiled with CFR 0.152.
 */
package joptima;

import joptima.Minimizable;
import joptima.OptimizationException;
import joptima.Parameter;
import joptima.fortran.Uncmin_f77;
import joptima.fortran.Uncmin_methods;

public class Minimizer
implements Uncmin_methods {
    private int dimension;
    private Parameter[] parameters;
    private Minimizable function;

    public Minimizer(Minimizable function) {
        this.function = function;
        this.parameters = function.getParameters();
        this.dimension = this.parameters.length;
    }

    public void minimize() throws OptimizationException {
        double[] x0 = new double[this.dimension + 1];
        int[] info = new int[2];
        double[] x = new double[this.dimension + 1];
        double[] f = new double[2];
        double[] g = new double[this.dimension + 1];
        double[][] a = new double[this.dimension + 1][this.dimension + 1];
        double[] udiag = new double[this.dimension + 1];
        double[] typsiz = new double[this.dimension + 1];
        double[] fscale = new double[2];
        int[] method = new int[2];
        int[] iexp = new int[2];
        int[] msg = new int[2];
        int[] ndigit = new int[2];
        int[] itnlim = new int[2];
        int[] iagflg = new int[2];
        int[] iahflg = new int[2];
        double[] dlt = new double[2];
        double[] gradtl = new double[2];
        double[] stepmx = new double[2];
        double[] steptl = new double[2];
        Uncmin_f77.dfault_f77(this.dimension, x0, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl);
        try {
            for (int i = 0; i < this.dimension; ++i) {
                x0[i + 1] = this.parameters[i].get();
            }
            Uncmin_f77.optif9_f77(this.dimension, x0, this, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, x, f, g, info, a, udiag);
        }
        catch (IllegalAccessException iae) {
            throw new OptimizationException(iae);
        }
    }

    @Override
    public double f_to_minimize(double[] x) {
        try {
            for (int i = 0; i < this.dimension; ++i) {
                this.parameters[i].set(x[i + 1]);
            }
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return this.function.calculate();
    }

    @Override
    public void gradient(double[] x, double[] g) {
    }

    @Override
    public void hessian(double[] x, double[][] h) {
    }
}

