/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.rsl.jpop;

import edu.stanford.rsl.jpop.FunctionController;
import edu.stanford.rsl.jpop.GradientOptimizableFunction;
import edu.stanford.rsl.jpop.HessianOptimizableFunction;
import edu.stanford.rsl.jpop.OptimizableFunction;

public class SimpleFunctionController
extends FunctionController {
    @Override
    public double evaluate(OptimizableFunction function, double[] x) {
        int threads = function.getNumberOfProcessingBlocks();
        double[] results = new double[threads];
        for (int i = 0; i < threads; ++i) {
            results[i] = function.evaluate(x, i);
        }
        return this.assembler.assembleEvaluationBlocks(results);
    }

    @Override
    public double[] gradient(GradientOptimizableFunction function, double[] x) {
        int threads = function.getNumberOfProcessingBlocks();
        double[][] results = new double[threads][];
        for (int i = 0; i < threads; ++i) {
            results[i] = function.gradient(x, i);
        }
        return this.assembler.assembleGradientBlocks(results);
    }

    @Override
    public double[][] hessian(HessianOptimizableFunction function, double[] x) {
        int threads = function.getNumberOfProcessingBlocks();
        double[][][] results = new double[threads][][];
        for (int i = 0; i < threads; ++i) {
            results[i] = function.hessian(x, i);
        }
        return this.assembler.assembleHessianBlocks(results);
    }
}

