/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.util.CholeskyFactorization;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;

public class Utils {
    private static Double RELATIVE_MACHINE_PRECISION = Double.NaN;
    private static Log log = LogFactory.getLog(Utils.class);

    public static DoubleMatrix2D randomValuesMatrix(int rows, int cols, double min, double max) {
        return Utils.randomValuesMatrix(rows, cols, min, max, null);
    }

    public static DoubleMatrix2D randomValuesMatrix(int rows, int cols, double min, double max, Long seed) {
        Random random = seed != null ? new Random(seed) : new Random();
        double[][] matrix = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matrix[i][j] = min + random.nextDouble() * (max - min);
            }
        }
        return DoubleFactory2D.dense.make(matrix);
    }

    public static DoubleMatrix2D randomValuesPositiveMatrix(int rows, int cols, double min, double max, Long seed) {
        DoubleMatrix2D Q = Utils.randomValuesMatrix(rows, cols, min, max, seed);
        DoubleMatrix2D P = Algebra.DEFAULT.mult(Q, Algebra.DEFAULT.transpose(Q.copy()));
        return Algebra.DEFAULT.mult(P, P);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final double getDoubleMachineEpsilon() {
        if (!Double.isNaN(RELATIVE_MACHINE_PRECISION)) {
            return RELATIVE_MACHINE_PRECISION;
        }
        Double d = RELATIVE_MACHINE_PRECISION;
        synchronized (d) {
            if (!Double.isNaN(RELATIVE_MACHINE_PRECISION)) {
                return RELATIVE_MACHINE_PRECISION;
            }
            double eps = 1.0;
            while (1.0 + (eps /= 2.0) / 2.0 != 1.0) {
            }
            log.debug((Object)("Calculated double machine epsilon: " + eps));
            RELATIVE_MACHINE_PRECISION = eps;
        }
        return RELATIVE_MACHINE_PRECISION;
    }

    public static RealMatrix squareMatrixInverse(RealMatrix M) throws SingularMatrixException {
        if (!M.isSquare()) {
            throw new IllegalArgumentException("Not square matrix!");
        }
        try {
            CholeskyDecomposition cd = new CholeskyDecomposition(M);
            return cd.getSolver().getInverse();
        }
        catch (SingularMatrixException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            try {
                CholeskyFactorization cd = new CholeskyFactorization(M.getData());
                double[][] MInv = cd.getInverse();
                return MatrixUtils.createRealMatrix((double[][])MInv);
            }
            catch (Exception e2) {
                log.debug((Object)e2.getMessage());
                try {
                    LUDecomposition ld = new LUDecomposition(M);
                    return ld.getSolver().getInverse();
                }
                catch (SingularMatrixException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    log.debug((Object)e4.getMessage());
                    try {
                        QRDecomposition qr = new QRDecomposition(M);
                        return qr.getSolver().getInverse();
                    }
                    catch (SingularMatrixException e5) {
                        throw e5;
                    }
                    catch (Exception e6) {
                        log.debug((Object)e6.getMessage());
                        return null;
                    }
                }
            }
        }
    }

    public static int getMaxIndex(double[] v) {
        int maxIndex = -1;
        double maxValue = -1.7976931348623157E308;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] > maxValue)) continue;
            maxIndex = i;
            maxValue = v[i];
        }
        return maxIndex;
    }

    public static int getMinIndex(double[] v) {
        int minIndex = -1;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] < minValue)) continue;
            minIndex = i;
            minValue = v[i];
        }
        return minIndex;
    }

    public static final double[][] createConstantDiagonalMatrix(int dim, double c) {
        double[][] matrix = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            matrix[i][i] = c;
        }
        return matrix;
    }

    public static final double[][] upperTriangularMatrixUnverse(double[][] L) throws Exception {
        int dim = L.length;
        double[][] x = Utils.createConstantDiagonalMatrix(dim, 1.0);
        for (int j = 0; j < dim; ++j) {
            double[] LJ = L[j];
            double LJJ = LJ[j];
            double[] xJ = x[j];
            int k = 0;
            while (k < dim) {
                int n = k++;
                xJ[n] = xJ[n] / LJJ;
            }
            for (int i = j + 1; i < dim; ++i) {
                double[] xI = x[i];
                double LJI = LJ[i];
                for (int k2 = 0; k2 < dim; ++k2) {
                    int n = k2;
                    xI[n] = xI[n] - xJ[k2] * LJI;
                }
            }
        }
        return new Array2DRowRealMatrix(x).transpose().getData();
    }

    public static final double[][] lowerTriangularMatrixUnverse(double[][] L) throws Exception {
        double[][] LT = new Array2DRowRealMatrix(L).transpose().getData();
        double[][] x = Utils.upperTriangularMatrixUnverse(LT);
        return new Array2DRowRealMatrix(x).transpose().getData();
    }

    public static final double calculateDeterminant(double[][] ai, int dim) {
        double det = 0.0;
        if (dim == 1) {
            det = ai[0][0];
        } else if (dim == 2) {
            det = ai[0][0] * ai[1][1] - ai[0][1] * ai[1][0];
        } else {
            double[][] ai1 = new double[dim - 1][dim - 1];
            for (int k = 0; k < dim; ++k) {
                for (int i1 = 1; i1 < dim; ++i1) {
                    int j = 0;
                    for (int j1 = 0; j1 < dim; ++j1) {
                        if (j1 == k) continue;
                        ai1[i1 - 1][j] = ai[i1][j1];
                        ++j;
                    }
                }
                if (k % 2 == 0) {
                    det += ai[0][k] * Utils.calculateDeterminant(ai1, dim - 1);
                    continue;
                }
                det -= ai[0][k] * Utils.calculateDeterminant(ai1, dim - 1);
            }
        }
        return det;
    }
}

