/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import com.joptimizer.solvers.BasicKKTSolver;
import com.joptimizer.solvers.KKTSolver;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KKTSolverTest
extends TestCase {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Property P = Property.TWELVE;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testSolveSimple() throws Exception {
        int i;
        this.log.debug((Object)"testSolveSimple");
        double[][] HMatrix = new double[][]{{3.0}};
        double[][] AMatrix = new double[][]{{2.0}};
        DoubleMatrix2D H = this.F2.make(HMatrix);
        DoubleMatrix2D A = this.F2.make(AMatrix);
        DoubleMatrix2D AT = this.ALG.transpose(A.copy());
        DoubleMatrix1D g = this.F1.make(1, -3.0);
        DoubleMatrix1D h = this.F1.make(1, 0.0);
        BasicKKTSolver solver = new BasicKKTSolver();
        solver.setHMatrix(H.toArray());
        solver.setAMatrix(A.toArray());
        solver.setATMatrix(AT.toArray());
        solver.setGVector(g.toArray());
        solver.setHVector(h.toArray());
        double[][] sol = ((KKTSolver)solver).solve();
        DoubleMatrix1D v = this.F1.make(sol[0]);
        DoubleMatrix1D w = this.F1.make(sol[1]);
        this.log.debug((Object)("v: " + v));
        this.log.debug((Object)("w: " + w));
        DoubleMatrix1D a = this.ALG.mult(H, v).assign(this.ALG.mult(AT, w), Functions.plus).assign(g, Functions.plus);
        DoubleMatrix1D b = this.ALG.mult(A, v).assign(h, Functions.plus);
        this.log.debug((Object)("a: " + a));
        this.log.debug((Object)("b: " + b));
        for (i = 0; i < a.size(); ++i) {
            KKTSolverTest.assertEquals((double)0.0, (double)a.get(i), (double)1.0E-12);
        }
        for (i = 0; i < b.size(); ++i) {
            KKTSolverTest.assertEquals((double)0.0, (double)b.get(i), (double)1.0E-12);
        }
    }

    public void testSolve2() throws Exception {
        int i;
        this.log.debug((Object)"testSolve2");
        double[][] HMatrix = new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}};
        double[][] AMatrix = new double[][]{{1.0, 2.0, 3.0}};
        DoubleMatrix2D H = this.F2.make(HMatrix);
        DoubleMatrix2D A = this.F2.make(AMatrix);
        DoubleMatrix2D AT = this.ALG.transpose(A.copy());
        DoubleMatrix1D g = this.F1.make(new double[]{2.0, 5.0, 1.0});
        DoubleMatrix1D h = this.F1.make(new double[]{1.0});
        BasicKKTSolver solver = new BasicKKTSolver();
        solver.setHMatrix(H.toArray());
        solver.setAMatrix(A.toArray());
        solver.setATMatrix(AT.toArray());
        solver.setGVector(g.toArray());
        solver.setHVector(h.toArray());
        double[][] sol = ((KKTSolver)solver).solve();
        DoubleMatrix1D v = this.F1.make(sol[0]);
        DoubleMatrix1D w = this.F1.make(sol[1]);
        this.log.debug((Object)("v: " + v));
        this.log.debug((Object)("w: " + w));
        DoubleMatrix1D a = this.ALG.mult(H, v).assign(this.ALG.mult(AT, w), Functions.plus).assign(g, Functions.plus);
        DoubleMatrix1D b = this.ALG.mult(A, v).assign(h, Functions.plus);
        this.log.debug((Object)("a: " + a));
        this.log.debug((Object)("b: " + b));
        for (i = 0; i < a.size(); ++i) {
            KKTSolverTest.assertEquals((double)0.0, (double)a.get(i), (double)1.0E-12);
        }
        for (i = 0; i < b.size(); ++i) {
            KKTSolverTest.assertEquals((double)0.0, (double)b.get(i), (double)1.0E-12);
        }
    }
}

