/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

public class BasicKKTSolver
extends KKTSolver {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public double[][] solve() throws Exception {
        RealMatrix HInv;
        RealVector v = null;
        ArrayRealVector w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)this.H.getData())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
        }
        try {
            HInv = Utils.squareMatrixInverse(this.H);
        }
        catch (SingularMatrixException e) {
            HInv = null;
        }
        if (HInv != null) {
            if (this.A != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("A: " + ArrayUtils.toString((Object)this.A.getData())));
                    if (this.h != null) {
                        this.log.debug((Object)("h: " + ArrayUtils.toString((Object)this.h.toArray())));
                    }
                }
                RealMatrix AHInv = this.A.multiply(HInv);
                RealMatrix MenoS = AHInv.multiply(this.AT);
                RealMatrix MenoSInv = Utils.squareMatrixInverse(MenoS);
                w = this.h == null || Double.compare(this.h.getNorm(), 0.0) == 0 ? MenoSInv.operate(AHInv.operate(this.g)).mapMultiply(-1.0) : MenoSInv.operate(this.h.subtract(AHInv.operate(this.g)));
                v = HInv.operate(this.g.add(this.AT.operate((RealVector)w)).mapMultiply(-1.0));
            } else {
                w = null;
                v = HInv.operate(this.g).mapMultiply(-1.0);
            }
        } else if (this.A != null) {
            BasicKKTSolver kktSolver = new BasicKKTSolver();
            kktSolver.setCheckKKTSolutionAccuracy(false);
            double[][] fullSol = this.solveFullKKT(new BasicKKTSolver());
            v = new ArrayRealVector(fullSol[0]);
            w = new ArrayRealVector(fullSol[1]);
        } else {
            throw new Exception("KKT solution failed");
        }
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy(v, (RealVector)w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        double[][] ret = new double[][]{v.toArray(), w != null ? w.toArray() : null};
        return ret;
    }
}

