/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.util.Utils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public abstract class OptimizationRequestHandler {
    protected OptimizationRequestHandler successor = null;
    private OptimizationRequest request;
    private OptimizationResponse response;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private int dim = -1;
    private DoubleMatrix2D AT = null;

    public void setOptimizationRequest(OptimizationRequest request) {
        this.request = request;
    }

    protected OptimizationRequest getOptimizationRequest() {
        return this.request;
    }

    protected void setOptimizationResponse(OptimizationResponse response) {
        this.response = response;
    }

    public OptimizationResponse getOptimizationResponse() {
        return this.response;
    }

    public int optimize() throws Exception {
        return this.forwardOptimizationRequest();
    }

    protected int forwardOptimizationRequest() throws Exception {
        if (this.successor != null) {
            this.successor.setOptimizationRequest(this.request);
            int retCode = this.successor.optimize();
            this.response = this.successor.getOptimizationResponse();
            return retCode;
        }
        throw new Exception("Failed to solve the problem");
    }

    protected final int getDim() {
        if (this.dim < 0) {
            this.dim = this.request.getF0().getDim();
        }
        return this.dim;
    }

    protected final DoubleMatrix1D getInitialPoint() {
        return this.request.getInitialPoint();
    }

    protected final DoubleMatrix1D getNotFeasibleInitialPoint() {
        return this.request.getNotFeasibleInitialPoint();
    }

    protected final DoubleMatrix1D getInitialLagrangian() {
        return this.request.getInitialLagrangian();
    }

    protected final DoubleMatrix2D getA() {
        return this.request.getA();
    }

    protected final DoubleMatrix2D getAT() {
        if (this.AT == null && this.getA() != null) {
            this.AT = this.ALG.transpose(this.getA().copy());
        }
        return this.AT;
    }

    protected final DoubleMatrix1D getB() {
        return this.request.getB();
    }

    protected final int getMaxIteration() {
        return this.request.getMaxIteration();
    }

    protected final double getTolerance() {
        return this.request.getTolerance();
    }

    protected final double getToleranceFeas() {
        return this.request.getToleranceFeas();
    }

    protected final double getToleranceInnerStep() {
        return this.request.getToleranceInnerStep();
    }

    protected final double getAlpha() {
        return this.request.getAlpha();
    }

    protected final double getBeta() {
        return this.request.getBeta();
    }

    protected final double getMu() {
        return this.request.getMu();
    }

    protected final boolean isCheckProgressConditions() {
        return this.request.isCheckProgressConditions();
    }

    protected final boolean isCheckKKTSolutionAccuracy() {
        return this.request.isCheckKKTSolutionAccuracy();
    }

    protected final double getToleranceKKT() {
        return this.request.getToleranceKKT();
    }

    protected final ConvexMultivariateRealFunction getF0() {
        return this.request.getF0();
    }

    protected final boolean isInDomainF0(DoubleMatrix1D X) {
        double F0X = this.request.getF0().value(X.toArray());
        return !Double.isInfinite(F0X) && !Double.isNaN(F0X);
    }

    protected final double getF0(DoubleMatrix1D X) {
        return this.request.getF0().value(X.toArray());
    }

    protected final DoubleMatrix1D getGradF0(DoubleMatrix1D X) {
        return this.F1.make(this.request.getF0().gradient(X.toArray()));
    }

    protected final DoubleMatrix2D getHessF0(DoubleMatrix1D X) {
        double[][] hess = this.request.getF0().hessian(X.toArray());
        if (hess == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER) {
            return this.F2.make(X.size(), X.size());
        }
        return this.F2.make(hess);
    }

    protected final ConvexMultivariateRealFunction[] getFi() {
        return this.request.getFi();
    }

    protected final String getInteriorPointMethod() {
        return this.request.getInteriorPointMethod();
    }

    protected DoubleMatrix1D getFi(DoubleMatrix1D X) {
        if (this.request.getFi() == null) {
            return null;
        }
        double[] ret = new double[this.request.getFi().length];
        double[] x = X.toArray();
        for (int i = 0; i < this.request.getFi().length; ++i) {
            ret[i] = this.request.getFi()[i].value(x);
        }
        return this.F1.make(ret);
    }

    protected DoubleMatrix2D getGradFi(DoubleMatrix1D X) {
        DoubleMatrix2D ret = this.F2.make(this.request.getFi().length, X.size());
        double[] x = X.toArray();
        for (int i = 0; i < this.request.getFi().length; ++i) {
            ret.viewRow(i).assign(this.request.getFi()[i].gradient(x));
        }
        return ret;
    }

    protected DoubleMatrix2D[] getHessFi(DoubleMatrix1D X) {
        DoubleMatrix2D[] ret = new DoubleMatrix2D[this.request.getFi().length];
        double[] x = X.toArray();
        for (int i = 0; i < this.request.getFi().length; ++i) {
            double[][] hess = this.request.getFi()[i].hessian(x);
            ret[i] = hess == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER ? FunctionsUtils.ZEROES_MATRIX_PLACEHOLDER : this.F2.make(hess);
        }
        return ret;
    }

    protected boolean checkCustomExitConditions(DoubleMatrix1D Y) {
        return false;
    }

    protected double[] findEqFeasiblePoint(double[][] A, double[] b) throws Exception {
        RealMatrix AT = new Array2DRowRealMatrix(A).transpose();
        int p = A.length;
        SingularValueDecomposition dFact1 = new SingularValueDecomposition(AT);
        int rangoAT = dFact1.getRank();
        if (rangoAT != p) {
            throw new RuntimeException("Equalities matrix A must have full rank");
        }
        QRDecomposition dFact = new QRDecomposition(AT);
        RealMatrix Q1Q2 = dFact.getQ();
        RealMatrix R0 = dFact.getR();
        RealMatrix Q1 = Q1Q2.getSubMatrix(0, AT.getRowDimension() - 1, 0, p - 1);
        RealMatrix R = R0.getSubMatrix(0, p - 1, 0, p - 1);
        double[][] rData = R.copy().getData();
        double[][] rInvData = Utils.upperTriangularMatrixUnverse(rData);
        Array2DRowRealMatrix RInv = new Array2DRowRealMatrix(rInvData);
        double[] w = Q1.operate(RInv.transpose().operate((RealVector)new ArrayRealVector(b))).toArray();
        return w;
    }

    protected DoubleMatrix1D rPri(DoubleMatrix1D X) {
        if (this.getA() == null) {
            return this.F1.make(0);
        }
        return this.getA().zMult(X, this.getB().copy(), 1.0, -1.0, false);
    }
}

