/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.jet.math.Mult;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.functions.SymmPDQuadraticMultivariateRealFunction;
import com.joptimizer.optimizers.NewtonUnconstrained;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.util.Utils;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class NewtonUnconstrainedTest
extends TestCase {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testOptimize() throws Exception {
        this.log.debug((Object)"testOptimize");
        Array2DRowRealMatrix Pmatrix = new Array2DRowRealMatrix((double[][])new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        ArrayRealVector qVector = new ArrayRealVector(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        RealMatrix P = Pmatrix.scalarMultiply(theta);
        RealVector q = qVector.mapMultiply(-1.0);
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.getData(), q.toArray(), 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.04, 0.5, 0.46});
        NewtonUnconstrained opt = new NewtonUnconstrained();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonUnconstrainedTest.fail();
        }
        double[] sol = opt.getOptimizationResponse().getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        RealMatrix QInv = Utils.squareMatrixInverse(P);
        RealVector benchSol = QInv.operate(q).mapMultiply(-1.0);
        this.log.debug((Object)("benchSol   : " + ArrayUtils.toString((Object)benchSol.toArray())));
        this.log.debug((Object)("benchValue : " + objectiveFunction.value(benchSol.toArray())));
        NewtonUnconstrainedTest.assertEquals((double)benchSol.getEntry(0), (double)sol[0], (double)1.0E-14);
        NewtonUnconstrainedTest.assertEquals((double)benchSol.getEntry(1), (double)sol[1], (double)1.0E-14);
        NewtonUnconstrainedTest.assertEquals((double)benchSol.getEntry(2), (double)sol[2], (double)1.0E-14);
    }

    public void testOptimize2() throws Exception {
        this.log.debug((Object)"testOptimize2");
        int dim = 40;
        Long seed = new Long(54321L);
        DoubleMatrix2D mySymmPD = Utils.randomValuesPositiveMatrix(dim, dim, -0.01, 15.5, seed);
        DoubleMatrix1D CVector = Utils.randomValuesMatrix(1, dim, -0.01, 15.5, seed).viewRow(0);
        MySymmFunction objectiveFunction = new MySymmFunction(mySymmPD, CVector);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        NewtonUnconstrained opt = new NewtonUnconstrained();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonUnconstrainedTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        CholeskyDecomposition cFact = new CholeskyDecomposition(mySymmPD);
        DoubleMatrix1D benchSol = cFact.solve(this.F2.make(CVector.copy().assign(Mult.mult(-1.0)).toArray(), CVector.size())).viewColumn(0);
        this.log.debug((Object)("benchSol   : " + ArrayUtils.toString((Object)benchSol.toArray())));
        this.log.debug((Object)("benchValue : " + objectiveFunction.value(benchSol.toArray())));
        for (int i = 0; i < dim; ++i) {
            NewtonUnconstrainedTest.assertEquals((double)benchSol.get(i), (double)sol[i], (double)1.0E-6);
        }
    }

    private class MySymmFunction
    extends SymmPDQuadraticMultivariateRealFunction {
        public MySymmFunction(DoubleMatrix2D P, DoubleMatrix1D q) {
            super(P.toArray(), q.toArray(), 0.0);
        }
    }
}

