/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.optimizers.NewtonLEConstrainedISP;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class NewtonLEConstrainedISPTest
extends TestCase {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testOptimize1() throws Exception {
        this.log.debug((Object)"testOptimize1");
        Array2DRowRealMatrix Pmatrix = new Array2DRowRealMatrix((double[][])new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        ArrayRealVector qVector = new ArrayRealVector(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        RealMatrix P = Pmatrix.scalarMultiply(theta);
        RealVector q = qVector.mapMultiply(-1.0);
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.getData(), q.toArray(), 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.1, 0.1, 0.1});
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        NewtonLEConstrainedISP opt = new NewtonLEConstrainedISP();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonLEConstrainedISPTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        NewtonLEConstrainedISPTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-15);
        NewtonLEConstrainedISPTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-15);
        NewtonLEConstrainedISPTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-15);
    }

    public void testOptimize2() throws Exception {
        this.log.debug((Object)"testOptimize2");
        double[] minimizeF = new double[]{1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}, {1.0, -1.0}};
        double[] equalityBVector = new double[]{4.0, 2.0};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setA(equalityAMatrix);
        or.setB(equalityBVector);
        NewtonLEConstrainedISP opt = new NewtonLEConstrainedISP();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonLEConstrainedISPTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        NewtonLEConstrainedISPTest.assertEquals((double)3.0, (double)sol[0], (double)1.0E-9);
        NewtonLEConstrainedISPTest.assertEquals((double)1.0, (double)sol[1], (double)1.0E-9);
    }

    public void testOptimize3() throws Exception {
        this.log.debug((Object)"testOptimize3");
        double[] minimizeF = new double[]{0.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setA(equalityAMatrix);
        or.setB(equalityBVector);
        NewtonLEConstrainedISP opt = new NewtonLEConstrainedISP();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonLEConstrainedISPTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        NewtonLEConstrainedISPTest.assertEquals((double)4.0, (double)(sol[0] + sol[1]), (double)1.0E-8);
    }
}

