/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.functions.BarrierFunction;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.optimizers.BarrierMethod;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicPhaseIBM {
    private BarrierMethod originalProblem;
    private int originalDim = -1;
    private int dim = -1;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public BasicPhaseIBM(BarrierMethod originalProblem) {
        this.originalProblem = originalProblem;
        this.originalDim = originalProblem.getDim();
        this.dim = originalProblem.getDim() + 1;
    }

    public double[] findFeasibleInitialPoint() throws Exception {
        DoubleMatrix1D originalRPriX0;
        DoubleMatrix1D X0;
        this.log.debug((Object)"findFeasibleInitialPoint");
        OptimizationRequest or = new OptimizationRequest();
        DoubleMatrix1D C = this.F1.make(this.dim);
        C.set(this.dim - 1, 1.0);
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(C.toArray(), 0.0);
        or.setF0(objectiveFunction);
        or.setToleranceFeas(this.originalProblem.getToleranceFeas());
        or.setTolerance(this.originalProblem.getTolerance());
        or.setCheckKKTSolutionAccuracy(this.originalProblem.isCheckKKTSolutionAccuracy());
        DoubleMatrix2D AEorig = this.originalProblem.getA();
        DoubleMatrix1D BEorig = this.originalProblem.getB();
        if (AEorig != null) {
            DoubleMatrix2D zeroCols = this.F2.make(AEorig.rows(), 1);
            DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{AEorig, zeroCols}};
            DoubleMatrix2D AE = this.F2.compose(parts);
            DoubleMatrix1D BE = BEorig.copy();
            or.setA(AE.toArray());
            or.setB(BE.toArray());
        }
        if ((X0 = this.originalProblem.getNotFeasibleInitialPoint()) == null) {
            X0 = AEorig != null ? this.findOneRoot(AEorig.toArray(), BEorig.toArray()) : this.F1.make(this.originalProblem.getDim(), 1.0 / (double)this.originalProblem.getDim());
        }
        if (AEorig != null && Math.sqrt(this.ALG.norm2(originalRPriX0 = AEorig.zMult(X0, BEorig.copy(), 1.0, -1.0, false))) > this.originalProblem.getToleranceFeas()) {
            throw new Exception("The initial point for Basic Phase I Method must be equalities-feasible");
        }
        double s = this.originalProblem.getBarrierFunction().calculatePhase1InitialFeasiblePoint(X0.toArray(), this.originalProblem.getToleranceFeas());
        if (s < 0.0) {
            return X0.toArray();
        }
        DoubleMatrix1D initialPoint = this.F1.make(1, s);
        initialPoint = this.F1.append(X0, initialPoint);
        or.setInitialPoint(initialPoint.toArray());
        BarrierFunction bfPh1 = this.originalProblem.getBarrierFunction().createPhase1BarrierFunction();
        PhaseIBarrierMethod opt = new PhaseIBarrierMethod(bfPh1);
        opt.setOptimizationRequest(or);
        if (opt.optimize() == 2) {
            throw new Exception("Failed to find an initial feasible point");
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] originalSolution = Arrays.copyOf(response.getSolution(), this.originalDim);
        if (Double.isNaN(this.originalProblem.getBarrierFunction().value(originalSolution))) {
            throw new Exception("Infeasible problem");
        }
        return originalSolution;
    }

    private DoubleMatrix1D findOneRoot(double[][] A, double[] b) throws Exception {
        return this.F1.make(this.originalProblem.findEqFeasiblePoint(A, b));
    }

    private class PhaseIBarrierMethod
    extends BarrierMethod {
        public PhaseIBarrierMethod(BarrierFunction barrierFunction) {
            super(barrierFunction);
        }

        @Override
        protected boolean checkCustomExitConditions(DoubleMatrix1D Y) {
            DoubleMatrix1D X = Y.viewPart(0, BasicPhaseIBM.this.dim - 1);
            DoubleMatrix1D originalRPriX = BasicPhaseIBM.this.F1.make(0);
            if (this.getA() != null) {
                originalRPriX = BasicPhaseIBM.this.originalProblem.getA().zMult(X, BasicPhaseIBM.this.originalProblem.getB().copy(), 1.0, -1.0, false);
            }
            boolean b2 = Math.sqrt(BasicPhaseIBM.this.ALG.norm2(originalRPriX)) < BasicPhaseIBM.this.originalProblem.getToleranceFeas();
            boolean b1 = !Double.isNaN(BasicPhaseIBM.this.originalProblem.getBarrierFunction().value(X.toArray())) || Y.get(Y.size() - 1) < 0.0;
            BasicPhaseIBM.this.log.debug((Object)("checkCustomExitConditions: " + (b1 && b2)));
            return b1 && b2;
        }
    }
}

