/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.functions;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;

public class QuadraticMultivariateRealFunction
implements ConvexMultivariateRealFunction {
    protected int dim = -1;
    protected DoubleMatrix2D P = null;
    protected DoubleMatrix1D q = null;
    protected double r = 0.0;
    private Algebra ALG = Algebra.DEFAULT;

    public QuadraticMultivariateRealFunction(double[][] PMatrix, double[] qVector, double r) {
        this.P = PMatrix != null ? DoubleFactory2D.dense.make(PMatrix) : null;
        this.q = qVector != null ? DoubleFactory1D.dense.make(qVector) : null;
        this.r = r;
        if (this.P == null && this.q == null) {
            throw new IllegalArgumentException("Impossible to create the function");
        }
        if (this.P != null && !Property.DEFAULT.isSquare(this.P)) {
            throw new IllegalArgumentException("Not quadratic argument");
        }
        int n = this.dim = this.P != null ? this.P.columns() : this.q.size();
        if (this.dim < 0) {
            throw new IllegalArgumentException("Impossible to create the function");
        }
    }

    @Override
    public final double value(double[] X) {
        DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
        double ret = this.r;
        if (this.P != null) {
            ret += 0.5 * this.ALG.mult(x, this.ALG.mult(this.P, x));
        }
        if (this.q != null) {
            ret += this.ALG.mult(this.q, x);
        }
        return ret;
    }

    @Override
    public final double[] gradient(double[] X) {
        DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
        DoubleMatrix1D ret = null;
        ret = this.P != null ? (this.q != null ? this.P.zMult(x, this.q.copy(), 1.0, 1.0, false) : this.ALG.mult(this.P, x)) : this.q.copy();
        return ret.toArray();
    }

    @Override
    public final double[][] hessian(double[] X) {
        DoubleMatrix2D ret = null;
        if (this.P == null) {
            return FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER;
        }
        ret = this.P.copy();
        return ret.toArray();
    }

    public DoubleMatrix2D getP() {
        return this.P;
    }

    public DoubleMatrix1D getQ() {
        return this.q;
    }

    public double getR() {
        return this.r;
    }

    @Override
    public int getDim() {
        return this.dim;
    }
}

