/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.schema;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.hipo.data.HipoEvent;
import org.jlab.hipo.data.HipoGroup;
import org.jlab.hipo.data.HipoNode;
import org.jlab.hipo.data.HipoNodeType;
import org.jlab.hipo.json.Json;
import org.jlab.hipo.json.JsonArray;
import org.jlab.hipo.json.JsonObject;
import org.jlab.hipo.json.JsonValue;
import org.jlab.hipo.schema.Schema;
import org.jlab.hipo.utils.FileUtils;

public class SchemaFactory {
    private final Boolean overrideMode = false;
    private final Map<String, Schema> schemaStore = new LinkedHashMap<String, Schema>();
    private final Map<Integer, Schema> schemaStoreGroups = new LinkedHashMap<Integer, Schema>();
    private final List<String> schemaFilter = new ArrayList<String>();

    public void addSchema(Schema schema) {
        if (this.schemaStore.containsKey(schema.getName()) && !this.overrideMode.booleanValue()) {
            return;
        }
        this.schemaStore.put(schema.getName(), schema);
        this.schemaStoreGroups.put(schema.getGroup(), schema);
    }

    public boolean hasSchema(String name) {
        return this.schemaStore.containsKey(name);
    }

    public boolean hasSchema(int group) {
        return this.schemaStoreGroups.containsKey(group);
    }

    public Schema getSchema(String name) {
        return this.schemaStore.get(name);
    }

    public List<Schema> getSchemaList() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Map.Entry<String, Schema> entry : this.schemaStore.entrySet()) {
            schemas.add(entry.getValue());
        }
        return schemas;
    }

    public Schema getSchema(int group) {
        return this.schemaStoreGroups.get(group);
    }

    public SchemaFactory copy() {
        SchemaFactory factory = new SchemaFactory();
        for (Map.Entry<String, Schema> entry : this.schemaStore.entrySet()) {
            factory.addSchema(entry.getValue());
        }
        return factory;
    }

    public void copy(SchemaFactory factory) {
        this.schemaStore.clear();
        this.schemaStoreGroups.clear();
        for (Map.Entry<Integer, Schema> entry : factory.schemaStoreGroups.entrySet()) {
            this.addSchema(entry.getValue());
        }
    }

    public void copy(SchemaFactory factory, String ... descriptors) {
        this.schemaStore.clear();
        this.schemaStoreGroups.clear();
        for (String item : descriptors) {
            if (!this.schemaStore.containsKey(item)) continue;
            this.addSchema(this.schemaStore.get(item));
        }
    }

    public void copy(SchemaFactory factory, List<String> descriptors) {
        this.schemaStore.clear();
        this.schemaStoreGroups.clear();
        for (String item : descriptors) {
            if (!this.schemaStore.containsKey(item)) continue;
            this.addSchema(this.schemaStore.get(item));
        }
    }

    public void show() {
        for (Map.Entry<Integer, Schema> entry : this.schemaStoreGroups.entrySet()) {
            System.out.println(entry.getValue().toString());
        }
    }

    public void setFromEvent(HipoEvent event) {
        Map<Integer, HipoNode> schemaGroup = event.getGroup(32111);
        this.schemaStore.clear();
        this.schemaStoreGroups.clear();
        for (Map.Entry<Integer, HipoNode> items : schemaGroup.entrySet()) {
            Schema schema = new Schema(items.getValue().getString());
            this.addSchema(schema);
        }
    }

    public HipoEvent getSchemaEvent() {
        HipoEvent event = new HipoEvent();
        ArrayList<HipoNode> nodes = new ArrayList<HipoNode>();
        int counter = 1;
        for (Map.Entry<Integer, Schema> entry : this.schemaStoreGroups.entrySet()) {
            HipoNode nodeSchema = new HipoNode(32111, counter, entry.getValue().getText());
            nodes.add(nodeSchema);
            if (++counter <= 120) continue;
            break;
        }
        event.addNodes(nodes);
        return event;
    }

    public void addFilter(String name) {
        if (!this.schemaStore.containsKey(name)) {
            System.out.println("[addFilter] error -> can not find schema with name " + name);
        } else {
            this.schemaFilter.add(name);
        }
    }

    public void addFilter(int id) {
        if (!this.schemaStoreGroups.containsKey(id)) {
            System.out.println("[addFilter] error -> can not find schema with id = " + id);
        } else {
            this.schemaFilter.add(this.schemaStoreGroups.get(id).getName());
        }
    }

    public HipoEvent getFilteredEvent(HipoEvent event) {
        HipoEvent filtered = new HipoEvent(this);
        for (String bank : this.schemaFilter) {
            if (!event.hasGroup(bank)) continue;
            HipoGroup group = event.getGroup(bank);
            filtered.addNodes(group.getNodes());
        }
        return filtered;
    }

    public HipoNodeType getNodeType(String desc) {
        if (desc.compareTo("int32") == 0) {
            return HipoNodeType.INT;
        }
        if (desc.compareTo("int8") == 0) {
            return HipoNodeType.BYTE;
        }
        if (desc.compareTo("int16") == 0) {
            return HipoNodeType.SHORT;
        }
        if (desc.compareTo("float") == 0) {
            return HipoNodeType.FLOAT;
        }
        if (desc.compareTo("double") == 0) {
            return HipoNodeType.DOUBLE;
        }
        if (desc.compareTo("int64") == 0) {
            return HipoNodeType.LONG;
        }
        if (desc.compareTo("vector3f") == 0) {
            return HipoNodeType.VECTOR3F;
        }
        return HipoNodeType.UNDEFINED;
    }

    public void initFromDirectory(String directory) {
        this.schemaStore.clear();
        this.schemaStoreGroups.clear();
        List<Schema> dirSchemas = this.readSchemaDirectory(directory);
        for (Schema schema : dirSchemas) {
            this.addSchema(schema);
        }
    }

    public void initFromDirectory(String env, String directory) {
        this.schemaStore.clear();
        this.schemaStoreGroups.clear();
        String fullPath = FileUtils.getEnvironmentPath(env, directory);
        if (fullPath != null) {
            List<Schema> dirSchemas = this.readSchemaDirectory(fullPath);
            for (Schema schema : dirSchemas) {
                this.addSchema(schema);
            }
        }
    }

    public List<Schema> readSchemaDirectory(String directory) {
        List<String> fileList = FileUtils.getFileListInDir(directory, ".json");
        ArrayList<Schema> dirScemas = new ArrayList<Schema>();
        for (String file : fileList) {
            System.out.println("[readSchemaDirectory] processing file -> " + file);
            List<Schema> fileSchemas = this.readSchemaFile(file);
            dirScemas.addAll(fileSchemas);
        }
        return dirScemas;
    }

    public List<Schema> readSchemaFile(String filename) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            FileReader reader = new FileReader(filename);
            JsonArray object = Json.parse(reader).asArray();
            for (JsonValue value : object.values()) {
                JsonObject bankDesc = value.asObject();
                String bankName = bankDesc.get("bank").asString();
                Integer groupId = bankDesc.get("group").asInt();
                JsonArray items = bankDesc.get("items").asArray();
                Schema desc = new Schema(bankName, groupId);
                for (JsonValue item : items.values()) {
                    JsonObject entry = item.asObject();
                    String itemName = entry.get("name").asString();
                    Integer itemId = entry.get("id").asInt();
                    String itemType = entry.get("type").asString();
                    HipoNodeType type = this.getNodeType(itemType);
                    if (type == HipoNodeType.UNDEFINED) {
                        System.out.println(" error parsing type = " + itemType);
                        continue;
                    }
                    desc.addEntry(itemName, (int)itemId, type);
                }
                schemas.add(desc);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SchemaFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SchemaFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return schemas;
    }

    public static void main(String[] args) {
        SchemaFactory factory = new SchemaFactory();
        System.setProperty("CLAS12DIR", "/Users/gavalian/Work/Software/Release-4a.0.0/COATJAVA/coatjava");
        factory.initFromDirectory("CLAS12DIR", "etc/bankdefs/hipo");
        HipoEvent event = new HipoEvent(factory);
        HipoGroup group = factory.getSchema("ECAL::clusters").createGroup(5);
        event.writeGroup(group);
        event.show();
        event.removeGroup("ECAL::clusters");
        event.show();
        event.writeGroup(group);
        event.show();
    }
}

