/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jlab.hipo.data.HipoGroup;
import org.jlab.hipo.data.HipoNode;
import org.jlab.hipo.data.HipoNodeType;
import org.jlab.hipo.utils.ArrayUtils;
import org.jlab.hipo.utils.TextTable;

public class Schema {
    private Integer group = 1;
    private String name = "default";
    private Map<Integer, SchemaEntry> idEntries = new LinkedHashMap<Integer, SchemaEntry>();
    private Map<String, SchemaEntry> nameEntries = new LinkedHashMap<String, SchemaEntry>();

    public Schema() {
    }

    public Schema(String n, int g, String format) {
        this.name = n;
        this.group = g;
        this.parseString(format);
    }

    public Schema(String format) {
        this.setFromText(format);
    }

    public Schema(String n, int grp) {
        this.setName(n);
        this.setGroup(grp);
    }

    public Map<Integer, HipoNode> createNodeMap(int size) {
        HashMap<Integer, HipoNode> map = new HashMap<Integer, HipoNode>();
        for (Map.Entry<Integer, SchemaEntry> entry : this.idEntries.entrySet()) {
            HipoNode node = new HipoNode(this.getGroup(), entry.getValue().getId(), entry.getValue().getType(), size);
            map.put(entry.getValue().getId(), node);
        }
        return map;
    }

    public void addEntry(SchemaEntry entry) {
        this.idEntries.put(entry.getId(), entry);
        this.nameEntries.put(entry.getName(), entry);
    }

    public void addEntry(String n, int id, HipoNodeType type) {
        this.addEntry(new SchemaEntry(n, id, type));
    }

    public void addEntry(String n, int id, String typeString) {
    }

    public int getEntries() {
        return this.idEntries.size();
    }

    public SchemaEntry getEntry(String name) {
        return this.nameEntries.get(name);
    }

    public SchemaEntry getEntry(int id) {
        return this.idEntries.get(id);
    }

    protected Map<Integer, SchemaEntry> schemaEntries() {
        return this.idEntries;
    }

    public List<String> schemaEntryList() {
        ArrayList<String> entryList = new ArrayList<String>();
        for (Map.Entry<String, SchemaEntry> entry : this.nameEntries.entrySet()) {
            entryList.add(entry.getKey());
        }
        return entryList;
    }

    public final void setName(String n) {
        this.name = n;
    }

    public final void setGroup(int grp) {
        this.group = grp;
    }

    public final String getName() {
        return this.name;
    }

    public final int getGroup() {
        return this.group;
    }

    public boolean compatible(Schema schema) {
        for (Map.Entry<Integer, SchemaEntry> entry : this.idEntries.entrySet()) {
            int id = entry.getKey();
            SchemaEntry sche = schema.getEntry(id);
            if (sche == null) {
                return false;
            }
            if (sche.getType() == entry.getValue().getType()) continue;
            return false;
        }
        return true;
    }

    public HipoGroup createGroup(int size) {
        HashMap<Integer, HipoNode> nodes = new HashMap<Integer, HipoNode>();
        for (Map.Entry<Integer, SchemaEntry> entry : this.idEntries.entrySet()) {
            HipoNode node = new HipoNode(this.group, entry.getKey(), entry.getValue().getType(), size);
            nodes.put(entry.getKey(), node);
        }
        HipoGroup hipogroup = new HipoGroup(nodes, this);
        return hipogroup;
    }

    public void copy(Schema schema) {
        this.nameEntries.clear();
        this.idEntries.clear();
        for (Map.Entry<Integer, SchemaEntry> entry : schema.schemaEntries().entrySet()) {
            this.addEntry(entry.getValue().copy());
        }
        this.setName(schema.getName());
    }

    public String toString() {
        TextTable table = new TextTable("name:id:type", "24:8:18");
        for (Map.Entry<Integer, SchemaEntry> entry : this.idEntries.entrySet()) {
            table.addData(new String[]{entry.getValue().getName(), entry.getKey().toString(), entry.getValue().getType().getName()});
        }
        return table.toString();
    }

    public String getText() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("{%d,%s}", this.getGroup(), this.getName()));
        for (Map.Entry<Integer, SchemaEntry> entry : this.idEntries.entrySet()) {
            str.append(String.format("[%d,%s,%s]", entry.getValue().getId(), entry.getValue().getName(), entry.getValue().getType().getName()));
        }
        return str.toString();
    }

    public final void setFromText(String text) {
        this.idEntries.clear();
        this.nameEntries.clear();
        String header = ArrayUtils.getBracketStringCurly(text, 0);
        List<String> headerList = ArrayUtils.getArray(header);
        if (headerList.size() != 2) {
            return;
        }
        this.group = Integer.parseInt(headerList.get(0));
        this.name = headerList.get(1);
        int counter = 0;
        String entryText = ArrayUtils.getBracketString(text, counter);
        while (entryText != null) {
            List<String> items = ArrayUtils.getArray(entryText);
            if (items.size() == 3) {
                this.addEntry(items.get(1), Integer.parseInt(items.get(0)), HipoNodeType.getType(items.get(2)));
            }
            entryText = ArrayUtils.getBracketString(text, ++counter);
        }
    }

    private HipoNodeType getTypeByString(String typeString) {
        if (typeString.length() == 1 && typeString.compareTo("F") == 0) {
            return HipoNodeType.FLOAT;
        }
        if (typeString.length() == 1 && typeString.compareTo("I") == 0) {
            return HipoNodeType.INT;
        }
        if (typeString.length() == 1 && typeString.compareTo("B") == 0) {
            return HipoNodeType.BYTE;
        }
        if (typeString.length() == 1 && typeString.compareTo("L") == 0) {
            return HipoNodeType.LONG;
        }
        if (typeString.length() == 1 && typeString.compareTo("S") == 0) {
            return HipoNodeType.SHORT;
        }
        if (typeString.length() == 1 && typeString.compareTo("D") == 0) {
            return HipoNodeType.DOUBLE;
        }
        return HipoNodeType.UNDEFINED;
    }

    public final void parseString(String format) {
        String[] tokens = format.split(":");
        for (int i = 0; i < tokens.length; ++i) {
            int itemid = i + 1;
            if (tokens[i].contains("/")) {
                String[] items = tokens[i].split("/");
                HipoNodeType type = this.getTypeByString(items[1]);
                if (type == HipoNodeType.UNDEFINED) {
                    System.out.println("[parse] error : unknown type " + items[1] + " for entry " + items[0]);
                    continue;
                }
                this.addEntry(items[0], itemid, type);
                continue;
            }
            this.addEntry(tokens[i], itemid, HipoNodeType.INT);
        }
    }

    public static void main(String[] args) {
        Schema schema = new Schema("DC::dgtz", 300);
        schema.addEntry("sector", 1, HipoNodeType.INT);
        schema.addEntry("layer", 2, HipoNodeType.BYTE);
        schema.addEntry("ADC", 3, HipoNodeType.INT);
        schema.addEntry("TDC", 4, HipoNodeType.INT);
        System.out.println(schema);
        System.out.println(schema.getText());
        Schema newSchema = new Schema();
        newSchema.setFromText(schema.getText());
        System.out.println(newSchema);
        Schema formated = new Schema("Particle", 300, "pid/I:px/F:py/F:pz/F");
        System.out.println(formated);
    }

    public static class SchemaEntry {
        private String name = "x";
        private Integer id = 1;
        private HipoNodeType type = HipoNodeType.UNDEFINED;

        public SchemaEntry() {
        }

        public SchemaEntry(String n, int i, HipoNodeType t) {
            this.name = n;
            this.id = i;
            this.type = t;
        }

        public SchemaEntry copy() {
            return new SchemaEntry(this.name, this.id, this.type);
        }

        public void setName(String n) {
            this.name = n;
        }

        public void setId(Integer i) {
            this.id = i;
        }

        public void setType(HipoNodeType t) {
            this.type = t;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public HipoNodeType getType() {
            return this.type;
        }

        public String toString() {
            return String.format("%4d : %24s %12s", this.id, this.name, this.type.getName());
        }
    }
}

