/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class HipoByteUtils {
    public static final int MTU = 0x100000;
    public static TreeMap<Integer, Integer> bitMap = HipoByteUtils.createBitMap();

    public static TreeMap<Integer, Integer> createBitMap() {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (int loop = 0; loop < 32; ++loop) {
            int integer_value = 0;
            for (int hb = 0; hb < loop; ++hb) {
                integer_value |= 1 << hb;
            }
            map.put(loop, integer_value);
        }
        return map;
    }

    public static void uncompressLZ4(byte[] compressed, byte[] uncompressed) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4SafeDecompressor decompressor = factory.safeDecompressor();
        int cl = decompressor.decompress(compressed, 0, compressed.length, uncompressed, 0);
    }

    public static byte[] compressLZ4(byte[] uncompressed) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(uncompressed.length);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(uncompressed, 0, uncompressed.length, compressed, 0, maxCompressedLength);
        byte[] compressedBytes = new byte[compressedLength];
        System.arraycopy(compressed, 0, compressedBytes, 0, compressedBytes.length);
        return compressedBytes;
    }

    public static byte[] compressLZ4max(byte[] uncompressed) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.highCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(uncompressed.length);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(uncompressed, 0, uncompressed.length, compressed, 0, maxCompressedLength);
        byte[] compressedBytes = new byte[compressedLength];
        System.arraycopy(compressed, 0, compressedBytes, 0, compressedBytes.length);
        return compressedBytes;
    }

    public static byte[] gzip(byte[] ungzipped) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
            gzipOutputStream.write(ungzipped);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("[iG5DataCompressor] ERROR: Could not gzip the array....");
        }
        return bytes.toByteArray();
    }

    public static byte[] ungzip(byte[] gzipped) {
        byte[] ungzipped = new byte[]{};
        int internalBufferSize = 0x100000;
        try {
            GZIPInputStream inputStream = new GZIPInputStream((InputStream)new ByteArrayInputStream(gzipped), 0x100000);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(gzipped.length);
            byte[] buffer = new byte[0x100000];
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = inputStream.read(buffer, 0, 0x100000);
                if (bytesRead == -1) continue;
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            ungzipped = byteArrayOutputStream.toByteArray();
            inputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("[iG5DataCompressor] ERROR: could not uncompress the array. " + e.getMessage());
        }
        return ungzipped;
    }

    public static byte[] generateByteArray(int count) {
        byte[] array = new byte[count];
        int data = 2;
        for (int i = 0; i < count; ++i) {
            array[i] = data;
            if ((data = (int)((byte)(data + 1))) <= 125) continue;
            data = 0;
        }
        return array;
    }

    public static void printBitMap() {
        for (Map.Entry<Integer, Integer> entry : bitMap.entrySet()) {
            System.out.println(String.format("%4d : ", entry.getKey()) + String.format("%32s", Integer.toBinaryString(entry.getValue())).replace(' ', '0'));
        }
    }

    public static int getInteger(int data, int bitstart, int bitend) {
        int length = bitend - bitstart + 1;
        if (bitMap.containsKey(length)) {
            int value = data >> bitstart & bitMap.get(length);
            return value;
        }
        System.out.println("[DataUtilities] : ERROR length = " + length);
        return 0;
    }

    public static short getShortFromByte(byte data) {
        byte short_data = 0;
        return (short)((short_data | data) & 0xFF);
    }

    public static int getIntFromShort(short data) {
        short int_data = 0;
        return (int_data | data) & 0xFFFF;
    }

    public static int getIntFromByte(byte data) {
        byte int_data = 0;
        return (int_data | data) & 0xFFFF;
    }

    public static short getShortFromInt(int data) {
        int int_data = 0;
        return (short)((int_data | data) & 0xFFFF);
    }

    public static byte getByteFromInt(int data) {
        int byte_data = 0;
        return (byte)((byte_data | data) & 0xFF);
    }

    public static byte getByteFromShort(short data) {
        short byte_data = 0;
        return (byte)((byte_data | data) & 0xFF);
    }

    public static String getByteString(int word) {
        String strL = String.format("%32s", Integer.toBinaryString(word)).replace(' ', '0');
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            str.append(strL.charAt(i));
            if ((i + 1) % 8 != 0) continue;
            str.append(" ");
        }
        return str.toString();
    }

    public static int write(int word, int number, int start, int end) {
        int index = end - start + 1;
        int result = word & ~(bitMap.get(index) << start);
        return result |= (number & bitMap.get(index)) << start;
    }

    public static long writeLong(long word, int number, int start, int end) {
        int index = end - start + 1;
        long result = word & (long)(~(bitMap.get(index) << start));
        return result |= (long)((number & bitMap.get(index)) << start);
    }

    public static int read(int word, int start, int end) {
        int index = end - start + 1;
        return word >> start & bitMap.get(index);
    }

    public static int readLong(long word, int start, int end) {
        int index = end - start + 1;
        return (int)(word >> start & (long)bitMap.get(index).intValue());
    }

    public static void main(String[] args) {
        int header = 0xFFFFFF;
        int headerM = HipoByteUtils.write(header, 4, 10, 12);
        int headerR = HipoByteUtils.read(headerM, 10, 12);
        System.out.println(HipoByteUtils.getByteString(header));
        System.out.println(HipoByteUtils.getByteString(headerM));
        System.out.println(HipoByteUtils.getByteString(headerR));
        byte[] buffer = HipoByteUtils.generateByteArray(1845000);
        System.out.println("Length = " + buffer.length);
        byte[] compressed = HipoByteUtils.gzip(buffer);
        System.out.println("compressed length = " + compressed.length);
        long stime_ = System.currentTimeMillis();
        for (int loop = 0; loop < 50000; ++loop) {
            byte[] byArray = HipoByteUtils.ungzip(compressed);
        }
        long etime_ = System.currentTimeMillis();
        double time = (double)(etime_ - stime_) / 1000.0;
        System.out.println("Deflate speed = " + time + " sec");
    }
}

