/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.data;

import java.util.ArrayList;
import java.util.List;
import org.jlab.hipo.data.HipoNode;
import org.jlab.hipo.data.HipoNodeType;

public class HipoNodeBuilder<T extends Number> {
    private final List<T> container = new ArrayList<T>();
    private int containerLimit = -1;

    public HipoNodeBuilder() {
        this.containerLimit = -1;
    }

    public HipoNodeBuilder(int limit) {
        this.containerLimit = limit;
    }

    public void push(T value) {
        if (this.containerLimit < 0) {
            this.container.add(value);
        } else if (this.containerLimit > this.container.size()) {
            this.container.add(value);
        } else {
            System.out.println("[HipoNodeBuilder] warning : container is full, no value added  size = " + this.container.size() + "  limit = " + this.containerLimit);
        }
    }

    public boolean isFull() {
        return this.container.size() >= this.containerLimit;
    }

    public int getSize() {
        return this.container.size();
    }

    public void reset() {
        this.container.clear();
    }

    public HipoNode buildNode(int group, int item) {
        if (this.container.size() > 0) {
            Number value = (Number)this.container.get(0);
            if (value instanceof Long) {
                HipoNode nodeLong = new HipoNode(group, item, HipoNodeType.LONG, this.container.size());
                for (int i = 0; i < this.container.size(); ++i) {
                    Long itemValue = (Long)this.container.get(i);
                    nodeLong.setLong(i, itemValue);
                }
                return nodeLong;
            }
            if (value instanceof Integer) {
                HipoNode nodeInt = new HipoNode(group, item, HipoNodeType.INT, this.container.size());
                for (int i = 0; i < this.container.size(); ++i) {
                    Integer itemValue = (Integer)this.container.get(i);
                    nodeInt.setInt(i, itemValue);
                }
                return nodeInt;
            }
            if (value instanceof Float) {
                HipoNode nodeFloat = new HipoNode(group, item, HipoNodeType.FLOAT, this.container.size());
                for (int i = 0; i < this.container.size(); ++i) {
                    Float itemValue = (Float)this.container.get(i);
                    nodeFloat.setFloat(i, itemValue.floatValue());
                }
                return nodeFloat;
            }
            if (value instanceof Short) {
                HipoNode nodeFloat = new HipoNode(group, item, HipoNodeType.SHORT, this.container.size());
                for (int i = 0; i < this.container.size(); ++i) {
                    Short itemValue = (Short)this.container.get(i);
                    nodeFloat.setShort(i, itemValue);
                }
                return nodeFloat;
            }
            if (value instanceof Double) {
                HipoNode nodeFloat = new HipoNode(group, item, HipoNodeType.DOUBLE, this.container.size());
                for (int i = 0; i < this.container.size(); ++i) {
                    Double itemValue = (Double)this.container.get(i);
                    nodeFloat.setDouble(i, itemValue);
                }
                return nodeFloat;
            }
        }
        return null;
    }
}

