/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jlab.hipo.data.HipoGroup;
import org.jlab.hipo.data.HipoNode;
import org.jlab.hipo.data.HipoNodeType;
import org.jlab.hipo.schema.Schema;
import org.jlab.hipo.schema.SchemaFactory;
import org.jlab.hipo.utils.TextTable;

public class HipoEvent {
    ByteBuffer eventBuffer = null;
    private final Map<Integer, GroupNodeIndexList> groupsIndex = new HashMap<Integer, GroupNodeIndexList>();
    private final SchemaFactory eventSchemaFactory = new SchemaFactory();

    public HipoEvent() {
        byte[] header = new byte[8];
        header[0] = 69;
        header[1] = 86;
        header[2] = 78;
        header[3] = 84;
        this.eventBuffer = ByteBuffer.wrap(header);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public HipoEvent(SchemaFactory factory) {
        byte[] header = new byte[8];
        header[0] = 69;
        header[1] = 86;
        header[2] = 78;
        header[3] = 84;
        this.eventBuffer = ByteBuffer.wrap(header);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.eventSchemaFactory.copy(factory);
        this.updateNodeIndex();
    }

    public HipoEvent(byte[] buffer) {
        this.eventBuffer = ByteBuffer.wrap(buffer);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.updateNodeIndex();
    }

    public HipoEvent(byte[] buffer, SchemaFactory factory) {
        this.eventBuffer = ByteBuffer.wrap(buffer);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.updateNodeIndex();
        this.eventSchemaFactory.copy(factory);
    }

    public void addNode(HipoNode node) {
        int nodeLength = node.getBufferSize();
        int eventLength = this.eventBuffer.capacity();
        byte[] dataBuffer = new byte[nodeLength + eventLength];
        byte[] data = node.getBufferData();
        int position = eventLength;
        System.arraycopy(this.eventBuffer.array(), 0, dataBuffer, 0, eventLength);
        System.arraycopy(data, 0, dataBuffer, position, node.getBufferSize());
        this.eventBuffer = ByteBuffer.wrap(dataBuffer);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void addNodes(List<HipoNode> nodes) {
        int nodesLength = 0;
        for (HipoNode node : nodes) {
            nodesLength += node.getBufferSize();
        }
        int eventLength = this.eventBuffer.capacity();
        byte[] dataBuffer = new byte[nodesLength + eventLength];
        System.arraycopy(this.eventBuffer.array(), 0, dataBuffer, 0, eventLength);
        int position = eventLength;
        for (HipoNode node : nodes) {
            byte[] data = node.getBufferData();
            System.arraycopy(data, 0, dataBuffer, position, node.getBufferSize());
            position += node.getBufferSize();
        }
        this.eventBuffer = ByteBuffer.wrap(dataBuffer);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.updateNodeIndex();
    }

    public final void updateNodeIndex() {
        int position = 8;
        int capacity = this.eventBuffer.capacity();
        this.groupsIndex.clear();
        boolean counter = false;
        while (position + 8 < capacity) {
            short group = this.eventBuffer.getShort(position);
            byte item = this.eventBuffer.get(position + 2);
            byte type = this.eventBuffer.get(position + 3);
            int size = this.eventBuffer.getInt(position + 4);
            NodeIndexList idx = new NodeIndexList(item, position, size);
            idx.setType(type);
            Integer groupInt = group;
            if (!this.groupsIndex.containsKey(groupInt)) {
                this.groupsIndex.put(groupInt, new GroupNodeIndexList(group));
            }
            this.groupsIndex.get(groupInt).addNodeIndex(idx);
            position += 8 + size;
        }
    }

    public void reset() {
        byte[] header = new byte[8];
        header[0] = 69;
        header[1] = 86;
        header[2] = 78;
        header[3] = 84;
        this.eventBuffer = ByteBuffer.wrap(header);
        this.eventBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void writeGroup(HipoGroup group) {
        if (this.hasGroup(group.getSchema().getGroup())) {
            System.out.println("[HipoEvent] warning : groups is not added. The event contains group id = " + group.getSchema().getGroup() + " name = " + group.getSchema().getName());
        } else {
            List<HipoNode> nodes = group.getNodes();
            this.addNodes(nodes);
        }
        this.updateNodeIndex();
    }

    public HipoGroup getGroup(String name) {
        if (this.eventSchemaFactory.hasSchema(name)) {
            Schema schema = this.eventSchemaFactory.getSchema(name);
            Map<Integer, HipoNode> nodes = this.getGroup(schema.getGroup());
            return new HipoGroup(nodes, schema);
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.toGroupListString());
        return str.toString();
    }

    public byte[] getDataBuffer() {
        return this.eventBuffer.array();
    }

    public void show() {
        TextTable table = new TextTable("id:name:entries:group:items", "4:36:12:9:9");
        Integer counter = 0;
        for (Map.Entry<Integer, GroupNodeIndexList> entry : this.groupsIndex.entrySet()) {
            String name = "N/A";
            if (this.eventSchemaFactory.hasSchema(entry.getKey())) {
                name = this.eventSchemaFactory.getSchema(entry.getKey()).getName();
            }
            Integer size = entry.getValue().getItemList().size();
            HipoGroup group = this.getGroup(this.eventSchemaFactory.getSchema(entry.getKey()).getName());
            Integer rows = group.getMaxSize();
            table.addData(new String[]{counter.toString(), name, rows.toString(), entry.getKey().toString(), size.toString()});
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
        System.out.println(table.toString());
    }

    public void showGroupByOrder(int order) {
        Integer counter = 0;
        for (Map.Entry<Integer, GroupNodeIndexList> entry : this.groupsIndex.entrySet()) {
            if (counter == order) {
                int id = entry.getValue().getGroup();
                this.showGroup(id);
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
    }

    public void showGroup(int group) {
        Schema schema = this.getSchemaFactory().getSchema(group);
        this.showGroup(schema.getName());
    }

    public void showGroup(String group) {
        if (this.hasGroup(group)) {
            HipoGroup bank = this.getGroup(group);
            bank.show();
        }
    }

    public HipoNode getNode(int group, int item) {
        GroupNodeIndexList list;
        if (this.groupsIndex.containsKey(group) && (list = this.groupsIndex.get(group)).hasItem(item)) {
            NodeIndexList nL = list.getItemIndex(item);
            int nodeLength = 8 + nL.nodeLength;
            byte[] array = new byte[nodeLength];
            System.arraycopy(this.eventBuffer.array(), nL.nodeOffset, array, 0, nodeLength);
            return new HipoNode(array);
        }
        System.out.println("---> error : requested node (" + group + "," + item + ") is not found.");
        return null;
    }

    public boolean hasGroup(int group) {
        return this.groupsIndex.containsKey(group);
    }

    public boolean hasGroup(String group) {
        if (this.eventSchemaFactory.hasSchema(group)) {
            if (this.eventSchemaFactory.getSchema(group) == null) {
                System.out.println("---> warning : schema for the group = " + group + " is null.");
            } else {
                int groupId = this.eventSchemaFactory.getSchema(group).getGroup();
                return this.groupsIndex.containsKey(groupId);
            }
        }
        return false;
    }

    public SchemaFactory getSchemaFactory() {
        return this.eventSchemaFactory;
    }

    public List<HipoGroup> getGroups() {
        ArrayList<HipoGroup> groups = new ArrayList<HipoGroup>();
        for (Map.Entry<Integer, GroupNodeIndexList> entry : this.groupsIndex.entrySet()) {
            Map<Integer, HipoNode> nodes = this.getGroup(entry.getKey());
            Schema schema = this.getSchemaFactory().getSchema(entry.getKey());
            if (schema != null) {
                groups.add(new HipoGroup(nodes, schema));
                continue;
            }
            groups.add(new HipoGroup(nodes));
        }
        return groups;
    }

    public void removeGroup(int group) {
        if (!this.hasGroup(group)) {
            return;
        }
        List<HipoGroup> groups = this.getGroups();
        this.reset();
        this.groupsIndex.clear();
        for (HipoGroup entry : groups) {
            if (entry.getSchema().getGroup() == group) continue;
            this.writeGroup(entry);
        }
        this.updateNodeIndex();
    }

    public void removeGroup(String name) {
        if (!this.hasGroup(name)) {
            return;
        }
        Schema schema = this.eventSchemaFactory.getSchema(name);
        if (schema != null) {
            this.removeGroup(schema.getGroup());
        }
    }

    public Map<Integer, HipoNode> getGroup(int group) {
        LinkedHashMap<Integer, HipoNode> groupNodes = new LinkedHashMap<Integer, HipoNode>();
        if (this.groupsIndex.containsKey(group)) {
            GroupNodeIndexList list = this.groupsIndex.get(group);
            for (Map.Entry<Integer, NodeIndexList> entry : list.getItemList().entrySet()) {
                int itemID = entry.getValue().nodeItem;
                HipoNode node = this.getNode(group, itemID);
                groupNodes.put(itemID, node);
            }
        }
        return groupNodes;
    }

    public String toGroupListString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Integer, GroupNodeIndexList> entry : this.groupsIndex.entrySet()) {
            str.append(entry.getValue().toString());
        }
        return str.toString();
    }

    public static void main(String[] args) {
        HipoNode node = new HipoNode(1200, 25, HipoNodeType.SHORT, 5);
        for (int i = 0; i < 5; ++i) {
            node.setShort(i, (short)((i + 1) * 2));
        }
        System.out.println(node.getHeaderString() + " : " + node.getDataString());
        HipoNode nodeF = new HipoNode(1200, 2, HipoNodeType.FLOAT, 8);
        for (int i = 0; i < 8; ++i) {
            nodeF.setFloat(i, (float)((double)(i + 1) * 2.0 + 0.5));
        }
        System.out.println(nodeF.getHeaderString() + " : " + nodeF.getDataString());
        ArrayList<HipoNode> nodes = new ArrayList<HipoNode>();
        nodes.add(nodeF);
        nodes.add(node);
        HipoEvent event = new HipoEvent();
        event.addNodes(nodes);
        event.updateNodeIndex();
        System.out.println(event);
        HipoNode nodeFLOAT = event.getNode(1200, 2);
        System.out.println(nodeFLOAT.getHeaderString() + " : " + nodeFLOAT.getDataString());
        HipoNode nodeSHORT = event.getNode(1200, 25);
        System.out.println(nodeSHORT.getHeaderString() + " : " + nodeSHORT.getDataString());
        Map<Integer, HipoNode> group1200 = event.getGroup(1200);
        System.out.println("-----------");
        for (Map.Entry<Integer, HipoNode> entry : group1200.entrySet()) {
            System.out.println(entry.getValue().getHeaderString() + " : " + entry.getValue().getDataString());
        }
    }

    public static class HipoNodeIndex {
        int nodeGroup = 0;
        int nodeItem = 0;
        int nodeOffset = 0;
        int nodeLength = 0;

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(String.format("( %6d, %3d, %8d, %6d)", this.nodeGroup, this.nodeItem, this.nodeOffset, this.nodeLength));
            return str.toString();
        }
    }

    public static class NodeIndexList {
        int nodeItem = 0;
        int nodeOffset = 0;
        int nodeLength = 0;
        int nodeType = 0;

        public NodeIndexList(int item, int offset, int length) {
            this.nodeItem = item;
            this.nodeOffset = offset;
            this.nodeLength = length;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(String.format("ITEM (%4d) TYPE (%2d) LENGTH (%6d)  OFFSET (%6d)", this.nodeItem, this.nodeType, this.nodeLength, this.nodeOffset));
            return str.toString();
        }

        public int getType() {
            return this.nodeType;
        }

        public NodeIndexList setType(int type) {
            this.nodeType = type;
            return this;
        }
    }

    public static class GroupNodeIndexList {
        private int groupid = 0;
        private final Map<Integer, NodeIndexList> nodesIndex = new LinkedHashMap<Integer, NodeIndexList>();

        public GroupNodeIndexList(int gr) {
            this.groupid = gr;
        }

        public int getGroup() {
            return this.groupid;
        }

        public void addNodeIndex(NodeIndexList indx) {
            if (this.nodesIndex.containsKey(indx.nodeItem)) {
                return;
            }
            this.nodesIndex.put(indx.nodeItem, indx);
        }

        public Map<Integer, NodeIndexList> getItemList() {
            return this.nodesIndex;
        }

        public NodeIndexList getItemIndex(int item) {
            return this.nodesIndex.get(item);
        }

        public boolean hasItem(int item) {
            return this.nodesIndex.containsKey(item);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(String.format("GROUP (%6d) \n", this.groupid));
            for (Map.Entry<Integer, NodeIndexList> entry : this.nodesIndex.entrySet()) {
                str.append("\t");
                str.append(entry.getValue().toString());
                str.append("\n");
            }
            return str.toString();
        }
    }
}

