/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.io.PrintStream;

public class ProgressBar {
    private StringBuilder progress;
    PrintStream out;

    public ProgressBar() {
        this.init();
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void update(int done, int total) {
        char[] workchars = new char[]{'|', '/', '-', '\\'};
        String format = "\r%3d%% %s";
        int percent = ++done * 100 / total;
        int extrachars = percent / 2 - this.progress.length();
        while (extrachars-- > 0) {
            this.progress.append('#');
        }
        this.out.printf(format, percent, this.progress);
        if (done == total) {
            this.out.flush();
            this.out.println();
            this.init();
        }
    }

    private void init() {
        this.out = System.out;
        this.progress = new StringBuilder(60);
    }
}

