/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.base.FontProperties;
import org.jlab.groot.math.Dimension2D;
import org.jlab.groot.ui.LatexText;

public class PaveText {
    private int N_COLUMNS = 1;
    List<List<LatexText>> paveTexts = new ArrayList<List<LatexText>>();
    private Dimension2D paveDimension = new Dimension2D();
    private FontProperties paveFont = new FontProperties();
    private int yPadding = 5;
    private int xPadding = 5;
    private int ySpacing = 2;
    private int xSpacing = 10;
    private Color backgroundColor = Color.WHITE;

    public PaveText(int cols) {
        this.N_COLUMNS = cols;
        this.paveDimension.set(100.0, 120.0, 100.0, 120.0);
        this.paveFont.setFontName("Avenir");
        this.paveFont.setFontSize(10);
    }

    public void addText(String ... texts) {
        if (texts.length != this.N_COLUMNS) {
            System.out.println(" ERROR : number of columns = " + this.N_COLUMNS);
            return;
        }
        ArrayList<LatexText> lt = new ArrayList<LatexText>();
        for (String item : texts) {
            LatexText latex = new LatexText(item);
            latex.setFont(this.paveFont.getFontName());
            latex.setFontSize(this.paveFont.getFontSize());
            lt.add(latex);
        }
        this.paveTexts.add(lt);
    }

    public void setBackground(int r, int g, int b) {
        this.backgroundColor = new Color(r, g, b);
    }

    public void setBackground(int r, int g, int b, int alpha) {
        this.backgroundColor = new Color(r, g, b, alpha);
    }

    public void drawPave(Graphics2D g2d, int x, int y) {
        if (this.paveTexts.isEmpty()) {
            return;
        }
        this.updateDimensions(g2d);
        g2d.setColor(this.backgroundColor);
        g2d.fillRect((int)this.paveDimension.getDimension(0).getMin() - this.xPadding, (int)this.paveDimension.getDimension(1).getMin() - this.yPadding, (int)this.paveDimension.getDimension(0).getLength() + 2 * this.xPadding, (int)this.paveDimension.getDimension(1).getLength() + 2 * this.yPadding);
        g2d.setColor(Color.BLACK);
        g2d.drawRect((int)this.paveDimension.getDimension(0).getMin() - this.xPadding, (int)this.paveDimension.getDimension(1).getMin() - this.yPadding, (int)this.paveDimension.getDimension(0).getLength() + 2 * this.xPadding, (int)this.paveDimension.getDimension(1).getLength() + 2 * this.yPadding);
        int ystart = (int)this.paveDimension.getDimension(1).getMin();
        int xstart = (int)this.paveDimension.getDimension(0).getMin();
        for (List<LatexText> list : this.paveTexts) {
            if (list.size() == 2) {
                list.get(0).drawString(g2d, xstart, ystart, 0, 0);
                list.get(1).drawString(g2d, (int)((double)xstart + this.paveDimension.getDimension(0).getLength()), ystart, 2, 0);
            }
            ystart += this.ySpacing;
        }
    }

    public void setPosition(int x, int y) {
        this.paveDimension.getDimension(0).setMinMax(x, (double)x + this.paveDimension.getDimension(0).getLength());
        this.paveDimension.getDimension(1).setMinMax(y, (double)y + this.paveDimension.getDimension(1).getLength());
    }

    public Dimension2D getBounds() {
        return this.paveDimension;
    }

    public void updateDimensions(Graphics2D g2d) {
        int i;
        FontMetrics fmg = g2d.getFontMetrics(new Font(this.paveFont.getFontName(), 0, this.paveFont.getFontSize()));
        double[] widths = new double[this.N_COLUMNS];
        double height = 0.0;
        for (List<LatexText> list : this.paveTexts) {
            for (i = 0; i < this.N_COLUMNS; ++i) {
                Rectangle2D rect = fmg.getStringBounds(list.get(i).getText().getIterator(), 0, list.get(i).getText().getIterator().getEndIndex(), (Graphics)g2d);
                if (rect.getWidth() > widths[i]) {
                    widths[i] = rect.getWidth();
                }
                height += rect.getHeight() / (double)this.N_COLUMNS;
            }
        }
        double width = 0.0;
        for (i = 0; i < widths.length; ++i) {
            width += widths[i];
        }
        this.ySpacing = (int)(1.1 * height / (double)this.paveTexts.size());
        this.paveDimension.getDimension(0).setMinMax(this.paveDimension.getDimension(0).getMin(), this.paveDimension.getDimension(0).getMin() + width + (double)this.xSpacing);
        this.paveDimension.getDimension(1).setMinMax(this.paveDimension.getDimension(1).getMin(), this.paveDimension.getDimension(1).getMin() + (double)(this.ySpacing * this.paveTexts.size()));
    }

    public void setFont(String name) {
        this.paveFont.setFontName(name);
        for (List<LatexText> texts : this.paveTexts) {
            for (LatexText text : texts) {
                text.setFont(name);
            }
        }
    }

    public void setFontSize(int size) {
        this.paveFont.setFontSize(size);
        for (List<LatexText> texts : this.paveTexts) {
            for (LatexText text : texts) {
                text.setFontSize(size);
            }
        }
    }

    public List<List<LatexText>> getPaveTexts() {
        return this.paveTexts;
    }

    public void setPaveTexts(List<List<LatexText>> paveTexts) {
        this.paveTexts = paveTexts;
    }

    public void copy(PaveText pave) {
        this.paveTexts.clear();
        for (List<LatexText> list : pave.getPaveTexts()) {
        }
    }

    public void addRow(List<LatexText> element) {
        this.paveTexts.add(element);
    }
}

