/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.base.FontProperties;
import org.jlab.groot.math.Dimension1D;
import org.jlab.groot.ui.GraphicsAxisLabels;
import org.jlab.groot.ui.LatexText;

public class GraphicsAxis {
    private final Dimension1D axisRange = new Dimension1D();
    private final Dimension1D axisDimension = new Dimension1D();
    private final GraphicsAxisLabels axisLabels = new GraphicsAxisLabels();
    private int numberOfMajorTicks = 10;
    private Boolean isLogarithmic = false;
    private final FontProperties axisLabelFont = new FontProperties();
    private final FontProperties axisTitleFont = new FontProperties();

    public GraphicsAxis() {
        this.setDimension(0, 100);
        this.setRange(0.0, 1.0);
        this.axisLabels.setFontName("Avenir");
        this.axisLabels.setFontSize(12);
    }

    public final GraphicsAxis setDimension(int xmin, int xmax) {
        this.axisDimension.setMinMax(xmin, xmax);
        return this;
    }

    public Dimension1D getDimension() {
        return this.axisDimension;
    }

    public void setLog(boolean logflag) {
        this.isLogarithmic = logflag;
        this.axisRange.setLog(logflag);
        this.setRange(this.axisRange.getMin(), this.axisRange.getMax());
    }

    public boolean getLog() {
        return this.isLogarithmic;
    }

    public final GraphicsAxis setRange(double min, double max) {
        this.axisRange.setMinMax(min, max);
        if (this.isLogarithmic.booleanValue()) {
            List<Double> ticks = this.axisRange.getDimensionTicksLog(this.numberOfMajorTicks);
            this.axisLabels.updateLog(ticks);
        } else {
            List<Double> ticks = this.axisRange.getDimensionTicks(this.numberOfMajorTicks);
            this.axisLabels.update(ticks);
        }
        return this;
    }

    public Dimension1D getRange() {
        return this.axisRange;
    }

    public void show() {
        System.out.println(this.toString());
    }

    public double getAxisPosition(double value) {
        double fraction = this.axisRange.getFraction(value);
        return this.axisDimension.getPoint(fraction);
    }

    public FontProperties getTitleFont() {
        return this.axisTitleFont;
    }

    public FontProperties getLabelFont() {
        return this.axisLabelFont;
    }

    public int getSize(Graphics2D g2d, boolean vertical) {
        if (vertical) {
            return this.axisLabels.getAxisMaxWidth(g2d);
        }
        return this.axisLabels.getAxisMaxHeight(g2d);
    }

    public int getAxisDivisions() {
        return this.numberOfMajorTicks;
    }

    public void setAxisDivisions(int ndiv) {
        this.axisLabels.setFontName(this.axisLabelFont.getFontName());
        this.axisLabels.setFontSize(this.axisLabelFont.getFontSize());
        this.numberOfMajorTicks = ndiv;
        if (this.isLogarithmic.booleanValue()) {
            List<Double> ticks = this.axisRange.getDimensionTicksLog(this.numberOfMajorTicks);
            this.axisLabels.updateLog(ticks);
        } else {
            List<Double> ticks = this.axisRange.getDimensionTicks(this.numberOfMajorTicks);
            this.axisLabels.update(ticks);
        }
    }

    public List<Double> getAxisTicks() {
        return this.axisLabels.getTicks();
    }

    public List<Double> getAxisMinorTicks() {
        if (!this.isLogarithmic.booleanValue()) {
            return this.getAxisMinorTicksLinear();
        }
        return this.getAxisMinorTicksLog();
    }

    private List<Double> getAxisMinorTicksLog() {
        ArrayList<Double> minorTicks = new ArrayList<Double>();
        List<Double> majorTicks = this.axisLabels.getTicks();
        for (int i = 0; i < majorTicks.size() - 1; ++i) {
            for (int k = 2; k < 10; ++k) {
                double tick = majorTicks.get(i) * (double)k;
                minorTicks.add(tick);
            }
        }
        return minorTicks;
    }

    private List<Double> getAxisMinorTicksLinear() {
        int nticks = this.axisLabels.getTicks().size();
        ArrayList<Double> minorTicks = new ArrayList<Double>();
        if (nticks >= 2) {
            int ncount;
            double cTick = this.axisLabels.getTicks().get(0);
            double nTick = this.axisLabels.getTicks().get(1);
            double step = Math.abs(nTick - cTick) / 4.0;
            for (int i = 0; i < nticks - 1; ++i) {
                cTick = this.axisLabels.getTicks().get(i);
                nTick = this.axisLabels.getTicks().get(i + 1);
                for (int m = 0; m < 3; ++m) {
                    minorTicks.add(cTick + step * (double)(m + 1));
                }
            }
            cTick = nTick;
            for (ncount = 0; cTick < this.axisRange.getMax() && ncount < 10; ++ncount) {
                if (!((cTick += step) < this.axisRange.getMax())) continue;
                minorTicks.add(cTick);
            }
            cTick = this.axisLabels.getTicks().get(0);
            ncount = 0;
            while (cTick > this.axisRange.getMin() && ncount < 10) {
                if (!((cTick -= step) > this.axisRange.getMin())) continue;
                minorTicks.add(cTick);
            }
        }
        return minorTicks;
    }

    public double getLabelFraction(Graphics2D g2d, boolean isVertical) {
        double totalWidth = 0.0;
        totalWidth = isVertical ? (double)this.axisLabels.getAxisLabelsHeight(g2d) : (double)this.axisLabels.getAxisLabelsWidth(g2d);
        return totalWidth / this.axisDimension.getLength();
    }

    public List<LatexText> getAxisLabels() {
        return this.axisLabels.getLabels();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Axis : ");
        str.append(" LOG = ");
        str.append(this.isLogarithmic);
        str.append(String.format("  (%4d x %4d ) : ->  ", (int)this.axisDimension.getMin(), (int)this.axisDimension.getMax()));
        str.append(this.axisLabels.toString());
        return str.toString();
    }

    public static void main(String[] args) {
        GraphicsAxis axis = new GraphicsAxis();
        axis.setDimension(20, 100);
        axis.setRange(0.0, 120.0);
        axis.setLog(true);
        axis.show();
        for (double d = 0.0; d < 120.0; d += 0.5) {
            System.out.println(d + " fraction = " + axis.getAxisPosition(d));
        }
    }
}

