/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.data.H1F;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.tree.DatasetDescriptor;
import org.jlab.groot.tree.Tree;
import org.jlab.groot.tree.TreeAnalyzer;
import org.jlab.groot.tree.TreeCut;
import org.jlab.groot.tree.TreeExpression;

public class DescriptorPanel
extends JPanel {
    int type = 1;
    Tree tree;
    TreeAnalyzer treeAnalyzer;
    DatasetDescriptor descriptor = null;
    ArrayList<String> branches;
    ArrayList<String> cutStrings;
    ArrayList<JCheckBox> cutBoxes = new ArrayList();
    Map<String, TreeCut> cutMap;
    private int iconSizeX = 15;
    private int iconSizeY = 15;
    ImageIcon checkIcon = new ImageIcon();
    ImageIcon xIcon = new ImageIcon();
    boolean initialized = false;
    boolean editMode = false;
    JComboBox branchComboBoxX = new JComboBox();
    JComboBox branchComboBoxY = new JComboBox();
    JLabel validationPlaceHolderX = new JLabel();
    JLabel validationPlaceHolderY = new JLabel();
    JCheckBox previewCheckBox = new JCheckBox("Instant Preview");
    JCheckBox estimateCheckBox = new JCheckBox("Estimate Range/Binning");
    JTextField name = new JTextField();
    JTextField descriptorName = new JTextField();
    JTextField branchVariableFieldX = new JTextField();
    JTextField branchVariableFieldXerr = new JTextField();
    JTextField binTextFieldX = new JTextField();
    JTextField minTextFieldX = new JTextField();
    JTextField maxTextFieldX = new JTextField();
    JTextField branchVariableFieldY = new JTextField();
    JTextField branchVariableFieldYerr = new JTextField();
    JTextField binTextFieldY = new JTextField();
    JTextField minTextFieldY = new JTextField();
    JTextField maxTextFieldY = new JTextField();
    JPanel histogramOptions = new JPanel();
    JPanel cutOptions = new JPanel();
    JPanel leftPanel = new JPanel();
    EmbeddedCanvas previewCanvas = new EmbeddedCanvas();

    public DescriptorPanel(Tree tree, TreeAnalyzer treeAnalyzer, DatasetDescriptor descriptor) {
        this.editMode = true;
        this.type = descriptor.getDescriptorType();
        this.tree = tree;
        this.treeAnalyzer = treeAnalyzer;
        if (this.type == DatasetDescriptor.DESCRIPTOR_H1) {
            this.previewCheckBox.setSelected(true);
        } else {
            this.previewCheckBox.setSelected(false);
        }
        this.estimateCheckBox.setSelected(false);
        this.init();
        if (this.type == DatasetDescriptor.DESCRIPTOR_H1) {
            this.branchVariableFieldX.setText(descriptor.getExpressionX());
            this.binTextFieldX.setText("" + descriptor.getNbinsX());
            this.minTextFieldX.setText("" + descriptor.getMinX());
            this.maxTextFieldX.setText("" + descriptor.getMaxX());
            this.descriptorName.setText("" + descriptor.getDescName());
            this.validateExpression(0);
        } else if (this.type == DatasetDescriptor.DESCRIPTOR_H2) {
            this.descriptorName.setText("" + descriptor.getDescName());
            this.branchVariableFieldX.setText(descriptor.getExpressionX());
            this.binTextFieldX.setText("" + descriptor.getNbinsX());
            this.minTextFieldX.setText("" + descriptor.getMinX());
            this.maxTextFieldX.setText("" + descriptor.getMaxX());
            this.branchVariableFieldY.setText(descriptor.getExpressionY());
            this.binTextFieldY.setText("" + descriptor.getNbinsY());
            this.minTextFieldY.setText("" + descriptor.getMinY());
            this.maxTextFieldY.setText("" + descriptor.getMaxY());
            this.validateExpression(0);
            this.validateExpression(1);
        }
        this.descriptorName.setEditable(false);
    }

    public DescriptorPanel(Tree tree, TreeAnalyzer treeAnalyzer, int type) {
        this.type = type;
        this.tree = tree;
        this.treeAnalyzer = treeAnalyzer;
        if (this.type == DatasetDescriptor.DESCRIPTOR_H1) {
            this.previewCheckBox.setSelected(true);
        } else {
            this.previewCheckBox.setSelected(false);
        }
        this.estimateCheckBox.setSelected(true);
        this.init();
    }

    public DescriptorPanel(Tree tree, TreeAnalyzer treeAnalyzer) {
        this.type = 1;
        this.tree = tree;
        this.treeAnalyzer = treeAnalyzer;
        if (this.type == DatasetDescriptor.DESCRIPTOR_H1) {
            this.previewCheckBox.setSelected(true);
        } else {
            this.previewCheckBox.setSelected(false);
        }
        this.estimateCheckBox.setSelected(true);
        this.init();
    }

    private void init() {
        this.removeAll();
        this.leftPanel.removeAll();
        this.repaint();
        if (!this.initialized) {
            this.previewCheckBox.addActionListener(e -> {
                System.out.println("init!");
                this.init();
            });
        }
        this.leftPanel.setLayout(new GridBagLayout());
        GridBagConstraints cMain = new GridBagConstraints();
        cMain.gridy = 0;
        cMain.weightx = 1.0;
        cMain.weighty = 1.0;
        cMain.fill = 1;
        try {
            BufferedImage checkImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/general/checkmark.png"));
            BufferedImage xImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/general/xmark.png"));
            this.checkIcon = new ImageIcon(checkImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            this.xIcon = new ImageIcon(xImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
        }
        catch (Exception checkImage) {
            // empty catch block
        }
        if (this.descriptor == null) {
            this.descriptor = new DatasetDescriptor("Dataset Name", this.type);
        }
        JLabel typeLabel = new JLabel("Dataset Type:");
        String[] types = new String[]{"1D Histogram", "2D Histogram", "GraphErrors"};
        JComboBox<String> typeComboBox = new JComboBox<String>(types);
        if (this.type == DatasetDescriptor.DESCRIPTOR_H1) {
            typeComboBox.setSelectedIndex(0);
        } else if (this.type == DatasetDescriptor.DESCRIPTOR_H2) {
            typeComboBox.setSelectedIndex(1);
        } else {
            typeComboBox.setSelectedIndex(2);
        }
        this.descriptorName = new JTextField(20);
        this.descriptorName.setText(this.descriptor.getDescName());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        headerPanel.add((Component)typeLabel, c);
        headerPanel.add(typeComboBox, c);
        ++c.gridy;
        headerPanel.add((Component)new JLabel("Dataset Name:"), c);
        headerPanel.add((Component)this.descriptorName, c);
        headerPanel.setBorder(new TitledBorder("Main"));
        this.setLayout(new GridBagLayout());
        this.leftPanel.add((Component)headerPanel, cMain);
        if (!this.initialized) {
            this.initHistogramOptions();
        }
        ++cMain.gridy;
        this.leftPanel.add((Component)this.histogramOptions, cMain);
        this.cutMap = this.tree.getSelector().getSelectorCuts();
        this.cutStrings = new ArrayList();
        Object[] keys = this.cutMap.keySet().toArray();
        for (int i = 0; i < this.cutMap.keySet().size(); ++i) {
            this.cutStrings.add((String)keys[i]);
        }
        JPanel previewOptions = new JPanel(new GridBagLayout());
        GridBagConstraints cPreview = new GridBagConstraints();
        cPreview.fill = 1;
        cPreview.weightx = 1.0;
        cPreview.weighty = 1.0;
        previewOptions.setBorder(new TitledBorder("Options"));
        previewOptions.add((Component)this.previewCheckBox, cPreview);
        previewOptions.add((Component)this.estimateCheckBox, cPreview);
        ++cMain.gridy;
        this.leftPanel.add((Component)previewOptions, cMain);
        if (!this.initialized) {
            this.initCutOptions();
        }
        if (this.cutStrings != null && this.cutStrings.size() > 0) {
            ++cMain.gridy;
            this.leftPanel.add((Component)this.cutOptions, cMain);
        }
        JButton saveAndClose = new JButton("Apply");
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridy = 0;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        c1.fill = 1;
        c1.gridx = 0;
        this.add((Component)this.leftPanel, c1);
        if (this.previewCheckBox.isSelected()) {
            ++c1.gridx;
            this.add((Component)this.previewCanvas, c1);
        }
        c1.gridx = 0;
        ++c1.gridy;
        this.add((Component)saveAndClose, c1);
        saveAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Double maxx;
                Double minx;
                String expressionx;
                if (DescriptorPanel.this.type == DatasetDescriptor.DESCRIPTOR_H1) {
                    expressionx = DescriptorPanel.this.branchVariableFieldX.getText();
                    int binsx = Integer.parseInt(DescriptorPanel.this.binTextFieldX.getText());
                    minx = Double.parseDouble(DescriptorPanel.this.minTextFieldX.getText());
                    maxx = Double.parseDouble(DescriptorPanel.this.maxTextFieldX.getText());
                    DescriptorPanel.this.descriptor.setDescName(DescriptorPanel.this.descriptorName.getText());
                    DescriptorPanel.this.descriptor.setNbinsX(binsx);
                    DescriptorPanel.this.descriptor.setMinX(minx);
                    DescriptorPanel.this.descriptor.setMaxX(maxx);
                    DescriptorPanel.this.descriptor.setExpression(expressionx, DescriptorPanel.this.tree);
                    DescriptorPanel.this.descriptor.initDatasets();
                } else if (DescriptorPanel.this.type == DatasetDescriptor.DESCRIPTOR_H2) {
                    expressionx = DescriptorPanel.this.branchVariableFieldX.getText();
                    int binsx = Integer.parseInt(DescriptorPanel.this.binTextFieldX.getText());
                    minx = Double.parseDouble(DescriptorPanel.this.minTextFieldX.getText());
                    maxx = Double.parseDouble(DescriptorPanel.this.maxTextFieldX.getText());
                    String expressiony = DescriptorPanel.this.branchVariableFieldY.getText();
                    int binsy = Integer.parseInt(DescriptorPanel.this.binTextFieldY.getText());
                    Double miny = Double.parseDouble(DescriptorPanel.this.minTextFieldY.getText());
                    Double maxy = Double.parseDouble(DescriptorPanel.this.maxTextFieldY.getText());
                    DescriptorPanel.this.descriptor = new DatasetDescriptor(DescriptorPanel.this.descriptorName.getText(), binsx, minx, maxx, binsy, miny, maxy, expressionx + ":" + expressiony, DescriptorPanel.this.tree);
                } else {
                    String x = DescriptorPanel.this.branchVariableFieldX.getText();
                    String xerr = DescriptorPanel.this.branchVariableFieldXerr.getText();
                    String y = DescriptorPanel.this.branchVariableFieldY.getText();
                    String yerr = DescriptorPanel.this.branchVariableFieldYerr.getText();
                    DescriptorPanel.this.descriptor = !(xerr != "" && xerr != "0" || yerr != "" && yerr != "0") ? new DatasetDescriptor(DescriptorPanel.this.descriptorName.getText(), x + ":" + y, DescriptorPanel.this.tree) : (xerr == "" || xerr == "0" ? new DatasetDescriptor(DescriptorPanel.this.descriptorName.getText(), x + ":" + y + ":" + yerr, DescriptorPanel.this.tree) : new DatasetDescriptor(DescriptorPanel.this.descriptorName.getText(), x + ":" + y + ":" + xerr + ":" + yerr, DescriptorPanel.this.tree));
                }
                DescriptorPanel.this.descriptor.clearCuts();
                for (int i = 0; i < DescriptorPanel.this.cutBoxes.size(); ++i) {
                    if (!DescriptorPanel.this.cutBoxes.get(i).isSelected()) continue;
                    DescriptorPanel.this.descriptor.addCut(DescriptorPanel.this.cutMap.get(DescriptorPanel.this.cutStrings.get(i)));
                }
                if (!DescriptorPanel.this.editMode) {
                    DescriptorPanel.this.treeAnalyzer.addDescriptor(DescriptorPanel.this.descriptor);
                } else {
                    DescriptorPanel.this.treeAnalyzer.updateDescriptor(DescriptorPanel.this.descriptor);
                    System.out.println("Update descriptor" + DescriptorPanel.this.descriptor.getDescName());
                }
                System.out.println("Save and close descriptor!");
                SwingUtilities.getWindowAncestor(DescriptorPanel.this.branchVariableFieldX).dispose();
            }
        });
        try {
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
            topFrame.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initialized = true;
    }

    private void initCutOptions() {
        if (this.cutStrings != null && this.cutStrings.size() > 0) {
            this.cutOptions.setLayout(new GridBagLayout());
            this.cutOptions.setBorder(new TitledBorder("Cuts"));
            GridBagConstraints c = new GridBagConstraints();
            boolean gridy = false;
            for (int i = 0; i < this.cutStrings.size(); ++i) {
                System.out.println("Cut " + i + " " + this.cutStrings.get(i));
                this.cutBoxes.add(new JCheckBox(this.cutStrings.get(i)));
                this.cutBoxes.get(i).addActionListener(e -> {
                    this.validateExpression(0);
                    this.validateExpression(1);
                });
                c.gridy = i;
                this.cutOptions.add((Component)this.cutBoxes.get(i), c);
            }
        }
    }

    private void initHistogramOptions() {
        this.branches = (ArrayList)this.tree.getListOfBranches();
        this.branchComboBoxX = new JComboBox<Object>(this.tree.getListOfBranches().toArray());
        this.branchComboBoxX.setMaximumSize(new Dimension(52, this.branchComboBoxX.getPreferredSize().height));
        this.branchComboBoxX.setPreferredSize(new Dimension(52, this.branchComboBoxX.getPreferredSize().height));
        this.branchComboBoxX.setMinimumSize(new Dimension(52, this.branchComboBoxX.getPreferredSize().height));
        this.branchComboBoxX.addActionListener(e -> {
            this.branchVariableFieldX.setText(this.branchVariableFieldX.getText() + this.branchComboBoxX.getSelectedItem());
            this.validateExpression(0);
        });
        this.branchComboBoxY = new JComboBox<Object>(this.tree.getListOfBranches().toArray());
        this.branchComboBoxY.setMaximumSize(new Dimension(52, this.branchComboBoxY.getPreferredSize().height));
        this.branchComboBoxY.setPreferredSize(new Dimension(52, this.branchComboBoxY.getPreferredSize().height));
        this.branchComboBoxY.setMinimumSize(new Dimension(52, this.branchComboBoxY.getPreferredSize().height));
        this.branchComboBoxY.addActionListener(e -> {
            this.branchVariableFieldY.setText(this.branchVariableFieldY.getText() + this.branchComboBoxY.getSelectedItem());
            this.validateExpression(1);
        });
        KeyListener binningListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DescriptorPanel.this.estimateCheckBox.setSelected(false);
                DescriptorPanel.this.validateExpression(0);
                if (DescriptorPanel.this.type == DatasetDescriptor.DESCRIPTOR_H2) {
                    DescriptorPanel.this.validateExpression(1);
                }
            }
        };
        this.branchVariableFieldX.setColumns(10);
        this.branchVariableFieldXerr.setColumns(10);
        this.branchVariableFieldY.setColumns(10);
        this.branchVariableFieldYerr.setColumns(10);
        this.binTextFieldX.setColumns(5);
        this.binTextFieldX.addKeyListener(binningListener);
        this.minTextFieldX.setColumns(5);
        this.minTextFieldX.addKeyListener(binningListener);
        this.maxTextFieldX.setColumns(5);
        this.maxTextFieldX.addKeyListener(binningListener);
        this.binTextFieldY.setColumns(5);
        this.binTextFieldY.addKeyListener(binningListener);
        this.minTextFieldY.setColumns(5);
        this.minTextFieldY.addKeyListener(binningListener);
        this.maxTextFieldY.setColumns(5);
        this.maxTextFieldY.addKeyListener(binningListener);
        this.branchVariableFieldX.addActionListener(e -> this.validateExpression(0));
        this.branchVariableFieldY.addActionListener(e -> this.validateExpression(1));
        this.branchVariableFieldX.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DescriptorPanel.this.validateExpression(0);
            }
        });
        this.branchVariableFieldY.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DescriptorPanel.this.validateExpression(1);
            }
        });
        this.histogramOptions.setLayout(new GridBagLayout());
        this.histogramOptions.setBorder(new TitledBorder("Histogram Options"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        int gridy = 0;
        c.gridy = gridy++;
        if (this.type == DatasetDescriptor.DESCRIPTOR_H1) {
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Variable:"), c);
            this.histogramOptions.add((Component)this.branchVariableFieldX, c);
            this.histogramOptions.add((Component)this.branchComboBoxX, c);
            this.histogramOptions.add((Component)this.validationPlaceHolderX, c);
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("#Bins:"), c);
            c.gridwidth = 3;
            this.histogramOptions.add((Component)this.binTextFieldX, c);
            c.gridwidth = 1;
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Min:"), c);
            c.gridwidth = 3;
            this.histogramOptions.add((Component)this.minTextFieldX, c);
            c.gridwidth = 1;
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Max:"), c);
            c.gridwidth = 3;
            this.histogramOptions.add((Component)this.maxTextFieldX, c);
            c.gridwidth = 1;
        } else if (this.type == DatasetDescriptor.DESCRIPTOR_H2) {
            c.gridwidth = 1;
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Variable:"), c);
            this.histogramOptions.add((Component)this.branchVariableFieldX, c);
            this.histogramOptions.add((Component)this.branchComboBoxX, c);
            this.histogramOptions.add((Component)this.validationPlaceHolderX, c);
            this.histogramOptions.add((Component)this.branchVariableFieldY, c);
            this.histogramOptions.add((Component)this.branchComboBoxY, c);
            this.histogramOptions.add((Component)this.validationPlaceHolderY, c);
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("#Bins:"), c);
            c.gridwidth = 3;
            this.histogramOptions.add((Component)this.binTextFieldX, c);
            this.histogramOptions.add((Component)this.binTextFieldY, c);
            c.gridwidth = 1;
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Min:"), c);
            c.gridwidth = 3;
            this.histogramOptions.add((Component)this.minTextFieldX, c);
            this.histogramOptions.add((Component)this.minTextFieldY, c);
            c.gridwidth = 1;
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Max:"), c);
            c.gridwidth = 3;
            this.histogramOptions.add((Component)this.maxTextFieldX, c);
            this.histogramOptions.add((Component)this.maxTextFieldY, c);
            c.gridwidth = 3;
        } else {
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Variable:"), c);
            this.histogramOptions.add((Component)this.branchVariableFieldX, c);
            this.histogramOptions.add((Component)this.branchComboBoxX, c);
            this.histogramOptions.add((Component)this.branchVariableFieldY, c);
            this.histogramOptions.add((Component)this.branchComboBoxY, c);
            c.gridy = gridy++;
            this.histogramOptions.add((Component)new JLabel("Variable Error:"), c);
            this.histogramOptions.add((Component)this.branchVariableFieldXerr, c);
            this.histogramOptions.add((Component)this.branchVariableFieldYerr, c);
        }
        this.validateExpression(0);
        this.validateExpression(1);
    }

    private void validateExpression(int i) {
        List<DataVector> vecs;
        boolean passed;
        String cuts = "";
        boolean xPassed = false;
        for (int j = 0; j < this.cutBoxes.size(); ++j) {
            if (!this.cutBoxes.get(j).isSelected()) continue;
            cuts = cuts == "" ? cuts + "(" + this.cutMap.get(this.cutStrings.get(j)).getExpression() + ")" : cuts + "*(" + this.cutMap.get(this.cutStrings.get(j)).getExpression() + ")";
        }
        if (i == 0 || i == 1) {
            passed = TreeExpression.validateExpression(this.branchVariableFieldX.getText(), this.tree.getListOfBranches());
            if (passed) {
                try {
                    this.tree.scanTree(this.branchVariableFieldX.getText(), cuts, 1000, true);
                    vecs = this.tree.getScanResults();
                    if (this.estimateCheckBox.isSelected() && vecs.size() >= 1) {
                        this.minTextFieldX.setText(String.format("%4.2f", vecs.get(0).getMin()));
                        this.maxTextFieldX.setText(String.format("%4.2f", vecs.get(0).getMax()));
                        this.binTextFieldX.setText(String.format("%d", vecs.get(0).getBinSuggestion()));
                    }
                }
                catch (Exception e) {
                    passed = false;
                }
            }
            if (!passed) {
                this.validationPlaceHolderX.setIcon(this.xIcon);
                this.validationPlaceHolderX.repaint();
                if (this.estimateCheckBox.isSelected()) {
                    this.minTextFieldX.setText("");
                    this.maxTextFieldX.setText("");
                    this.binTextFieldX.setText("");
                }
            } else {
                this.validationPlaceHolderX.setIcon(this.checkIcon);
                this.validationPlaceHolderX.repaint();
                if (this.previewCheckBox.isSelected()) {
                    this.drawPreviewHistogram();
                }
            }
        }
        if (i == 1) {
            passed = TreeExpression.validateExpression(this.branchVariableFieldY.getText(), this.tree.getListOfBranches());
            if (passed) {
                try {
                    this.tree.scanTree(this.branchVariableFieldY.getText(), cuts, 1000, true);
                    if (this.estimateCheckBox.isSelected() && (vecs = this.tree.getScanResults()).size() >= 1) {
                        this.minTextFieldY.setText(String.format("%4.2f", vecs.get(0).getMin()));
                        this.maxTextFieldY.setText(String.format("%4.2f", vecs.get(0).getMax()));
                        this.binTextFieldY.setText(String.format("%d", vecs.get(0).getBinSuggestion()));
                    }
                }
                catch (Exception e) {
                    passed = false;
                }
            }
            if (!passed) {
                this.validationPlaceHolderY.setIcon(this.xIcon);
                this.validationPlaceHolderY.repaint();
                if (this.estimateCheckBox.isSelected()) {
                    this.minTextFieldY.setText("");
                    this.maxTextFieldY.setText("");
                    this.binTextFieldY.setText("");
                }
            } else {
                this.validationPlaceHolderY.setIcon(this.checkIcon);
                this.validationPlaceHolderY.repaint();
            }
        }
    }

    private void drawPreviewHistogram() {
        List<DataVector> vecs = this.tree.getScanResults();
        int bins = Integer.parseInt(this.binTextFieldX.getText());
        double min = Double.parseDouble(this.minTextFieldX.getText());
        double max = Double.parseDouble(this.maxTextFieldX.getText());
        H1F htemp = new H1F("PreviewHistogram", bins, min, max);
        htemp.fill(vecs.get(0), vecs.get(1));
        this.previewCanvas.draw(htemp);
        this.previewCanvas.update();
    }
}

