/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.tree.Tree;
import org.jlab.groot.tree.TreeCut;
import org.jlab.groot.tree.TreeSelector;

public class CutPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    TreeCut cut = null;
    Tree tree;
    TreeSelector selector;
    String name = "";
    String cutString = "";
    ArrayList<String> branches;
    private int iconSizeX = 15;
    private int iconSizeY = 15;
    EmbeddedCanvas previewCanvas = new EmbeddedCanvas();
    ScrollPane globalCuts = new ScrollPane();
    ImageIcon checkIcon = new ImageIcon();
    ImageIcon xIcon = new ImageIcon();
    JLabel validationPlaceHolder = null;
    JComboBox branchComboBox = new JComboBox();
    JTextField cutNameTextField = new JTextField();
    JTextField cutTextArea = new JTextField();
    JTextField cutValueTextField = new JTextField();
    JComboBox cutOperator = new JComboBox();
    String[] operators = new String[]{"<", ">", ">=", "<=", "=="};
    JComboBox branchVariableSelector = new JComboBox();
    JTextArea textArea = new JTextArea();
    ArrayList<String> cutStrings;
    ArrayList<JCheckBox> cutBoxes = new ArrayList();
    Map<String, TreeCut> cutMap;
    JPanel cutOptions = new JPanel();
    JPanel leftPanel = new JPanel();
    boolean editMode = false;
    private Mode mode = Mode.INSERT;
    private static final String COMMIT_ACTION = "commit";

    public CutPanel(Tree tree) {
        this.tree = tree;
        this.selector = tree.getSelector();
        this.name = "New Cut";
        this.cutString = "";
        this.branches = (ArrayList)tree.getListOfBranches();
        this.init();
    }

    public CutPanel(Tree tree, TreeCut cut) {
        this.tree = tree;
        this.selector = tree.getSelector();
        this.name = cut.getName();
        this.cutString = cut.getExpression();
        this.branches = (ArrayList)tree.getListOfBranches();
        this.cut = cut;
        this.editMode = true;
        this.init();
        this.validateExpression();
    }

    private void init() {
        int i;
        try {
            BufferedImage checkImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/general/checkmark.png"));
            BufferedImage xImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/general/xmark.png"));
            this.checkIcon = new ImageIcon(checkImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            this.xIcon = new ImageIcon(xImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
        }
        catch (Exception checkImage) {
            // empty catch block
        }
        this.cutMap = this.tree.getSelector().getSelectorCuts();
        this.cutStrings = new ArrayList();
        Object[] keys = this.cutMap.keySet().toArray();
        Object[] treeCuts = this.cutMap.values().toArray();
        for (i = 0; i < this.cutMap.keySet().size(); ++i) {
            this.cutStrings.add((String)keys[i]);
        }
        this.validationPlaceHolder = new JLabel(this.xIcon);
        this.cutNameTextField.setText(this.name);
        for (i = 0; i < this.branches.size(); ++i) {
            this.branchVariableSelector.addItem(this.branches.get(i));
        }
        for (i = 0; i < this.operators.length; ++i) {
            this.cutOperator.addItem(this.operators[i]);
        }
        JButton addCutButton = new JButton("Add to Cut");
        addCutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.cutTextArea.setColumns(20);
        this.cutTextArea.setText(this.cutString);
        JButton saveButton = new JButton("Apply");
        this.leftPanel.setLayout(new GridBagLayout());
        JPanel nameExpressionPanel = new JPanel(new GridBagLayout());
        nameExpressionPanel.setBorder(new TitledBorder("Cut Definition"));
        GridBagConstraints c4 = new GridBagConstraints();
        c4.fill = 2;
        c4.weightx = 1.0;
        c4.weighty = 1.0;
        this.cutValueTextField.setColumns(6);
        int gridInt = 0;
        c4.gridwidth = 2;
        c4.gridy = gridInt++;
        nameExpressionPanel.add((Component)new JLabel("Cut Name:"), c4);
        c4.gridwidth = 4;
        nameExpressionPanel.add((Component)this.cutNameTextField, c4);
        this.branchComboBox = new JComboBox<Object>(this.tree.getListOfBranches().toArray());
        this.branchComboBox.setMaximumSize(new Dimension(52, this.branchComboBox.getPreferredSize().height));
        this.branchComboBox.setPreferredSize(new Dimension(52, this.branchComboBox.getPreferredSize().height));
        this.branchComboBox.setMinimumSize(new Dimension(52, this.branchComboBox.getPreferredSize().height));
        this.branchComboBox.addActionListener(e -> {
            this.cutTextArea.setText(this.cutTextArea.getText() + this.branchComboBox.getSelectedItem());
            this.validateExpression();
        });
        c4.gridy = gridInt++;
        c4.fill = 2;
        c4.gridwidth = 2;
        nameExpressionPanel.add((Component)new JLabel("Cut Expression:"), c4);
        c4.gridwidth = 3;
        nameExpressionPanel.add((Component)this.cutTextArea, c4);
        c4.gridwidth = 1;
        nameExpressionPanel.add((Component)this.branchComboBox, c4);
        nameExpressionPanel.add((Component)this.validationPlaceHolder, c4);
        this.cutTextArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CutPanel.this.validateExpression();
            }
        });
        JPanel previewOptions = new JPanel(new GridBagLayout());
        GridBagConstraints cPreview = new GridBagConstraints();
        cPreview.fill = 1;
        cPreview.weightx = 1.0;
        cPreview.weighty = 1.0;
        previewOptions.setBorder(new TitledBorder("Preview Options"));
        JCheckBox previewCheckBox = new JCheckBox("Show Preview");
        String[] previewOptionsList = new String[]{"Cut Preview", "Lines", "Blue/Red"};
        JComboBox<String> previewOptionBox = new JComboBox<String>(previewOptionsList);
        previewOptions.add((Component)previewCheckBox, cPreview);
        previewOptions.add(previewOptionBox, cPreview);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.leftPanel.add((Component)nameExpressionPanel, c);
        this.initCutOptions();
        if (this.cutStrings != null && this.cutStrings.size() > 0) {
            ++c.gridy;
            this.leftPanel.add((Component)this.cutOptions, c);
        }
        ++c.gridy;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.gridwidth = 2;
        c2.gridy = 0;
        this.add((Component)this.leftPanel, c2);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        JButton cancelButton = new JButton("Cancel");
        this.add((Component)cancelButton, c2);
        ++c2.gridx;
        this.add((Component)saveButton, c2);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CutPanel.this.cut != null) {
                    CutPanel.this.cut.setName(CutPanel.this.cutNameTextField.getText());
                    CutPanel.this.cut.setExpression(CutPanel.this.cutTextArea.getText());
                } else {
                    CutPanel.this.selector.addCut(new TreeCut(CutPanel.this.cutNameTextField.getText(), CutPanel.this.cutTextArea.getText(), CutPanel.this.branches));
                }
                SwingUtilities.getWindowAncestor(CutPanel.this.cutNameTextField).dispose();
            }
        });
    }

    private void initCutOptions() {
        if (this.cutStrings != null && this.cutStrings.size() > 0) {
            this.cutOptions.setLayout(new GridBagLayout());
            this.cutOptions.setBorder(new TitledBorder("Cuts"));
            GridBagConstraints c = new GridBagConstraints();
            boolean gridy = false;
            for (int i = 0; i < this.cutStrings.size(); ++i) {
                System.out.println("Cut " + i + " " + this.cutStrings.get(i));
                this.cutBoxes.add(new JCheckBox(this.cutStrings.get(i)));
                this.cutBoxes.get(i).addActionListener(e -> this.validateExpression());
                c.gridy = i;
                this.cutOptions.add((Component)this.cutBoxes.get(i), c);
            }
        }
    }

    private void validateExpression() {
        boolean passed = TreeCut.validateExpression(this.cutTextArea.getText(), this.tree.getListOfBranches());
        if (!passed) {
            this.validationPlaceHolder.setIcon(this.xIcon);
            this.validationPlaceHolder.repaint();
        } else {
            this.validationPlaceHolder.setIcon(this.checkIcon);
            this.validationPlaceHolder.repaint();
        }
    }

    public void showPreview() {
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }
}

