/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.matrix;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.jlab.groot.ui.RangeSlider;

public class SparseIndexPane
extends JPanel {
    int indexRank = 0;
    int[] dimensions = null;
    int numberOrder = 0;
    List<RangeSlider> sliders = new ArrayList<RangeSlider>();
    JComboBox selectionBin = null;
    JComboBox selectionOrder = null;
    JComboBox selectionBinY = null;
    JComboBox selectionOrderY = null;

    public SparseIndexPane(int[] dims, int vectorSize) {
        this.dimensions = dims;
        this.setBorder(BorderFactory.createTitledBorder("Grid Index"));
        this.setLayout((LayoutManager)new MigLayout());
        this.numberOrder = vectorSize;
        this.initUI();
    }

    private void initUI() {
        int i;
        for (int i2 = 0; i2 < this.dimensions.length; ++i2) {
            RangeSlider sl = new RangeSlider(0, this.dimensions[i2] - 1);
            sl.setUpperValue(this.dimensions[i2] - 1);
            sl.setValue(0);
            sl.setMajorTickSpacing(2);
            sl.setMinorTickSpacing(1);
            sl.setPaintTicks(true);
            sl.setPaintLabels(true);
            sl.setSnapToTicks(true);
            this.sliders.add(sl);
            this.add(new JLabel("DIM " + i2 + " : "));
            this.add((Component)sl, "wrap, pushx, growx");
        }
        String[] choises = new String[this.dimensions.length];
        String[] choisesOrder = new String[this.numberOrder];
        for (i = 0; i < choises.length; ++i) {
            choises[i] = new Integer(i).toString();
        }
        this.selectionBin = new JComboBox<String>(choises);
        for (i = 0; i < this.numberOrder; ++i) {
            choisesOrder[i] = new Integer(i).toString();
        }
        this.selectionOrder = new JComboBox<String>(choisesOrder);
        this.add(new JLabel(""));
        this.add((Component)new JSeparator(), "wrap, pushx, growx");
        this.add(new JLabel("X dimension : "));
        this.add((Component)this.selectionBin, "split 3, growx");
        this.add(new JLabel("Vector : "));
        this.add((Component)this.selectionOrder, "growx");
    }

    public int[] getBins() {
        int[] index = new int[this.sliders.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = this.sliders.get(i).getValue();
        }
        return index;
    }

    public int[] getBinsMin() {
        int[] index = new int[this.sliders.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = this.sliders.get(i).getValue();
        }
        return index;
    }

    public int[] getBinsMax() {
        int[] index = new int[this.sliders.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = this.sliders.get(i).getUpperValue();
        }
        return index;
    }

    public int getSelectedBin() {
        String token = (String)this.selectionBin.getSelectedItem();
        return Integer.parseInt(token);
    }

    public int getSelectedOrder() {
        String token = (String)this.selectionOrder.getSelectedItem();
        return Integer.parseInt(token);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        SparseIndexPane pane = new SparseIndexPane(new int[]{10, 15, 20}, 2);
        frame.setDefaultCloseOperation(3);
        frame.add(pane);
        frame.pack();
        frame.setVisible(true);
    }
}

