/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.H2F;
import org.jlab.groot.math.F1D;
import org.jlab.groot.math.Func1D;
import org.jlab.groot.math.RandomFunc;

public class FunctionFactory {
    public static Map<String, Func1D> funcionDesk = new LinkedHashMap<String, Func1D>();
    public static double PI_OVER_2 = 1.5707963267948966;

    public static double acos(double x) {
        return PI_OVER_2 - FunctionFactory.asin(x);
    }

    public static double asin(double x) {
        boolean isNeg = x < 0.0;
        x = Math.abs(x);
        double y1 = x * (-0.0170881256 + x * (0.0066700901 + x * -0.0012624911));
        double y2 = x * (-0.0501743046 + x * (0.030891881 + y1));
        double y = 1.570796305 + x * (-0.2145988016 + x * (0.0889789874 + y2));
        double theta = PI_OVER_2 - Math.sqrt(1.0 - x) * y;
        if (isNeg) {
            theta = -theta;
        }
        return theta;
    }

    public static double asin_4(double x) {
        boolean isNeg = x < 0.0;
        x = Math.abs(x);
        double y = 1.5707288 + x * (-0.2121144 + x * (0.074261 + x * -0.0187293));
        double theta = PI_OVER_2 - Math.sqrt(1.0 - x) * y;
        if (isNeg) {
            theta = -theta;
        }
        return theta;
    }

    public static void registerFunction(Func1D func) {
        if (funcionDesk.containsKey(func.getName())) {
            System.out.println("[FunctionFactory] warning : ---> replacing function with name = " + func.getName());
        }
        funcionDesk.put(func.getName(), func);
    }

    public static double atan(double x) {
        double h = Math.sqrt(x * x + 1.0);
        return FunctionFactory.asin(x / h);
    }

    public static double atan2(double y, double x) {
        if (x > 0.0) {
            return FunctionFactory.atan(y / x);
        }
        if (x < 0.0) {
            if (y >= 0.0) {
                return Math.PI + FunctionFactory.atan(y / x);
            }
            return -Math.PI + FunctionFactory.atan(y / x);
        }
        if (y > 0.0) {
            return 1.5707963267948966;
        }
        if (y < 0.0) {
            return -1.5707963267948966;
        }
        return 0.0;
    }

    public static double gauss(double x, double mean, double sigma) {
        return Math.exp(-(x - mean) * (x - mean) / (2.0 * sigma * sigma));
    }

    public static double getRandMinMax(double min, double max) {
        return min + (max - min) * Math.random();
    }

    public static double landau(double x, double mean, double sigma) {
        double lambda = (x - mean) / sigma;
        return Math.exp(-0.5 * (lambda + Math.exp(-lambda)));
    }

    public static H1F randomGausian(int bins, double min, double max, int stat, double mean, double sigma) {
        H1F h = new H1F("RandomGaus", bins, min, max);
        for (int i = 0; i < stat; ++i) {
            double x = FunctionFactory.getRandMinMax(min, max);
            double w = FunctionFactory.gauss(x, mean, sigma);
            h.fill(x, w);
        }
        return h;
    }

    public static H2F randomGausian2D(int bins, double min, double max, int stat, double mean, double sigma) {
        H2F h = new H2F("RandomGaus", bins, min, max, bins, min, max);
        for (int i = 0; i < stat; ++i) {
            double x = FunctionFactory.getRandMinMax(min, max);
            double y = FunctionFactory.getRandMinMax(min, max);
            double xw = FunctionFactory.gauss(x, mean, sigma);
            double yw = FunctionFactory.gauss(y, mean, sigma);
            h.fill(x, y, xw + yw);
        }
        return h;
    }

    public static H1F createDebugH1F(int bins) {
        H1F h1 = new H1F("h1", "Debug Histogram", bins, 0.5, (double)bins + 0.5);
        for (int i = 0; i < bins; ++i) {
            h1.setBinContent(i, i + 1);
        }
        return h1;
    }

    public static H1F createH1F(int type, int bins, int samples) {
        Func1D func = FunctionFactory.createFunction(type);
        H1F h = new H1F("RandomH1F", bins, 0.1, 5.0);
        RandomFunc random = new RandomFunc(func);
        for (int i = 0; i < samples; ++i) {
            double r = random.random();
            h.fill(r);
        }
        return h;
    }

    public static Func1D createFunction(int type) {
        if (type == 0) {
            F1D func3 = new F1D("func3", "[p0]+[p1]*x+[amp]*gaus(x,[mean],[sigma])", 0.0, 5.4);
            func3.setParameters(new double[]{15.0, 5.0, 120.0, 2.4, 0.45});
            return func3;
        }
        if (type == 1) {
            F1D func3 = new F1D("func3", "[p0]+[p1]*x+[amp]*gaus(x,[mean],[sigma])+[amp2]*gaus(x,[mean2],[sigma2])", 0.0, 5.4);
            func3.setParameters(new double[]{15.0, 5.0, 120.0, 1.8, 0.25, 80.0, 3.2, 0.45});
            return func3;
        }
        return null;
    }

    public static void main(String[] args) {
        int n_iter = 1000;
        Long start_time = System.currentTimeMillis();
        for (int i = 0; i < n_iter; ++i) {
            double num = Math.random() * 2.0 - 1.0;
            double num2 = Math.random() * 2.0 - 1.0;
            double d = Math.atan2(num, num2);
        }
        Long end_time = System.currentTimeMillis();
        double time = (double)(end_time - start_time) / (double)n_iter;
        System.out.println(String.format("Math  :   %9.5f msec/call", time * 1000.0));
        start_time = System.currentTimeMillis();
        for (int i = 0; i < n_iter; ++i) {
            double num = Math.random() * 2.0 - 1.0;
            double num2 = Math.random() * 2.0 - 1.0;
            double d = FunctionFactory.atan2(num, num2);
        }
        end_time = System.currentTimeMillis();
        double timeF = (double)(end_time - start_time) / (double)n_iter;
        System.out.println(String.format("Func  :   %9.5f msec/call", timeF * 1000.0));
        System.out.println(String.format("Speed :   %9.5f", time / timeF));
        double divergence = 0.0;
        for (int i = 0; i < n_iter; ++i) {
            double num = Math.random() * 2.0 - 1.0;
            double acosF = FunctionFactory.atan(num);
            double acosM = Math.atan(num);
            divergence += Math.abs(acosF - acosM);
        }
        System.out.println(String.format("Divergence : %.8f", divergence));
    }
}

