/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import org.jlab.groot.base.DatasetAttributes;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.math.Dimension1D;
import org.jlab.groot.math.UserParameter;
import org.jlab.groot.math.UserParameters;
import org.jlab.groot.ui.PaveText;

public class Func1D
implements IDataSet {
    UserParameters userPars = new UserParameters();
    String funcName = "f1d";
    private int defaultDrawingPoints = 250;
    private Dimension1D functionRange = new Dimension1D();
    private DatasetAttributes funcAttr = new DatasetAttributes();
    private double funcChi2 = 0.0;
    private int funcNDF = 0;

    public Func1D(String name) {
        this.funcName = name;
        this.initAttributes();
    }

    public Func1D(String name, double min, double max) {
        this.funcName = name;
        this.setRange(min, max);
        this.initAttributes();
    }

    private void initAttributes() {
        try {
            this.funcAttr = GStyle.getFunctionAttributes().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public final void setRange(double min, double max) {
        this.functionRange.setMinMax(min, max);
    }

    public void addParameter(String name) {
        this.userPars.getParameters().add(new UserParameter(name, 0.0));
    }

    public void addParameter(UserParameter par) {
        this.userPars.getParameters().add(par);
    }

    @Override
    public void setName(String name) {
        this.funcName = name;
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    public void setParameters(double[] values) {
        this.userPars.setParameters(values);
    }

    public void setParameter(int i, double value) {
        this.userPars.getParameter(i).setValue(value);
    }

    public UserParameter parameter(int index) {
        return this.userPars.getParameter(index);
    }

    public int getNPars() {
        return this.userPars.getParameters().size();
    }

    public void setParStep(int par, double step) {
        this.parameter(par).setStep(step);
    }

    public void setParLimits(int par, double min, double max) {
        this.userPars.getParameters().get(par).setLimits(min, max);
    }

    public double getParameter(int index) {
        return this.userPars.getParameter(index).value();
    }

    public double evaluate(double x) {
        return 1.0;
    }

    public String getExpression() {
        return "";
    }

    public double getIntegral() {
        int nsamples = 400;
        double step = this.getRange().getLength() / (double)nsamples;
        double integral = 0.0;
        for (int i = 0; i < nsamples; ++i) {
            double x = this.getRange().getMin() + (double)i * step;
            integral += this.evaluate(x) * step;
        }
        return integral;
    }

    public Dimension1D getRange() {
        return this.functionRange;
    }

    public double getMin() {
        return this.functionRange.getMin();
    }

    public double getMax() {
        return this.functionRange.getMax();
    }

    public void show() {
        System.out.println(this.userPars.toString());
    }

    @Override
    public int getDataSize(int axis) {
        return this.defaultDrawingPoints;
    }

    @Override
    public DatasetAttributes getAttributes() {
        return this.funcAttr;
    }

    @Override
    public double getDataX(int bin) {
        double length = this.functionRange.getLength();
        double fraction = (double)bin / (double)this.defaultDrawingPoints;
        return this.functionRange.getMin() + fraction * length;
    }

    @Override
    public double getDataY(int bin) {
        double x = this.getDataX(bin);
        return this.evaluate(x);
    }

    @Override
    public double getDataEX(int bin) {
        return 0.0;
    }

    @Override
    public double getDataEY(int bin) {
        return 0.0;
    }

    @Override
    public double getData(int xbin, int ybin) {
        return 0.0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("FUNCTION (%s) RANGE %9.4f %9.4f (exp:%s)\n", this.getName(), this.getMin(), this.getMax(), this.getExpression()));
        str.append("-----\n");
        str.append(this.userPars.toString());
        return str.toString();
    }

    public int getLineColor() {
        return this.funcAttr.getLineColor();
    }

    public int getLineWidth() {
        return this.funcAttr.getLineWidth();
    }

    public int getLineStyle() {
        return this.funcAttr.getLineStyle();
    }

    public void setLineColor(int color) {
        this.funcAttr.setLineColor(color);
    }

    public void setLineWidth(int width) {
        this.funcAttr.setLineWidth(width);
    }

    public void setLineStyle(int style) {
        this.funcAttr.setLineStyle(style);
    }

    public double getChiSquare() {
        return this.funcChi2;
    }

    public int getNDF() {
        return this.funcNDF;
    }

    public void setChiSquare(double chi2) {
        this.funcChi2 = chi2;
    }

    public void setNDF(int ndf) {
        this.funcNDF = ndf;
    }

    @Override
    public PaveText getStatBox() {
        PaveText stat = new PaveText(2);
        stat.addText("Name:", this.getName());
        for (UserParameter par : this.userPars.getParameters()) {
            stat.addText(par.name(), String.format("%.3f", par.value()));
        }
        stat.addText("#chi^2/ndf", String.format("%.3f", this.getChiSquare() / (double)this.getNDF()));
        stat.addText("#chi^2", String.format("%.3f", this.getChiSquare()));
        stat.addText("ndf", String.format("%.3f", this.getNDF()));
        return stat;
    }

    public void setOptStat(int optStatString) {
        this.getAttributes().setOptStat("" + optStatString);
    }

    public void setOptStat(String optStatString) {
        this.getAttributes().setOptStat(optStatString);
    }

    public String getOptStat() {
        return this.getAttributes().getOptStat();
    }

    public void estimateParameters() {
    }

    public double[] getParameterEstimate() {
        return null;
    }

    @Override
    public void reset() {
    }
}

