/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataGroupDescriptor {
    private int numberOfColumns = 1;
    private int numberOfRows = 1;
    private String groupName = "";
    private Map<Integer, List<String>> groupContent = new LinkedHashMap<Integer, List<String>>();

    public DataGroupDescriptor(String name, int cols, int rows) {
        this.groupName = name;
        this.numberOfColumns = cols;
        this.numberOfRows = rows;
    }

    public String getName() {
        return this.groupName;
    }

    public int getCols() {
        return this.numberOfColumns;
    }

    public int getRows() {
        return this.numberOfRows;
    }

    public void add(int order, String link) {
        if (!this.groupContent.containsKey(order)) {
            this.groupContent.put(order, new ArrayList());
        }
        this.groupContent.get(order).add(link);
    }

    public List<String> getList(int order) {
        if (!this.groupContent.containsKey(order)) {
            return new ArrayList<String>();
        }
        return this.groupContent.get(order);
    }

    public void addEncoded(int order, String encodedString) {
        String[] tokens = encodedString.split(":");
        List<String> elements = Arrays.asList(tokens);
        this.groupContent.put(order, elements);
    }

    public String getEncodedString(int order) {
        if (!this.groupContent.containsKey(order)) {
            return "";
        }
        List<String> elements = this.groupContent.get(order);
        StringBuilder str = new StringBuilder();
        int icounter = 0;
        for (String item : elements) {
            if (icounter != 0) {
                str.append(":");
            }
            str.append(item);
            ++icounter;
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getName());
        str.append("\n");
        boolean icounter = false;
        for (Map.Entry<Integer, List<String>> entry : this.groupContent.entrySet()) {
            str.append(String.format("\t --> %5d\n", entry.getKey()));
            for (int i = 0; i < entry.getValue().size(); ++i) {
                str.append(String.format("\t\t ==> %5d : %s\n", i, entry.getValue().get(i)));
            }
        }
        return str.toString();
    }
}

