/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.base.AxisAttributes;
import org.jlab.groot.base.ColorPalette;
import org.jlab.groot.base.FontProperties;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.math.Dimension1D;
import org.jlab.groot.ui.LatexText;

public class GraphicsAxis {
    private AxisAttributes attr = new AxisAttributes(1);
    public static int AXISTYPE_COLOR = 1;
    public static int AXISTYPE_HORIZONTAL = 2;
    public static int AXISTYPE_VERTICAL = 3;
    private int axisType = 2;
    private int numberOfMajorTicks = 10;
    private Boolean isLogarithmic = false;
    private Boolean isVertical = false;
    private Boolean isColorAxis = false;
    private final GraphicsAxisTicks axisTicks = new GraphicsAxisTicks();

    public GraphicsAxis(int AXISTYPE) {
        this.axisType = AXISTYPE;
        if (this.axisType == AXISTYPE_COLOR) {
            this.isVertical = true;
            this.isColorAxis = true;
        }
        if (this.axisType == AXISTYPE_VERTICAL) {
            this.isVertical = true;
        }
        this.setDimension(0, 100);
        this.setRange(0.0, 1.0);
        this.initAttributes();
    }

    private void initAttributes() {
        if (this.axisType == AXISTYPE_HORIZONTAL) {
            try {
                this.attr = GStyle.getAxisAttributesX().clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else if (this.axisType == AXISTYPE_VERTICAL) {
            try {
                this.attr = GStyle.getAxisAttributesY().clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else if (this.axisType == AXISTYPE_COLOR) {
            try {
                this.attr = GStyle.getAxisAttributesZ().clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public final GraphicsAxis setDimension(int xmin, int xmax) {
        this.attr.getAxisDimension().setMinMax(xmin, xmax);
        return this;
    }

    public void setAxisType(int type) {
        if (type == AXISTYPE_COLOR) {
            this.isVertical = true;
            this.isColorAxis = true;
        }
    }

    public Dimension1D getDimension() {
        return this.attr.getAxisDimension();
    }

    public final GraphicsAxis setRange(double min, double max) {
        this.attr.setAxisAutoScale(false);
        this.attr.setAxisMinimum(min);
        this.attr.setAxisMaximum(max);
        if (this.getAttributes().isLog()) {
            List<Double> list = this.attr.getRange().getDimensionTicksLog(this.numberOfMajorTicks);
        } else {
            List<Double> ticks = this.attr.getRange().getDimensionTicks(this.numberOfMajorTicks);
            this.axisTicks.init(ticks);
        }
        return this;
    }

    public void setTitle(String title) {
        this.attr.setAxisTitleString(title);
    }

    public boolean getLog() {
        return this.getAttributes().isLog();
    }

    public void setLog(boolean flag) {
        this.getAttributes().setLog(flag);
    }

    public Dimension1D getRange() {
        return this.attr.getRange();
    }

    public void show() {
        System.out.println(this.toString());
    }

    public double getAxisPosition(double value) {
        double fraction = this.attr.getRange().getFraction(value);
        if (this.attr.getAxisDimension().getMin() < this.attr.getAxisDimension().getMax()) {
            return this.attr.getAxisDimension().getPoint(fraction);
        }
        if (this.getLog()) {
            double axisMinimum = this.getDimension().getMin();
            if (axisMinimum < 1.0E-20) {
                axisMinimum = 1.0E-20;
            }
            if (fraction > 1.0E-20) {
                return this.attr.getAxisDimension().getMin() - fraction * Math.abs(this.attr.getAxisDimension().getMax() - this.attr.getAxisDimension().getMin());
            }
            return axisMinimum;
        }
        return this.attr.getAxisDimension().getMin() - fraction * Math.abs(this.attr.getAxisDimension().getMax() - this.attr.getAxisDimension().getMin());
    }

    public FontProperties getTitleFont() {
        return this.attr.getTitleFont();
    }

    public FontProperties getLabelFont() {
        return this.attr.getLabelFont();
    }

    public void setAxisFont(String fontname) {
        this.attr.setLabelFontName(fontname);
        this.axisTicks.updateFont(this.getLabelFont());
    }

    public void setAxisFontSize(int size) {
        this.attr.setLabelFontSize(size);
        this.axisTicks.updateFont(this.getLabelFont());
    }

    public int getSize(Graphics2D g2d, boolean vertical) {
        if (vertical) {
            // empty if block
        }
        return 0;
    }

    public int getAxisDivisions() {
        return this.numberOfMajorTicks;
    }

    public void setVertical(boolean flag) {
        this.isVertical = true;
    }

    public void setAxisDivisions(int ndiv) {
        this.numberOfMajorTicks = ndiv;
    }

    public List<Double> getAxisTicks() {
        return null;
    }

    public int getAxisBounds(Graphics2D g2d) {
        double axisBounds = 0.0;
        this.axisTicks.updateFont(this.getLabelFont());
        List<LatexText> axisTexts = this.axisTicks.getAxisTexts();
        double maxW = 0.0;
        double maxH = 0.0;
        for (LatexText text : axisTexts) {
            Rectangle2D bounds = text.getBoundsNumber(g2d);
            if (bounds.getWidth() > maxW) {
                maxW = bounds.getWidth();
            }
            if (!(bounds.getHeight() > maxH)) continue;
            maxH = bounds.getHeight();
        }
        axisBounds = this.isVertical == true ? maxW + (double)this.attr.getLabelOffset() : maxH + (double)this.attr.getLabelOffset();
        if (this.attr.getTitle().getTextString().length() > 1) {
            Rectangle2D rect = this.attr.getTitle().getBounds(g2d);
            axisBounds += rect.getHeight() + (double)this.attr.getTitleOffset();
        }
        return (int)axisBounds;
    }

    public void drawAxisGrid(Graphics2D g2d, int x, int y, int height) {
        if (this.isColorAxis.booleanValue()) {
            return;
        }
        g2d.setColor(new Color(200, 200, 200));
        g2d.setStroke(GStyle.getStroke(2));
        if (!this.isVertical.booleanValue()) {
            List<Double> ticks = this.axisTicks.getAxisTicks();
            for (double tick : ticks) {
                int xtick = (int)this.getAxisPosition(tick);
                g2d.drawLine(xtick, y, xtick, y - height);
            }
        } else {
            List<Double> ticks = this.axisTicks.getAxisTicks();
            for (double tick : ticks) {
                int ytick = (int)this.getAxisPosition(tick);
                g2d.drawLine(x, ytick, x + height, ytick);
            }
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(1.0f));
    }

    public void drawAxisMirror(Graphics2D g2d, int x, int y, int height) {
        if (this.isColorAxis.booleanValue()) {
            return;
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(1.0f));
        if (!this.isVertical.booleanValue()) {
            List<Double> ticks = this.axisTicks.getAxisTicks();
            for (double tick : ticks) {
                int xtick = (int)this.getAxisPosition(tick);
                g2d.drawLine(xtick, y - height, xtick, y - height + this.getAttributes().getTickSize());
            }
        } else {
            List<Double> ticks = this.axisTicks.getAxisTicks();
            for (double tick : ticks) {
                int ytick = (int)this.getAxisPosition(tick);
                g2d.drawLine(x + height - this.getAttributes().getTickSize(), ytick, x + height, ytick);
            }
        }
    }

    public void drawAxis(Graphics2D g2d, int x, int y) {
        this.drawAxis(g2d, x, y, 0);
    }

    public void drawAxis(Graphics2D g2d, int x, int y, int height) {
        if (this.isColorAxis.booleanValue()) {
            this.drawColorAxis(g2d, x, y);
            return;
        }
        g2d.setColor(Color.BLACK);
        this.setAxisDivisions(10);
        this.axisTicks.updateFont(this.getLabelFont());
        this.updateAxisDivisions(g2d);
        if (height > 5) {
            this.drawAxisMirror(g2d, x, y, height);
            if (this.getAttributes().getGrid()) {
                this.drawAxisGrid(g2d, x, y, height);
            }
        }
        List<Double> ticks = this.axisTicks.getAxisTicks();
        List<LatexText> texts = this.axisTicks.getAxisTexts();
        int labelOffset = this.attr.getLabelOffset();
        int titleOffset = this.attr.getTitleOffset();
        int tickLength = this.attr.getTickSize();
        double midpoint = this.getAxisPosition(this.attr.getRange().getMin()) * 0.5 + 0.5 * this.getAxisPosition(this.attr.getRange().getMax());
        if (!this.isVertical.booleanValue()) {
            g2d.drawLine((int)this.attr.getAxisDimension().getMin(), y, (int)this.attr.getAxisDimension().getMax(), y);
            for (int i = 0; i < ticks.size(); ++i) {
                double tick = this.getAxisPosition(ticks.get(i));
                g2d.drawLine((int)tick, y, (int)tick, y - tickLength);
                texts.get(i).drawString(g2d, (int)tick, y + labelOffset, 1, 0);
            }
            int axisBounds = (int)texts.get(0).getBoundsNumber(g2d).getHeight();
            this.attr.getTitle().drawString(g2d, (int)midpoint, y + axisBounds + labelOffset + titleOffset, 1, 0);
        } else {
            g2d.drawLine(x, (int)this.attr.getAxisDimension().getMin(), x, (int)this.attr.getAxisDimension().getMax());
            for (int i = 0; i < ticks.size(); ++i) {
                double tick = this.getAxisPosition(ticks.get(i));
                g2d.drawLine(x, (int)tick, x + tickLength, (int)tick);
                texts.get(i).drawString(g2d, x - labelOffset, (int)tick, 2, 1);
            }
            int axisBounds = (int)texts.get(0).getBoundsNumber(g2d).getWidth();
            for (int i = 0; i < texts.size(); ++i) {
                if (axisBounds >= (int)texts.get(i).getBoundsNumber(g2d).getWidth()) continue;
                axisBounds = (int)texts.get(i).getBoundsNumber(g2d).getWidth();
            }
            this.attr.getTitle().drawString(g2d, x - axisBounds - labelOffset - titleOffset - 8 - this.attr.getTitleFontSize(), (int)midpoint, LatexText.ALIGN_CENTER, LatexText.ALIGN_TOP, LatexText.ROTATE_LEFT);
        }
    }

    private void drawColorAxis(Graphics2D g2d, int x, int y) {
        int i;
        this.setAxisDivisions(10);
        this.axisTicks.updateFont(this.attr.getLabelFont());
        this.updateAxisDivisions(g2d);
        List<Double> ticks = this.axisTicks.getAxisTicks();
        List<LatexText> texts = this.axisTicks.getAxisTexts();
        g2d.setColor(Color.BLACK);
        g2d.drawLine(x, (int)this.attr.getAxisDimension().getMin(), x, (int)this.attr.getAxisDimension().getMax());
        int xstart = x + 4 + 8;
        int ncolors = ColorPalette.getColorPallete3DSize();
        double height = Math.abs(this.attr.getAxisDimension().getLength());
        int tickSize = this.attr.getTickSize() / 2;
        for (i = 0; i < ncolors; ++i) {
            g2d.setColor(ColorPalette.getColorPalette3D(i));
            int yp = (int)((double)i * height / (double)ncolors);
            int offset = (int)((double)(i + 1) * height / (double)ncolors);
            int length = offset - yp;
            g2d.fillRect(x + 4, y - offset, 8, length);
        }
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x + 4, (int)this.attr.getAxisDimension().getMax(), 8, (int)Math.abs(this.attr.getAxisDimension().getLength()));
        for (i = 0; i < ticks.size(); ++i) {
            double tick = this.getAxisPosition(ticks.get(i));
            g2d.drawLine(xstart, (int)tick, xstart + tickSize, (int)tick);
            texts.get(i).drawString(g2d, xstart + tickSize + this.attr.getLabelOffset(), (int)tick, 0, 1);
        }
    }

    private void updateAxisDivisions(Graphics2D g2d) {
        List<Double> ticks = this.getLog() ? this.attr.getRange().getDimensionTicksLog(this.numberOfMajorTicks) : this.attr.getRange().getDimensionTicks(this.numberOfMajorTicks);
        this.axisTicks.init(ticks);
        this.axisTicks.updateFont(this.getLabelFont());
        double heights = 0.0;
        heights = this.isVertical == true ? this.axisTicks.getTextsHeight(g2d) : this.axisTicks.getTextsWidth(g2d);
        double axisLength = this.attr.getAxisDimension().getLength();
        double fraction = heights / axisLength;
        if (fraction > 0.6) {
            int nticks = this.numberOfMajorTicks;
            while (fraction > 0.6 && nticks > 2) {
                ticks = this.getLog() ? this.attr.getRange().getDimensionTicksLog(nticks) : this.attr.getRange().getDimensionTicks(--nticks);
                this.axisTicks.init(ticks);
                heights = this.isVertical == true ? this.axisTicks.getTextsHeight(g2d) : this.axisTicks.getTextsWidth(g2d);
                fraction = heights / axisLength;
            }
            this.numberOfMajorTicks = nticks;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Axis : ");
        str.append(" LOG = ");
        str.append(this.isLogarithmic);
        str.append(String.format("  (%4d x %4d ) : ->  ", (int)this.attr.getAxisDimension().getMin(), (int)this.attr.getAxisDimension().getMax()));
        return str.toString();
    }

    public static void main(String[] args) {
        GraphicsAxis axis = new GraphicsAxis(AXISTYPE_HORIZONTAL);
        axis.setDimension(20, 100);
        axis.setRange(0.0, 120.0);
        axis.show();
        for (double d = 0.0; d < 120.0; d += 0.5) {
            System.out.println(d + " fraction = " + axis.getAxisPosition(d));
        }
    }

    public boolean isAutoScale() {
        return this.attr.isAxisAutoScale();
    }

    public void setAutoScale(boolean b) {
        this.attr.setAxisAutoScale(b);
    }

    public AxisAttributes getAttributes() {
        return this.attr;
    }

    public void setAttributes(AxisAttributes attr) {
        this.attr = attr;
    }

    public boolean getGrid() {
        return this.attr.getGrid();
    }

    public void setGrid(boolean isGrid) {
        this.attr.setGrid(isGrid);
    }

    public String getTitle() {
        return this.attr.getAxisTitleString();
    }

    public int getTitleFontSize() {
        return this.attr.getTitleFontSize();
    }

    public int getLabelFontSize() {
        return this.attr.getLabelFontSize();
    }

    public double getMin() {
        return this.attr.getAxisMinimum();
    }

    public double getMax() {
        return this.attr.getAxisMaximum();
    }

    public void setShowAxis(boolean b) {
        this.attr.setShowAxis(b);
    }

    public boolean isShowAxis() {
        return this.attr.showAxis();
    }

    public static class GraphicsAxisTicks {
        List<LatexText> axisTexts = new ArrayList<LatexText>();
        List<Double> axisTicks = new ArrayList<Double>();
        FontProperties axisFontProperty = new FontProperties();

        void GraphicsAxisString() {
        }

        public List<Double> getAxisTicks() {
            return this.axisTicks;
        }

        public List<LatexText> getAxisTexts() {
            return this.axisTexts;
        }

        public void updateFont(FontProperties fp) {
            this.axisFontProperty.setFontName(fp.getFontName());
            this.axisFontProperty.setFontSize(fp.getFontSize());
        }

        public double getTextsWidth(Graphics2D g2d) {
            double width = 0.0;
            for (LatexText text : this.axisTexts) {
                Rectangle2D rect = text.getBoundsNumber(g2d);
                width += rect.getWidth();
            }
            return width;
        }

        public double getTextsHeight(Graphics2D g2d) {
            double width = 0.0;
            for (LatexText text : this.axisTexts) {
                Rectangle2D rect = text.getBoundsNumber(g2d);
                width += rect.getHeight();
            }
            return width;
        }

        public void init(List<Double> ticks) {
            int i;
            this.axisTexts.clear();
            this.axisTicks.clear();
            int significantFigures = this.getSignificantFigures(ticks);
            if (significantFigures < 0) {
                significantFigures = -1;
            }
            for (i = 0; i < ticks.size(); ++i) {
                this.axisTicks.add(ticks.get(i));
            }
            for (i = 0; i < this.axisTicks.size(); ++i) {
                LatexText text = LatexText.createFromDouble(this.axisTicks.get(i), significantFigures + 1);
                text.setFont(this.axisFontProperty.getFontName());
                text.setFontSize(this.axisFontProperty.getFontSize());
                this.axisTexts.add(text);
            }
        }

        public int getSignificantFigures(List<Double> array) {
            if (array.size() < 2) {
                return 0;
            }
            double min = array.get(0);
            double max = array.get(array.size() - 1);
            double difference = max - min;
            int placeOfDifference = (int)Math.floor(Math.log(difference) / Math.log(10.0));
            return -placeOfDifference;
        }
    }
}

