/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.tree.Tree;

public class EmbeddedCanvasTabbed
extends JPanel
implements ActionListener {
    private JTabbedPane tabbedPane = null;
    private JPanel actionPanel = null;
    private int canvasOrder = 1;
    private int iconSizeX = 25;
    private int iconSizeY = 25;
    private Map<String, EmbeddedCanvas> tabbedCanvases = new LinkedHashMap<String, EmbeddedCanvas>();
    private int isDynamic = 0;

    public EmbeddedCanvasTabbed() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 200));
        this.setSize(400, 500);
        this.initUI();
        this.initBottomBar();
        this.addCanvas();
    }

    public EmbeddedCanvasTabbed(boolean isStatic) {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 200));
        this.setSize(400, 500);
        this.initUI();
        if (!isStatic) {
            this.initBottomBar();
        }
    }

    public EmbeddedCanvasTabbed(String ... canvases) {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 200));
        this.setSize(400, 500);
        this.initUI();
        for (String canvas : canvases) {
            this.addCanvas(canvas);
        }
    }

    private void initUI() {
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
    }

    private void initBottomBar() {
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new FlowLayout());
        this.add((Component)this.actionPanel, "Last");
        ImageIcon newTabIcon = new ImageIcon();
        ImageIcon removeTabIcon = new ImageIcon();
        ImageIcon editTabIcon = new ImageIcon();
        ImageIcon clearTabIcon = new ImageIcon();
        try {
            BufferedImage addImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/canvas_add.png"));
            BufferedImage clearImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/1477453861_star_full.png"));
            BufferedImage deleteImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/canvas_delete.png"));
            BufferedImage editImage = ImageIO.read(Tree.class.getClassLoader().getResource("icons/tree/1477454132_calendar.png"));
            newTabIcon.setImage(addImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            clearTabIcon.setImage(clearImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            editTabIcon.setImage(editImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
            removeTabIcon.setImage(deleteImage.getScaledInstance(this.iconSizeX, this.iconSizeY, 4));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JButton buttonAdd = new JButton(newTabIcon);
        buttonAdd.setActionCommand("add canvas");
        buttonAdd.addActionListener(this);
        JButton buttonRemove = new JButton(removeTabIcon);
        buttonRemove.setActionCommand("remove canvas");
        buttonRemove.addActionListener(this);
        JButton buttonDivide = new JButton(editTabIcon);
        buttonDivide.setActionCommand("divide");
        buttonDivide.addActionListener(this);
        JButton buttonClear = new JButton(clearTabIcon);
        buttonClear.setActionCommand("clear");
        buttonClear.addActionListener(this);
        this.actionPanel.add(buttonAdd);
        this.actionPanel.add(buttonRemove);
        this.actionPanel.add(buttonDivide);
        this.actionPanel.add(buttonClear);
    }

    public EmbeddedCanvas getCanvas() {
        int index = this.tabbedPane.getSelectedIndex();
        String title = this.tabbedPane.getTitleAt(index);
        return this.tabbedCanvases.get(title);
    }

    public EmbeddedCanvas getCanvas(String title) {
        return this.tabbedCanvases.get(title);
    }

    public final void addCanvas() {
        String name = "canvas" + this.canvasOrder;
        ++this.canvasOrder;
        this.addCanvas(name);
    }

    public final void addCanvas(String name) {
        EmbeddedCanvas canvas = new EmbeddedCanvas();
        this.tabbedCanvases.put(name, canvas);
        this.tabbedPane.addTab(name, canvas);
        this.tabbedPane.setSelectedComponent(canvas);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("add canvas") == 0) {
            this.addCanvas();
        }
        if (e.getActionCommand().compareTo("remove canvas") == 0 && JOptionPane.showConfirmDialog(this, "Are you sure to remove current canvas ?", "Really Removing?", 0, 3) == 0) {
            int index = this.tabbedPane.getSelectedIndex();
            String title = this.tabbedPane.getTitleAt(index);
            this.tabbedPane.remove(index);
            this.tabbedCanvases.remove(title);
        }
        if (e.getActionCommand().compareTo("divide") == 0) {
            String[] options = new String[]{"1", "2", "3", "4", "5", "6", "7"};
            JComboBox<String> columns = new JComboBox<String>(options);
            JComboBox<String> rows = new JComboBox<String>(options);
            columns.setSelectedIndex(this.getCanvas().getNColumns() - 1);
            rows.setSelectedIndex(this.getCanvas().getNRows() - 1);
            Object[] message = new Object[]{"Columns:", columns, "Rows:", rows};
            int option = JOptionPane.showConfirmDialog(this, message, "Divide Canvas", 2);
            if (option == 0) {
                String stringCOLS = (String)columns.getSelectedItem();
                String stringROWS = (String)rows.getSelectedItem();
                this.getCanvas().divide(Integer.parseInt(stringCOLS), Integer.parseInt(stringROWS));
            }
        }
        if (e.getActionCommand().compareTo("clear") == 0) {
            this.getCanvas().clear();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        EmbeddedCanvasTabbed canvasTab = new EmbeddedCanvasTabbed("TDC", "ADC", "VALUES");
        frame.add(canvasTab);
        frame.pack();
        frame.setMinimumSize(new Dimension(300, 300));
        frame.setVisible(true);
    }
}

