/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.base.PadMargins;
import org.jlab.groot.data.DataParser;
import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.H2F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.fitter.ParallelSliceFitter;
import org.jlab.groot.graphics.EmbeddedPad;
import org.jlab.groot.graphics.Histogram2DPlotter;
import org.jlab.groot.graphics.HistogramPlotter;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.group.DataGroup;
import org.jlab.groot.math.Dimension1D;
import org.jlab.groot.math.FunctionFactory;
import org.jlab.groot.ui.FitPanel;
import org.jlab.groot.ui.OptionsPanel;
import org.jlab.groot.ui.TransferableImage;

public class EmbeddedCanvas
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    IDataSet selectedDataset = null;
    private Timer updateTimer = null;
    private Long numberOfPaints = 0L;
    private Long paintingTime = 0L;
    private Long paintingTimeSum = 0L;
    private Long samples = 0L;
    private JPopupMenu popup = null;
    private int popupPad = 0;
    private List<EmbeddedPad> canvasPads = new ArrayList<EmbeddedPad>();
    private int ec_COLUMNS = 1;
    private int ec_ROWS = 1;
    private int activePad = 0;
    private boolean isChild = false;
    private boolean showFPS = false;
    private int fitSlicesMode = 0;
    int fillcolortemp = 1;

    public List<EmbeddedPad> getCanvasPads() {
        return this.canvasPads;
    }

    public void setCanvasPads(List<EmbeddedPad> canvasPads) {
        this.canvasPads = canvasPads;
    }

    public EmbeddedCanvas() {
        this.setPreferredSize(new Dimension(500, 400));
        this.canvasPads.add(new EmbeddedPad());
        this.divide(1, 1);
        this.createPopupMenu();
        this.initMouse();
    }

    public EmbeddedCanvas(EmbeddedPad pad) {
        this.setPreferredSize(new Dimension(500, 400));
        this.createPopupMenu();
    }

    public final void initMouse() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public final void divide(int columns, int rows) {
        int i;
        this.ec_COLUMNS = columns;
        this.ec_ROWS = rows;
        for (i = 0; i < columns * rows; ++i) {
            if (i <= this.canvasPads.size() - 1) continue;
            this.canvasPads.add(new EmbeddedPad());
        }
        if (this.canvasPads.size() > columns * rows) {
            for (i = this.canvasPads.size() - 1; i >= columns * rows; --i) {
                this.canvasPads.remove(i);
            }
        }
        this.update();
        for (i = 0; i < this.canvasPads.size(); ++i) {
            if (this.canvasPads.get(i).getDatasetPlotters().size() == 0) {
                this.cd(i);
                break;
            }
            if (i != this.canvasPads.size() - 1) continue;
            this.cd(0);
        }
    }

    public void cd(int pad) {
        this.activePad = pad < 0 ? 0 : (pad >= this.canvasPads.size() ? 0 : pad);
    }

    public void clear() {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.clear();
        }
        this.cd(0);
        this.update();
    }

    public Map<String, IDataSet> getObjectMap() {
        LinkedHashMap<String, IDataSet> canvasObjects = new LinkedHashMap<String, IDataSet>();
        for (int i = 0; i < this.canvasPads.size(); ++i) {
            Map<String, IDataSet> objects = this.canvasPads.get(i).getObjectMap();
            for (Map.Entry<String, IDataSet> entry : objects.entrySet()) {
                canvasObjects.put(entry.getKey(), entry.getValue());
            }
        }
        return canvasObjects;
    }

    public void drawNext(IDataSet ds) {
        this.draw(ds, "");
        this.cd(this.activePad + 1);
    }

    public void draw(IDataSet ds) {
        this.draw(ds, "");
    }

    public void draw(IDataSet ds, String options) {
        this.getPad(this.activePad).draw(ds, options);
    }

    private void updateCanvasPads(int w, int h) {
        int pcounter = 0;
        int startX = 5;
        int minY = 5;
        int rW = w - startX;
        int rH = h - minY;
        for (int ir = 0; ir < this.ec_ROWS; ++ir) {
            for (int ic = 0; ic < this.ec_COLUMNS; ++ic) {
                double x = (double)ic * ((double)rW / (double)this.ec_COLUMNS);
                double xe = (double)(ic + 1) * ((double)rW / (double)this.ec_COLUMNS);
                double y = (double)ir * ((double)rH / (double)this.ec_ROWS);
                double ye = (double)(ir + 1) * ((double)rH / (double)this.ec_ROWS);
                this.canvasPads.get(pcounter).setDimension((int)x + startX, (int)y - minY, (int)(xe - x), (int)(ye - y));
                ++pcounter;
            }
        }
    }

    public int getNColumns() {
        return this.ec_COLUMNS;
    }

    public int getNRows() {
        return this.ec_ROWS;
    }

    @Override
    public void paint(Graphics g) {
        try {
            EmbeddedPad pad;
            int i;
            Long st = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getSize().width;
            int h = this.getSize().height;
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, w, h);
            this.updateCanvasPads(w, h);
            PadMargins margins = new PadMargins();
            for (i = 0; i < this.canvasPads.size(); ++i) {
                pad = this.canvasPads.get(i);
                pad.getAxisFrame().updateMargins(g2d);
                margins.marginFit(pad.getAxisFrame().getFrameMargins());
            }
            for (i = 0; i < this.canvasPads.size(); ++i) {
                pad = this.canvasPads.get(i);
                pad.getAxisFrame().setAxisMargins(margins);
                pad.setMargins(margins);
                margins.marginFit(pad.getAxisFrame().getFrameMargins());
            }
            for (i = 0; i < this.canvasPads.size(); ++i) {
                pad = this.canvasPads.get(i);
                pad.getAxisFrame().setAxisMargins(margins);
                pad.setMargins(margins);
                pad.draw(g2d);
            }
            Long et = System.currentTimeMillis();
            Long paintingTime = et - st;
            this.paintingTimeSum = this.paintingTimeSum + paintingTime;
            Long l = this.samples;
            Long l2 = this.samples = Long.valueOf(this.samples + 1L);
            double average = (double)this.paintingTimeSum.longValue() / (double)this.samples.longValue();
            if (this.showFPS) {
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, 70, 32);
                g2d.setColor(Color.BLACK);
                g2d.drawRect(0, 0, 70, 32);
                g2d.setColor(Color.BLUE);
                g2d.drawString(String.format("%d FPS", (int)(1.0 / ((double)paintingTime.longValue() / 1000.0))), 5, 14);
                g2d.drawString(String.format("%4.2f Avg", 1.0 / (average / 1000.0)), 5, 28);
            }
            paintingTime = paintingTime + paintingTime;
            Long l3 = this.numberOfPaints;
            Long l4 = this.numberOfPaints = Long.valueOf(this.numberOfPaints + 1L);
        }
        catch (Exception e) {
            System.out.println("[EmbeddedCanvas] ---> ooops");
            System.out.println(e);
        }
    }

    public EmbeddedPad getPad(int index) {
        return this.canvasPads.get(index);
    }

    public EmbeddedPad getPad() {
        return this.canvasPads.get(this.activePad);
    }

    public void update() {
        this.repaint();
    }

    public String getBenchmarkString() {
        StringBuilder str = new StringBuilder();
        double time = this.paintingTime.longValue();
        double ms = time / (double)this.numberOfPaints.longValue();
        if (this.numberOfPaints == 0L) {
            ms = 1000.0;
        }
        str.append(String.format("Time = %.2f ms Total Time = %d , Events = %d", ms, this.paintingTime, this.numberOfPaints));
        return str.toString();
    }

    public void setAxisFontSize(int size) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setAxisFontSize(size);
        }
    }

    public void showFPS(boolean benchmark) {
        this.showFPS = benchmark;
    }

    public void initTimer(int interval) {
        System.out.println("[EmbeddedCanvas] ---->  starting an update timer.");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                EmbeddedCanvas.this.update();
            }
        };
        this.updateTimer = new Timer("EmbeddeCanvasTimer");
        this.updateTimer.scheduleAtFixedRate(timerTask, 30L, (long)interval);
        this.paintingTime = 0L;
        this.numberOfPaints = 0L;
    }

    public int getPadByXY(int x, int y) {
        int rowSize = this.getHeight() / this.ec_ROWS;
        int row = y / rowSize;
        int colSize = this.getWidth() / this.ec_COLUMNS;
        int col = x / colSize;
        return row * this.ec_COLUMNS + col;
    }

    public void draw(DataGroup group) {
        int nrows = group.getRows();
        int ncols = group.getColumns();
        this.divide(ncols, nrows);
        int nds = nrows * ncols;
        for (int i = 0; i < nds; ++i) {
            List<IDataSet> dsList = group.getData(i);
            this.cd(i);
            for (IDataSet ds : dsList) {
                this.draw(ds, "same");
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EmbeddedCanvas.this.repaint();
            }
        });
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && !this.isChild) {
            int pad = this.getPadByXY(e.getX(), e.getY());
            double scale = 1.5;
            JFrame popoutFrame = new JFrame();
            EmbeddedCanvas can = new EmbeddedCanvas();
            EmbeddedPad embeddedPad = this.getPad(pad).getCopy();
            can.showFPS(this.showFPS);
            int xSize = this.getPad(pad).getWidth();
            int ySize = this.getPad(pad).getHeight();
            can.setPreferredSize(new Dimension((int)((double)xSize * scale), (int)((double)ySize * scale)));
            can.setChild(true);
            ArrayList<EmbeddedPad> pads = new ArrayList<EmbeddedPad>();
            pads.add(embeddedPad);
            can.canvasPads = pads;
            popoutFrame.setContentPane(can);
            popoutFrame.pack();
            popoutFrame.setLocation(new Point(e.getX(), e.getY()));
            popoutFrame.setVisible(true);
        }
        if (e.getClickCount() == 1 && e.getButton() == 1) {
            if (this.selectedDataset != null) {
                this.selectedDataset.getAttributes().setFillColor(this.fillcolortemp);
                this.repaint();
            }
            this.selectedDataset = null;
            for (EmbeddedPad pad : this.canvasPads) {
                if (!pad.getAxisFrame().getFrameDimensions().contains(e.getX(), e.getY()) || pad.getDatasetPlotters().size() <= 0) continue;
                for (IDataSetPlotter plotter : pad.getDatasetPlotters()) {
                    if (!(plotter instanceof HistogramPlotter)) continue;
                    HistogramPlotter temp = (HistogramPlotter)plotter;
                    if (!temp.path.contains(e.getX(), e.getY())) continue;
                    System.out.println("You clicked on:" + temp.getName());
                    if (this.selectedDataset == temp) continue;
                    if (this.selectedDataset != null) {
                        this.selectedDataset.getAttributes().setFillColor(this.fillcolortemp);
                    }
                    this.fillcolortemp = temp.getDataSet().getAttributes().getFillColor();
                    this.selectedDataset = temp.getDataSet();
                    if (this.fillcolortemp < 10) {
                        temp.getDataSet().getAttributes().setFillColor(this.fillcolortemp + 10);
                    } else {
                        temp.getDataSet().getAttributes().setFillColor(this.fillcolortemp - 10);
                    }
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupPad = this.getPadByXY(e.getX(), e.getY());
            this.createPopupMenu();
            this.popup.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem itemCopy = new JMenuItem("Copy Canvas");
        JMenuItem itemCopyPad = new JMenuItem("Copy Pad");
        JMenuItem itemPaste = new JMenuItem("Paste Pad");
        JMenuItem itemSave = new JMenuItem("Save");
        JMenuItem itemSaveAs = new JMenuItem("Save As...");
        JMenuItem itemFitPanel = new JMenuItem("Fit Panel");
        JMenuItem itemOptions = new JMenuItem("Options");
        JMenuItem itemOpenWindow = new JMenuItem("Open in New Window");
        JMenu itemFitSlices = new JMenu("Fit Slices");
        JMenu itemFitSlicesX = new JMenu("X Axis");
        JMenu itemFitSlicesY = new JMenu("Y Axis");
        itemFitSlices.add(itemFitSlicesX);
        itemFitSlices.add(itemFitSlicesY);
        JMenuItem itemFitSlicesgausx = new JMenuItem("gaus");
        JMenuItem itemFitSlicesgausp0x = new JMenuItem("gaus+p0");
        JMenuItem itemFitSlicesgausp1x = new JMenuItem("gaus+p1");
        JMenuItem itemFitSlicesgausp2x = new JMenuItem("gaus+p2");
        JMenuItem itemFitSlicesgausp3x = new JMenuItem("gaus+p3");
        itemFitSlicesX.add(itemFitSlicesgausx);
        itemFitSlicesX.add(itemFitSlicesgausp0x);
        itemFitSlicesX.add(itemFitSlicesgausp1x);
        itemFitSlicesX.add(itemFitSlicesgausp2x);
        itemFitSlicesX.add(itemFitSlicesgausp3x);
        JMenuItem itemFitSlicesgausy = new JMenuItem("gaus");
        JMenuItem itemFitSlicesgausp0y = new JMenuItem("gaus+p0");
        JMenuItem itemFitSlicesgausp1y = new JMenuItem("gaus+p1");
        JMenuItem itemFitSlicesgausp2y = new JMenuItem("gaus+p2");
        JMenuItem itemFitSlicesgausp3y = new JMenuItem("gaus+p3");
        itemFitSlicesY.add(itemFitSlicesgausy);
        itemFitSlicesY.add(itemFitSlicesgausp0y);
        itemFitSlicesY.add(itemFitSlicesgausp1y);
        itemFitSlicesY.add(itemFitSlicesgausp2y);
        itemFitSlicesY.add(itemFitSlicesgausp3y);
        itemCopy.addActionListener(this);
        itemCopyPad.addActionListener(this);
        itemSave.addActionListener(this);
        itemSaveAs.addActionListener(this);
        itemFitPanel.addActionListener(this);
        itemOptions.addActionListener(this);
        itemOpenWindow.addActionListener(this);
        itemPaste.addActionListener(this);
        itemFitSlicesgausp3x.addActionListener(e -> this.fitSlices(0, 3));
        itemFitSlicesgausp2x.addActionListener(e -> this.fitSlices(0, 2));
        itemFitSlicesgausp1x.addActionListener(e -> this.fitSlices(0, 1));
        itemFitSlicesgausp0x.addActionListener(e -> this.fitSlices(0, 0));
        itemFitSlicesgausx.addActionListener(e -> this.fitSlices(0, -1));
        itemFitSlicesgausp3y.addActionListener(e -> this.fitSlices(1, 3));
        itemFitSlicesgausp2y.addActionListener(e -> this.fitSlices(1, 2));
        itemFitSlicesgausp1y.addActionListener(e -> this.fitSlices(1, 1));
        itemFitSlicesgausp0y.addActionListener(e -> this.fitSlices(1, 0));
        itemFitSlicesgausy.addActionListener(e -> this.fitSlices(1, -1));
        this.popup.add(itemCopyPad);
        this.popup.add(itemPaste);
        this.popup.add(new JSeparator());
        this.popup.add(itemCopy);
        this.popup.add(itemSave);
        this.popup.add(itemSaveAs);
        this.popup.add(new JSeparator());
        this.popup.add(itemFitPanel);
        List<IDataSetPlotter> plotters = this.getPad(this.popupPad).getDatasetPlotters();
        boolean containsH2F = false;
        for (int i = 0; i < plotters.size(); ++i) {
            if (plotters.get(i) instanceof Histogram2DPlotter) {
                containsH2F = true;
            }
            System.out.println(plotters.get(i).getName());
        }
        if (containsH2F) {
            this.popup.add(itemFitSlices);
        }
        this.popup.add(new JSeparator());
        this.popup.add(itemOptions);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String data;
        SimpleDateFormat df;
        System.out.println("action performed " + e.getActionCommand());
        if (e.getActionCommand().compareTo("Options") == 0) {
            this.openOptionsPanel(this.popupPad);
        }
        if (e.getActionCommand().compareTo("Fit Panel") == 0) {
            this.openFitPanel(this.popupPad);
        }
        if (e.getActionCommand().compareTo("Copy Canvas") == 0) {
            this.copyToClipboard();
        }
        if (e.getActionCommand().compareTo("Paste Pad") == 0) {
            this.paste(this.popupPad);
        }
        if (e.getActionCommand().compareTo("Copy Pad") == 0) {
            this.copyToClipboard(this.popupPad);
        }
        if (e.getActionCommand().compareTo("Save") == 0) {
            File desktop = new File(System.getProperty("user.home"), "Desktop");
            df = new SimpleDateFormat("MM-dd-yyyy_hh.mm.ss_aa");
            data = df.format(new Date());
            this.save(desktop.getAbsolutePath() + File.separator + "Plot_" + data + ".png");
            System.out.println("Saved File:" + desktop.getAbsolutePath() + File.separator + "Plot_" + data + ".png");
        }
        if (e.getActionCommand().compareTo("Save As...") == 0) {
            JFileChooser fc = new JFileChooser("Save As...");
            df = new SimpleDateFormat("MM-dd-yyyy_hh.mm.ss_aa");
            data = df.format(new Date());
            fc.setSelectedFile(new File(GStyle.getWorkingDirectory() + File.separator + "Plot_" + data + ".png"));
            FileNameExtensionFilter filter = new FileNameExtensionFilter("PNG File", "png");
            fc.addChoosableFileFilter(filter);
            fc.setFileFilter(filter);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                if (file.exists()) {
                    int result = JOptionPane.showConfirmDialog(this, "File already exists, would you like to overwrite it?", "alert", 2);
                    if (result == 0) {
                        this.save(file.getAbsolutePath());
                        GStyle.setWorkingDirectory(file.getParent());
                    }
                } else {
                    this.save(file.getAbsolutePath());
                    GStyle.setWorkingDirectory(file.getParent());
                }
            }
        }
    }

    private void openFitPanel(int popupPad2) {
        JFrame frame = new JFrame("Fit Panel");
        frame.setLayout(new BorderLayout());
        FitPanel mainPanel = new FitPanel(this, popupPad2);
        frame.add(mainPanel);
        frame.pack();
        frame.setLocationRelativeTo(this);
        frame.setVisible(true);
    }

    private void fitSlices(int axis, int mode) {
        List<IDataSetPlotter> plotters = this.getPad(this.popupPad).getDatasetPlotters();
        H2F histogram = null;
        boolean containsH2F = false;
        for (int i = 0; i < plotters.size(); ++i) {
            if (!(plotters.get(i) instanceof Histogram2DPlotter)) continue;
            histogram = (H2F)plotters.get(i).getDataSet();
        }
        ParallelSliceFitter fitter = new ParallelSliceFitter(histogram);
        Dimension1D range = null;
        if (axis == 0) {
            range = this.getPad(this.popupPad).getAxisY().getRange();
        }
        if (axis == 1) {
            range = this.getPad(this.popupPad).getAxisX().getRange();
        }
        fitter.setRange(range.getMin(), range.getMax());
        fitter.setBackgroundOrder(mode);
        if (axis == 0) {
            fitter.fitSlicesX();
        }
        if (axis == 1) {
            fitter.fitSlicesY();
        }
        fitter.inspectFits();
    }

    private void paste(int popupPad2) {
        DataFlavor dmselFlavor = new DataFlavor(EmbeddedPad.class, "EmbeddedPad");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipboardContent = clipboard.getContents(null);
        DataFlavor[] flavors = clipboardContent.getTransferDataFlavors();
        System.out.println("flavors.length = " + flavors.length);
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i].equals(dmselFlavor)) {
                System.out.println("We have a match!");
                try {
                    EmbeddedPad pad = (EmbeddedPad)clipboardContent.getTransferData(dmselFlavor);
                    for (int j = 0; j < pad.getDatasetPlotters().size(); ++j) {
                        this.getPad(popupPad2).getDatasetPlotters().add(pad.getDatasetPlotters().get(j));
                    }
                    this.update();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
            try {
                String blah = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                DataParser parser = new DataParser(blah);
                this.getPad(popupPad2).draw(parser.getGraphErrors(), "same");
                this.update();
                continue;
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void openOptionsPanel(int popupPad2) {
        JFrame frame = new JFrame("Options Panel");
        frame.setLayout(new BorderLayout());
        OptionsPanel mainPanel = new OptionsPanel(this, popupPad2);
        frame.add(mainPanel);
        frame.pack();
        frame.setLocationRelativeTo(this);
        frame.setVisible(true);
    }

    private BufferedImage getScreenShot() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 7);
        this.paint(bi.getGraphics());
        return bi;
    }

    private BufferedImage getScreenShot(int pad) {
        double scale = 1.0;
        EmbeddedCanvas can = new EmbeddedCanvas();
        EmbeddedPad embeddedPad = this.getPad(pad).getCopy();
        int xSize = this.getPad(pad).getWidth();
        int ySize = this.getPad(pad).getHeight();
        can.setPreferredSize(new Dimension((int)((double)xSize * scale), (int)((double)ySize * scale)));
        can.setMinimumSize(new Dimension((int)((double)xSize * scale), (int)((double)ySize * scale)));
        can.setSize(new Dimension((int)((double)xSize * scale), (int)((double)ySize * scale)));
        can.setChild(true);
        ArrayList<EmbeddedPad> pads = new ArrayList<EmbeddedPad>();
        pads.add(embeddedPad);
        can.canvasPads = pads;
        return can.getScreenShot();
    }

    public void copyToClipboard() {
        TransferableImage trans = new TransferableImage(this.getScreenShot());
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(trans, null);
    }

    private void copyToClipboard(int popupPad) {
        TransferableImage trans = new TransferableImage(this.getScreenShot(popupPad));
        trans.setPad(this.getPad(popupPad));
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(trans, null);
    }

    public void save(String filename) {
        File imageFile = new File(filename);
        try {
            imageFile.createNewFile();
            ImageIO.write((RenderedImage)this.getScreenShot(), "png", imageFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 400);
        EmbeddedCanvas canvas = new EmbeddedCanvas();
        canvas.setAxisFontSize(14);
        H1F h2b = FunctionFactory.randomGausian(100, 0.4, 5.6, 80000, 4.0, 0.8);
        H2F h2d = FunctionFactory.randomGausian2D(24, 0.4, 5.6, 800000, 2.3, 0.8);
        H2F h2d2 = new H2F("h2d2", 100, -180.0, 180.0, 24, -180.0, 180.0);
        DataGroup group = new DataGroup(2, 1);
        h2b.setName("h2b");
        GraphErrors hprofile = h2d.getProfileX();
        group.addDataSet(h2d, 0);
        group.addDataSet(hprofile, 1);
        for (int i = 0; i < 20000; ++i) {
            h2d2.fill(Math.random() * 360.0 - 180.0, Math.random() * 360.0 - 180.0);
        }
        canvas.draw(h2d2);
        frame.add(canvas);
        frame.pack();
        frame.setVisible(true);
    }

    public boolean isChild() {
        return this.isChild;
    }

    public void setChild(boolean isChild) {
        this.isChild = isChild;
    }

    public void setFont(String fontName) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setFontNameAll(fontName);
        }
    }

    public void setTitleSize(int fontSize) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setTitleFontSize(fontSize);
        }
    }

    public void setAxisLabelSize(int fontSize) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setAxisLabelFontSize(fontSize);
        }
    }

    public void setAxisTitleSize(int fontSize) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setAxisTitleFontSize(fontSize);
        }
    }

    public void setStatBoxFontSize(int fontSize) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setStatBoxFontSize(fontSize);
        }
    }

    public void setPadTitles(String title) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.setTitle(title);
        }
    }

    public void setPadTitlesX(String title) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.getAxisY().setTitle(title);
        }
    }

    public void setPadTitlesY(String title) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.getAxisY().setTitle(title);
        }
    }

    public void setGridX(boolean isGrid) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.getAxisX().setGrid(isGrid);
        }
    }

    public void setGridY(boolean isGrid) {
        for (EmbeddedPad pad : this.canvasPads) {
            pad.getAxisY().setGrid(isGrid);
        }
    }
}

