/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.data;

import org.jlab.groot.base.DatasetAttributes;
import org.jlab.groot.base.GStyle;
import org.jlab.groot.data.DataVector;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.io.TextFileReader;
import org.jlab.groot.math.Func1D;
import org.jlab.groot.ui.PaveText;

public class GraphErrors
implements IDataSet {
    public static final String[] MARKERNAME = new String[]{"Circle", "Square", "Triangle", "Inverted Triangle"};
    private final DataVector dataX = new DataVector();
    private final DataVector dataY = new DataVector();
    private final DataVector dataEX = new DataVector();
    private final DataVector dataEY = new DataVector();
    private String graphName = "graphErrors";
    private DatasetAttributes graphAttr = null;
    private Func1D fitFunction = null;

    public GraphErrors() {
        this.initAttributes();
    }

    public GraphErrors(String name, double[] x, double[] y, double[] ex, double[] ey) {
        this.setName(name);
        for (int i = 0; i < x.length; ++i) {
            this.addPoint(x[i], y[i], ex[i], ey[i]);
        }
        this.initAttributes();
    }

    public GraphErrors(String name, double[] x, double[] y) {
        this.setName(name);
        for (int i = 0; i < x.length; ++i) {
            this.addPoint(x[i], y[i], 0.0, 0.0);
        }
        this.initAttributes();
    }

    public GraphErrors(String name) {
        this.graphName = name;
        this.initAttributes();
    }

    private void initAttributes() {
        try {
            this.graphAttr = GStyle.getGraphErrorsAttributes().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public Func1D getFunction() {
        return this.fitFunction;
    }

    public void setFunction(Func1D func) {
        this.fitFunction = func;
        func.getAttributes().setOptStat(this.getAttributes().getOptStat());
    }

    public final void addPoint(double x, double y, double ex, double ey) {
        this.dataX.add(x);
        this.dataY.add(y);
        this.dataEX.add(ex);
        this.dataEY.add(ey);
    }

    public void setPoint(int point, double x, double y) {
        this.dataX.set(point, x);
        this.dataY.set(point, y);
    }

    public void setError(int point, double ex, double ey) {
        this.dataEX.set(point, ex);
        this.dataEY.set(point, ey);
    }

    @Override
    public void setName(String name) {
        this.graphName = name;
    }

    @Override
    public String getName() {
        return this.graphName;
    }

    @Override
    public int getDataSize(int axis) {
        return this.dataX.getSize();
    }

    @Override
    public DatasetAttributes getAttributes() {
        return this.graphAttr;
    }

    @Override
    public double getDataX(int bin) {
        return this.dataX.getValue(bin);
    }

    @Override
    public double getDataY(int bin) {
        return this.dataY.getValue(bin);
    }

    @Override
    public double getDataEX(int bin) {
        return this.dataEX.getValue(bin);
    }

    @Override
    public double getDataEY(int bin) {
        return this.dataEY.getValue(bin);
    }

    @Override
    public double getData(int xbin, int ybin) {
        return 0.0;
    }

    @Override
    public PaveText getStatBox() {
        return new PaveText(2);
    }

    public DataVector getVectorX() {
        return this.dataX;
    }

    public DataVector getVectorY() {
        return this.dataY;
    }

    public void setMarkerSize(int size) {
        this.graphAttr.setMarkerSize(size);
    }

    public int getMarkerSize() {
        return this.graphAttr.getMarkerSize();
    }

    public void setMarkerStyle(int style) {
        this.graphAttr.setMarkerStyle(style);
    }

    public int getMarkerStyle() {
        return this.graphAttr.getMarkerStyle();
    }

    public int getMarkerColor() {
        return this.graphAttr.getMarkerColor();
    }

    public void setMarkerColor(int color) {
        this.graphAttr.setMarkerColor(color);
    }

    public void setLineColor(int color) {
        this.graphAttr.setLineColor(color);
    }

    public int getLineColor() {
        return this.graphAttr.getLineColor();
    }

    public void setLineThickness(int thickness) {
        this.graphAttr.setLineWidth(thickness);
    }

    public int getLineThickness() {
        return this.graphAttr.getLineWidth();
    }

    public String getTitle() {
        return this.graphAttr.getTitle();
    }

    public String getTitleX() {
        return this.graphAttr.getTitleX();
    }

    public String getTitleY() {
        return this.graphAttr.getTitleY();
    }

    public void setTitle(String title) {
        this.graphAttr.setTitle(title);
    }

    public void setTitleX(String title) {
        this.graphAttr.setTitleX(title);
    }

    public void setTitleY(String title) {
        this.graphAttr.setTitleY(title);
    }

    public void copy(GraphErrors gr) {
        this.dataEX.clear();
        this.dataEY.clear();
        this.dataX.clear();
        this.dataY.clear();
        for (int i = 0; i < gr.getDataSize(0); ++i) {
            this.addPoint(gr.getDataX(i), gr.getDataY(i), gr.getDataEX(i), gr.getDataEY(i));
        }
    }

    public void readFile(String filename) {
        TextFileReader reader = new TextFileReader();
        reader.openFile(filename);
        this.reset();
        while (reader.readNext()) {
            double[] points;
            int[] index;
            if (reader.getDataSize() == 2) {
                index = new int[]{0, 1};
                points = reader.getAsDouble(index);
                this.addPoint(points[0], points[1], 0.0, 0.0);
            }
            if (reader.getDataSize() == 3) {
                index = new int[]{0, 1, 2};
                points = reader.getAsDouble(index);
                this.addPoint(points[0], points[1], 0.0, points[2]);
            }
            if (reader.getDataSize() <= 3) continue;
            index = new int[]{0, 1, 2, 3};
            points = reader.getAsDouble(index);
            this.addPoint(points[0], points[1], points[2], points[3]);
        }
    }

    @Override
    public void reset() {
        this.dataX.clear();
        this.dataY.clear();
        this.dataEX.clear();
        this.dataEY.clear();
    }
}

