/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import jas2.hist.HasStatistics;
import jas2.hist.HasStyle;
import jas2.hist.JASHist1DHistogramStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.ScatterEnumeration;
import jas2.hist.Statistics;
import jas2.hist.XYDataSource;
import jasext.jhplotserver.ScatterDataWithType;
import jhplot.P1D;

public class RefP1D
extends ScatterDataWithType
implements XYDataSource,
HasStyle,
HasStatistics,
Statistics {
    protected double[] x;
    protected double[] y;
    protected double npoints;
    private P1D h;
    private final String type = "scatter";

    public RefP1D(P1D h) {
        this.h = h;
    }

    public int getSize() {
        return this.h.size();
    }

    @Override
    public String getType() {
        return "scatter";
    }

    public boolean isRebinnable() {
        return true;
    }

    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.h.getTitle();
    }

    @Override
    public Statistics getStatistics() {
        return this;
    }

    @Override
    public String[] getStatisticNames() {
        return new String[]{"Entries", "Mean_X", "RMS_X", "Mean_Y", "RMS_Y"};
    }

    private double meanX() {
        return this.h.meanX();
    }

    public double rmsX() {
        return this.h.rmsX();
    }

    private double meanY() {
        return this.h.meanY();
    }

    public double rmsY() {
        return this.h.rmsY();
    }

    @Override
    public double getStatistic(String name) {
        if (name.equals("Entries")) {
            return this.h.size();
        }
        if (name.equals("Mean_X")) {
            return this.meanX();
        }
        if (name.equals("RMS_X")) {
            return this.rmsX();
        }
        if (name.equals("Mean_Y")) {
            return this.meanY();
        }
        if (name.equals("RMS_Y")) {
            return this.rmsY();
        }
        return 0.0;
    }

    public double getXMin() {
        return this.h.getMax(0);
    }

    public double getXMax() {
        return this.h.getMax(0);
    }

    public double getYMin() {
        return this.h.getMin(1);
    }

    public double getYMax() {
        return this.h.getMax(1);
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public ScatterEnumeration startEnumeration() {
        return new TestEnumeration();
    }

    public ScatterEnumeration startEnumeration(double a, double b, double c, double d) {
        return new TestEnumeration(a, b, c, d);
    }

    @Override
    public int getNPoints() {
        return this.h.size();
    }

    @Override
    public double getX(int index) {
        return this.h.getX(index);
    }

    @Override
    public double getY(int index) {
        return this.h.getY(index);
    }

    @Override
    public double getPlusError(int index) {
        return this.h.getYupper(index);
    }

    @Override
    public double getMinusError(int index) {
        if (this.h.getDimension() > 3) {
            return this.h.getYlower(index);
        }
        return this.h.getYupper(index);
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    @Override
    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowHistogramBars(false);
        style.setShowDataPoints(true);
        style.setShowLinesBetweenPoints(false);
        style.setShowErrorBars(true);
        return style;
    }

    private class TestEnumeration
    implements ScatterEnumeration {
        private int n;
        private boolean limits;
        private double ymin;
        private double ymax;
        private double xmin;
        private double xmax;

        TestEnumeration() {
            this.n = 0;
            this.limits = false;
        }

        TestEnumeration(double xmin, double xmax, double ymin, double ymax) {
            this.n = 0;
            this.xmin = xmin;
            this.xmax = xmax;
            this.ymin = ymin;
            this.ymax = ymax;
            this.limits = true;
        }

        @Override
        public boolean getNextPoint(double[] d) {
            if (this.limits) {
                while ((double)this.n < RefP1D.this.npoints) {
                    if (RefP1D.this.x[this.n] >= this.xmin && RefP1D.this.x[this.n] < this.xmax && RefP1D.this.y[this.n] >= this.ymin && RefP1D.this.y[this.n] < this.ymax) {
                        d[0] = RefP1D.this.x[this.n];
                        d[1] = RefP1D.this.y[this.n];
                        ++this.n;
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }
            if ((double)this.n == RefP1D.this.npoints) {
                return false;
            }
            d[0] = RefP1D.this.x[this.n];
            d[1] = RefP1D.this.y[this.n];
            ++this.n;
            return true;
        }

        @Override
        public void resetEndPoint() {
        }

        @Override
        public void restart() {
            this.n = 0;
        }
    }
}

