/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import hep.aida.ref.histogram.Histogram2D;
import jas2.hist.HasStatistics;
import jas2.hist.HasStyle;
import jas2.hist.JASHist2DHistogramStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.hist.Statistics;
import jasext.jhplotserver.Rebinnable2DHistogramDataWithType;

class RefH2D
extends Rebinnable2DHistogramDataWithType
implements Rebinnable2DHistogramData,
HasStatistics,
HasStyle,
Statistics {
    private Histogram2D h;
    private final String type = "histogram2D";

    public RefH2D(Histogram2D h) {
        this.h = h;
    }

    public int getSize() {
        return 0;
    }

    @Override
    public double[][][] rebin(int xbins, double p2, double p3, int ybins, double p6, double p7, boolean p4, boolean p5, boolean p8) {
        int ibinsX = this.h.xAxis().bins();
        int ibinsY = this.h.yAxis().bins();
        double[][] newHeights = new double[ibinsX][ibinsY];
        double[][] newErrors = new double[ibinsX][ibinsY];
        for (int i = 0; i < ibinsX - 1; ++i) {
            for (int j = 0; j < ibinsY - 1; ++j) {
                newHeights[i][j] = this.h.binHeight(i + 1, j + 1);
                newErrors[i][j] = this.h.binError(i + 1, j + 1);
            }
        }
        return new double[][][]{newHeights, newErrors};
    }

    @Override
    public String getType() {
        return "histogram2D";
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return 1;
    }

    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.h.title();
    }

    @Override
    public Statistics getStatistics() {
        return this;
    }

    @Override
    public String[] getStatisticNames() {
        return new String[]{"Entries", "Mean_X", "RMS_X", "Mean_Y", "RMS_Y"};
    }

    private double meanX() {
        return this.h.meanX();
    }

    public double rmsX() {
        return this.h.rmsX();
    }

    private double meanY() {
        return this.h.meanY();
    }

    public double rmsY() {
        return this.h.rmsY();
    }

    @Override
    public double getStatistic(String name) {
        if (name.equals("Entries")) {
            return this.h.allEntries();
        }
        if (name.equals("Mean_X")) {
            return this.meanX();
        }
        if (name.equals("RMS_X")) {
            return this.rmsX();
        }
        if (name.equals("Mean_Y")) {
            return this.meanY();
        }
        if (name.equals("RMS_Y")) {
            return this.rmsY();
        }
        return 0.0;
    }

    @Override
    public double getXMin() {
        return this.h.xAxis().lowerEdge();
    }

    @Override
    public double getXMax() {
        return this.h.xAxis().upperEdge();
    }

    @Override
    public double getYMin() {
        return this.h.xAxis().lowerEdge();
    }

    @Override
    public double getYMax() {
        return this.h.xAxis().upperEdge();
    }

    @Override
    public int getXBins() {
        return this.h.xAxis().bins();
    }

    @Override
    public int getYBins() {
        return this.h.yAxis().bins();
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 1;
    }

    @Override
    public String[] getXAxisLabels() {
        return null;
    }

    @Override
    public String[] getYAxisLabels() {
        return null;
    }

    @Override
    public JASHistStyle getStyle() {
        JASHist2DHistogramStyle style = new JASHist2DHistogramStyle();
        return style;
    }
}

