/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.FunctionAdvancedOptions;
import jas2.hist.JASHist;
import jas2.hist.JASHistPropertyDialog;
import jas2.util.JASDialog;
import jas2.util.JASTextField;
import jasext.hist.function.AbstractPolynomialFunction;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PolynomialFunction
extends AbstractPolynomialFunction
implements FunctionAdvancedOptions {
    private static final long serialVersionUID = 1L;

    PolynomialFunction(double[] coefficients) {
        this.order = coefficients.length - 1;
        this.p = coefficients;
    }

    public PolynomialFunction(double xmin, double xmax, double ymin, double ymax) {
        this.order = 2;
        this.p = new double[3];
        double xVertex = (xmax - xmin) / 2.0;
        this.p[0] = (ymax - ymin) / Math.pow(xmax - xVertex, 2.0);
        this.p[1] = -this.p[0] * (xmax - xmin);
        this.p[2] = ymin - this.p[0] * xVertex * xVertex - this.p[1] * xVertex;
    }

    @Override
    public void openAdvancedDialog(Frame f, JASHist hist) {
        new PolynomialFunctionAdvancedDialog(f);
    }

    private class PolynomialFunctionAdvancedDialog
    extends JASDialog {
        private static final long serialVersionUID = 1L;
        private JASTextField tf;
        private Frame f;
        private JASHistPropertyDialog pd;

        PolynomialFunctionAdvancedDialog(Frame f) {
            super(f, "Advanced...", true, 1);
            this.f = f;
            Container c = this.getContentPane();
            JPanel p = new JPanel(new GridLayout(4, 1));
            p.add(new JLabel("Set the order of the polynomial.  "));
            p.add(new JLabel("Note that changing the order will "));
            p.add(new JLabel("erase all existing polynomial "));
            p.add(new JLabel("coefficients."));
            this.tf = new JASTextField(String.valueOf(PolynomialFunction.this.order));
            c.add("North", p);
            c.add("South", this.tf);
            this.pack();
            this.doModal();
        }

        @Override
        public void onOK() {
            try {
                int temp = Integer.parseInt(this.tf.getText());
                if (temp < 2) {
                    JOptionPane.showMessageDialog(this.f, "Order must be at least 2", "Error", 0);
                    return;
                }
                if (temp != PolynomialFunction.this.order) {
                    PolynomialFunction.this.order = temp;
                    PolynomialFunction.this.clearFitParams();
                    PolynomialFunction.this.clearFit();
                    PolynomialFunction.this.p = new double[PolynomialFunction.this.order + 1];
                    for (int i = 0; i < PolynomialFunction.this.p.length; ++i) {
                        PolynomialFunction.this.p[i] = Math.random() * (Math.random() > 0.5 ? 5.0 : -2.0);
                    }
                    PolynomialFunction.this.setChanged();
                    this.dispose();
                } else {
                    this.dispose();
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.f, "Incorrect number format", "Error...", 0);
            }
        }
    }
}

