/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.Handle;
import jas2.hist.HasHandles;

public class ExponentialFunction
extends Fittable1DFunction
implements HasHandles {
    private static final long serialVersionUID = 1L;
    private double max;
    private double origin;
    private double exponent;

    ExponentialFunction(double amplitude, double origin, double exponent) {
        this.max = amplitude;
        this.origin = origin;
        this.exponent = exponent;
    }

    public ExponentialFunction(double xmin, double xmax, double ymin, double ymax) {
        this.max = ymin + (ymax - ymin) * 0.8;
        this.origin = xmin + (xmax - xmin) * 0.05;
        this.exponent = -(xmax - xmin) / (Math.log(ymax) - Math.log(ymin + 0.05 * ymax));
    }

    @Override
    public double valueAt(double x) {
        return this.max * Math.exp((x - this.origin) / this.exponent);
    }

    @Override
    public double valueAt(double x, double[] a) {
        return a[0] * Math.exp((x - a[1]) / a[2]);
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[]{"amplitude", "origin", "exponent"};
        return result;
    }

    @Override
    public double[] getParameterValues() {
        double[] result = new double[]{this.max, this.origin, this.exponent};
        return result;
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.max = value;
        } else if (index == 1) {
            this.origin = value;
        } else if (index == 2) {
            this.exponent = value;
        } else {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    @Override
    public void setFit(Fitter fit, double[] value) {
        if (value.length != 3) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.max = value[0];
        this.origin = value[1];
        this.exponent = value[2];
        this.setFit(fit);
        this.setChanged();
    }

    @Override
    public String getTitle() {
        return "Exponential";
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        Handle[] result = new Handle[]{new Handle(){

            @Override
            public void moveTo(double x, double y) {
                ExponentialFunction.this.origin = x;
                ExponentialFunction.this.max = y;
                ExponentialFunction.this.clearFit();
                ExponentialFunction.this.setChanged();
            }

            @Override
            public double getX() {
                return ExponentialFunction.this.origin;
            }

            @Override
            public double getY() {
                return ExponentialFunction.this.max;
            }
        }, new Handle(){

            @Override
            public void moveTo(double x, double y) {
                ExponentialFunction.this.exponent = (x - ExponentialFunction.this.origin) / Math.log(y / ExponentialFunction.this.max);
                ExponentialFunction.this.clearFit();
                ExponentialFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return ExponentialFunction.this.max * 0.367;
            }

            @Override
            public double getX() {
                return ExponentialFunction.this.origin - ExponentialFunction.this.exponent;
            }
        }};
        return result;
    }
}

